/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyTile;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.transmitters.ITransmitterTile;
import mekanism.common.base.IEnergyWrapper;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityElectricBlock
extends TileEntityContainerBlock
implements IEnergyWrapper {
    public double electricityStored;
    public double BASE_MAX_ENERGY;
    public double maxEnergy;
    public boolean ic2Registered = false;

    public TileEntityElectricBlock(String name, double baseMaxEnergy) {
        super(name);
        this.maxEnergy = this.BASE_MAX_ENERGY = baseMaxEnergy;
    }

    @Optional.Method(modid="IC2")
    public void register() {
        TileEntity registered;
        if (!this.field_145850_b.field_72995_K && (registered = EnergyNet.instance.getTileEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) != this) {
            if (registered instanceof IEnergyTile) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)registered));
            } else if (registered == null) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
                this.ic2Registered = true;
            }
        }
    }

    @Optional.Method(modid="IC2")
    public void deregister() {
        TileEntity registered;
        if (!this.field_145850_b.field_72995_K && (registered = EnergyNet.instance.getTileEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) instanceof IEnergyTile) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)registered));
        }
    }

    @Override
    public void onUpdate() {
        if (!this.ic2Registered && MekanismUtils.useIC2()) {
            this.register();
        }
    }

    @Override
    public EnumSet<ForgeDirection> getOutputtingSides() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Override
    public EnumSet<ForgeDirection> getConsumingSides() {
        EnumSet<ForgeDirection> set = EnumSet.allOf(ForgeDirection.class);
        set.remove(ForgeDirection.UNKNOWN);
        return set;
    }

    @Override
    public double getMaxOutput() {
        return 0.0;
    }

    @Override
    public double getEnergy() {
        return this.electricityStored;
    }

    @Override
    public void setEnergy(double energy) {
        this.electricityStored = Math.max(Math.min(energy, this.getMaxEnergy()), 0.0);
        MekanismUtils.saveChunk(this);
    }

    @Override
    public double getMaxEnergy() {
        return this.maxEnergy;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        this.setEnergy(dataStream.readDouble());
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.getEnergy());
        return data;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (MekanismUtils.useIC2()) {
            this.register();
        }
    }

    public void onChunkUnload() {
        if (MekanismUtils.useIC2()) {
            this.deregister();
        }
        super.onChunkUnload();
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (MekanismUtils.useIC2()) {
            this.deregister();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.electricityStored = nbtTags.func_74769_h("electricityStored");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74780_a("electricityStored", this.getEnergy());
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.getEnergy() * (double)i / this.getMaxEnergy());
    }

    @Optional.Method(modid="CoFHCore")
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.getConsumingSides().contains(from)) {
            double toAdd = (int)Math.min(this.getMaxEnergy() - this.getEnergy(), (double)maxReceive * MekanismConfig.general.FROM_TE);
            if (!simulate) {
                this.setEnergy(this.getEnergy() + toAdd);
            }
            return (int)Math.round(toAdd * MekanismConfig.general.TO_TE);
        }
        return 0;
    }

    @Optional.Method(modid="CoFHCore")
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.getOutputtingSides().contains(from)) {
            double toSend = Math.min(this.getEnergy(), Math.min(this.getMaxOutput(), (double)maxExtract * MekanismConfig.general.FROM_TE));
            if (!simulate) {
                this.setEnergy(this.getEnergy() - toSend);
            }
            return (int)Math.round(toSend * MekanismConfig.general.TO_TE);
        }
        return 0;
    }

    @Optional.Method(modid="CoFHCore")
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.getConsumingSides().contains(from) || this.getOutputtingSides().contains(from);
    }

    @Optional.Method(modid="CoFHCore")
    public int getEnergyStored(ForgeDirection from) {
        return (int)Math.round(this.getEnergy() * MekanismConfig.general.TO_TE);
    }

    @Optional.Method(modid="CoFHCore")
    public int getMaxEnergyStored(ForgeDirection from) {
        return (int)Math.round(this.getMaxEnergy() * MekanismConfig.general.TO_TE);
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public int getSourceTier() {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public void setStored(int energy) {
        this.setEnergy((double)energy * MekanismConfig.general.FROM_IC2);
    }

    @Optional.Method(modid="IC2")
    public int addEnergy(int amount) {
        this.setEnergy(this.getEnergy() + (double)amount * MekanismConfig.general.FROM_IC2);
        return (int)Math.round(this.getEnergy() * MekanismConfig.general.TO_IC2);
    }

    @Optional.Method(modid="IC2")
    public boolean isTeleporterCompatible(ForgeDirection side) {
        return this.getOutputtingSides().contains(side);
    }

    @Override
    public boolean canOutputTo(ForgeDirection side) {
        return this.getOutputtingSides().contains(side);
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return this.getConsumingSides().contains(direction);
    }

    @Optional.Method(modid="IC2")
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return this.getOutputtingSides().contains(direction) && receiver instanceof IEnergyConductor;
    }

    @Optional.Method(modid="IC2")
    public int getStored() {
        return (int)Math.round(this.getEnergy() * MekanismConfig.general.TO_IC2);
    }

    @Optional.Method(modid="IC2")
    public int getCapacity() {
        return (int)Math.round(this.getMaxEnergy() * MekanismConfig.general.TO_IC2);
    }

    @Optional.Method(modid="IC2")
    public int getOutput() {
        return (int)Math.round(this.getMaxOutput() * MekanismConfig.general.TO_IC2);
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        return (this.getMaxEnergy() - this.getEnergy()) * MekanismConfig.general.TO_IC2;
    }

    @Optional.Method(modid="IC2")
    public double getOfferedEnergy() {
        return Math.min(this.getEnergy(), this.getMaxOutput()) * MekanismConfig.general.TO_IC2;
    }

    @Override
    public boolean canReceiveEnergy(ForgeDirection side) {
        return this.getConsumingSides().contains(side);
    }

    @Optional.Method(modid="IC2")
    public double getOutputEnergyUnitsPerTick() {
        return this.getMaxOutput() * MekanismConfig.general.TO_IC2;
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(ForgeDirection direction, double amount, double voltage) {
        if (Coord4D.get(this).getFromSide(direction).getTileEntity((IBlockAccess)this.field_145850_b) instanceof ITransmitterTile) {
            return amount;
        }
        return amount - this.transferEnergyToAcceptor(direction, amount * MekanismConfig.general.FROM_IC2) * MekanismConfig.general.TO_IC2;
    }

    @Optional.Method(modid="IC2")
    public void drawEnergy(double amount) {
        this.setEnergy(Math.max(this.getEnergy() - amount * MekanismConfig.general.FROM_IC2, 0.0));
    }

    @Override
    public double transferEnergyToAcceptor(ForgeDirection side, double amount) {
        if (!this.getConsumingSides().contains(side) && side != ForgeDirection.UNKNOWN) {
            return 0.0;
        }
        double toUse = Math.min(this.getMaxEnergy() - this.getEnergy(), amount);
        this.setEnergy(this.getEnergy() + toUse);
        return toUse;
    }
}

