/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.MekanismConfig;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.Mekanism;
import mekanism.common.content.matrix.MatrixCache;
import mekanism.common.content.matrix.MatrixUpdateProtocol;
import mekanism.common.content.matrix.SynchronizedMatrixData;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;

@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")
public class TileEntityInductionCasing
extends TileEntityMultiblock<SynchronizedMatrixData>
implements IStrictEnergyStorage,
IPeripheral {
    public int clientCells;
    public int clientProviders;
    public static final String[] NAMES = new String[]{"getEnergyStored", "getMaxEnergyStored", "getEnergyStoredMJ", "getMaxEnergyStoredMJ", "getLastOutput", "getOutputCap"};

    public TileEntityInductionCasing() {
        this("InductionCasing");
    }

    public TileEntityInductionCasing(String name) {
        super(name);
        this.inventory = new ItemStack[2];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K && this.structure != null && this.isRendering) {
            ((SynchronizedMatrixData)this.structure).lastOutput = ((SynchronizedMatrixData)this.structure).outputCap - ((SynchronizedMatrixData)this.structure).remainingOutput;
            ((SynchronizedMatrixData)this.structure).remainingOutput = ((SynchronizedMatrixData)this.structure).outputCap;
            ChargeUtils.charge(0, this);
            ChargeUtils.discharge(1, this);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.structure != null) {
            data.add(((SynchronizedMatrixData)this.structure).getEnergy(this.field_145850_b));
            data.add(((SynchronizedMatrixData)this.structure).storageCap);
            data.add(((SynchronizedMatrixData)this.structure).outputCap);
            data.add(((SynchronizedMatrixData)this.structure).lastOutput);
            data.add(((SynchronizedMatrixData)this.structure).volWidth);
            data.add(((SynchronizedMatrixData)this.structure).volHeight);
            data.add(((SynchronizedMatrixData)this.structure).volLength);
            data.add(((SynchronizedMatrixData)this.structure).cells.size());
            data.add(((SynchronizedMatrixData)this.structure).providers.size());
        }
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.clientHasStructure) {
            ((SynchronizedMatrixData)this.structure).clientEnergy = dataStream.readDouble();
            ((SynchronizedMatrixData)this.structure).storageCap = dataStream.readDouble();
            ((SynchronizedMatrixData)this.structure).outputCap = dataStream.readDouble();
            ((SynchronizedMatrixData)this.structure).lastOutput = dataStream.readDouble();
            ((SynchronizedMatrixData)this.structure).volWidth = dataStream.readInt();
            ((SynchronizedMatrixData)this.structure).volHeight = dataStream.readInt();
            ((SynchronizedMatrixData)this.structure).volLength = dataStream.readInt();
            this.clientCells = dataStream.readInt();
            this.clientProviders = dataStream.readInt();
        }
    }

    @Override
    protected SynchronizedMatrixData getNewStructure() {
        return new SynchronizedMatrixData();
    }

    public MatrixCache getNewCache() {
        return new MatrixCache();
    }

    protected MatrixUpdateProtocol getProtocol() {
        return new MatrixUpdateProtocol(this);
    }

    @Override
    public MultiblockManager<SynchronizedMatrixData> getManager() {
        return Mekanism.matrixManager;
    }

    @Override
    public String func_145825_b() {
        return LangUtils.localize("gui.inductionMatrix");
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.getEnergy() * (double)i / this.getMaxEnergy());
    }

    @Override
    public double getEnergy() {
        if (!this.field_145850_b.field_72995_K) {
            return this.structure != null ? ((SynchronizedMatrixData)this.structure).getEnergy(this.field_145850_b) : 0.0;
        }
        return ((SynchronizedMatrixData)this.structure).clientEnergy;
    }

    @Override
    public void setEnergy(double energy) {
        if (this.structure != null) {
            ((SynchronizedMatrixData)this.structure).setEnergy(this.field_145850_b, Math.max(Math.min(energy, this.getMaxEnergy()), 0.0));
            MekanismUtils.saveChunk(this);
        }
    }

    @Override
    public double getMaxEnergy() {
        return this.structure != null ? ((SynchronizedMatrixData)this.structure).storageCap : 0.0;
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return "Mekanism-InductionMatrix";
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return NAMES;
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (this.structure == null) {
            return new Object[]{"Unformed."};
        }
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy() * MekanismConfig.general.TO_TE};
            }
            case 1: {
                return new Object[]{this.getMaxEnergy() * MekanismConfig.general.TO_TE};
            }
            case 2: {
                return new Object[]{this.getEnergy()};
            }
            case 3: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 4: {
                return new Object[]{((SynchronizedMatrixData)this.structure).lastOutput};
            }
            case 5: {
                return new Object[]{((SynchronizedMatrixData)this.structure).outputCap};
            }
        }
        Mekanism.logger.error("Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return this == other;
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }
}

