/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.Tier;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityInductionCell
extends TileEntityBasicBlock
implements IStrictEnergyStorage {
    public Tier.InductionCellTier tier = Tier.InductionCellTier.BASIC;
    public double electricityStored;

    @Override
    public void onUpdate() {
    }

    public boolean canUpdate() {
        return false;
    }

    public String getInventoryName() {
        return LangUtils.localize(this.func_145838_q().func_149739_a() + ".InductionCell" + this.tier.getBaseTier().getName() + ".name");
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        this.tier = Tier.InductionCellTier.values()[dataStream.readInt()];
        super.handlePacketData(dataStream);
        this.electricityStored = dataStream.readDouble();
        MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        data.add(this.tier.ordinal());
        super.getNetworkedData(data);
        data.add(this.electricityStored);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.tier = Tier.InductionCellTier.values()[nbtTags.func_74762_e("tier")];
        this.electricityStored = nbtTags.func_74769_h("electricityStored");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        nbtTags.func_74780_a("electricityStored", this.electricityStored);
    }

    @Override
    public double getEnergy() {
        return this.electricityStored;
    }

    @Override
    public void setEnergy(double energy) {
        this.electricityStored = Math.min(energy, this.getMaxEnergy());
    }

    @Override
    public double getMaxEnergy() {
        return this.tier.maxEnergy;
    }
}

