/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.BlockMachine;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityRotaryCondensentrator
extends TileEntityElectricBlock
implements IActiveState,
ISustainedData,
IFluidHandler,
IGasHandler,
ITubeConnection,
IRedstoneControl,
IUpgradeTile,
Upgrade.IUpgradeInfoHandler,
ITankManager {
    public GasTank gasTank = new GasTank(10000);
    public FluidTank fluidTank = new FluidTank(10000);
    public static final int MAX_FLUID = 10000;
    public int mode;
    public int gasOutput = 256;
    public int updateDelay;
    public boolean isActive;
    public boolean clientActive;
    public double prevEnergy;
    public final double BASE_ENERGY_USAGE;
    public double energyPerTick = this.BASE_ENERGY_USAGE = MekanismConfig.usage.rotaryCondensentratorUsage;
    public double clientEnergyUsed;
    public TileComponentUpgrade upgradeComponent = new TileComponentUpgrade(this, 5);
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;

    public TileEntityRotaryCondensentrator() {
        super("RotaryCondensentrator", BlockMachine.MachineType.ROTARY_CONDENSENTRATOR.baseEnergy);
        this.inventory = new ItemStack[6];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K && this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
                }
            }
            ChargeUtils.discharge(4, this);
            if (this.mode == 0) {
                if (this.inventory[1] != null && (this.gasTank.getGas() == null || this.gasTank.getStored() < this.gasTank.getMaxGas())) {
                    this.gasTank.receive(GasTransmission.removeGas(this.inventory[1], this.gasTank.getGasType(), this.gasTank.getNeeded()), true);
                }
                if (this.inventory[2] != null) {
                    ItemStack filled;
                    if (this.inventory[2].func_77973_b() instanceof IFluidContainerItem) {
                        int prev = this.fluidTank.getFluidAmount();
                        this.fluidTank.drain(FluidContainerUtils.insertFluid(this.fluidTank, this.inventory[2]), true);
                        if ((prev == this.fluidTank.getFluidAmount() || this.fluidTank.getFluidAmount() == 0) && this.inventory[3] == null) {
                            this.inventory[3] = this.inventory[2].func_77946_l();
                            this.inventory[2] = null;
                            this.func_70296_d();
                        }
                    } else if (FluidContainerRegistry.isEmptyContainer((ItemStack)this.inventory[2]) && this.fluidTank.getFluid() != null && this.fluidTank.getFluid().amount >= 1000 && (filled = FluidContainerRegistry.fillFluidContainer((FluidStack)this.fluidTank.getFluid(), (ItemStack)this.inventory[2])) != null && (this.inventory[3] == null || this.inventory[3].func_77969_a(filled) && this.inventory[3].field_77994_a + 1 <= filled.func_77976_d())) {
                        --this.inventory[2].field_77994_a;
                        if (this.inventory[2].field_77994_a <= 0) {
                            this.inventory[2] = null;
                        }
                        if (this.inventory[3] == null) {
                            this.inventory[3] = filled;
                        } else {
                            ++this.inventory[3].field_77994_a;
                        }
                        this.func_70296_d();
                        this.fluidTank.drain(FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount, true);
                    }
                }
                if (this.getEnergy() >= this.energyPerTick && MekanismUtils.canFunction(this) && this.isValidGas(this.gasTank.getGas()) && (this.fluidTank.getFluid() == null || this.fluidTank.getFluid().amount < 10000 && this.gasEquals(this.gasTank.getGas(), this.fluidTank.getFluid()))) {
                    int operations = this.getUpgradedUsage();
                    double prev = this.getEnergy();
                    this.setActive(true);
                    this.fluidTank.fill(new FluidStack(this.gasTank.getGas().getGas().getFluid(), operations), true);
                    this.gasTank.draw(operations, true);
                    this.setEnergy(this.getEnergy() - this.energyPerTick * (double)operations);
                    this.clientEnergyUsed = prev - this.getEnergy();
                } else if (this.prevEnergy >= this.getEnergy()) {
                    this.setActive(false);
                }
            } else if (this.mode == 1) {
                if (this.inventory[0] != null && this.gasTank.getGas() != null) {
                    this.gasTank.draw(GasTransmission.addGas(this.inventory[0], this.gasTank.getGas()), true);
                }
                if (this.gasTank.getGas() != null) {
                    GasStack toSend = new GasStack(this.gasTank.getGas().getGas(), Math.min(this.gasTank.getGas().amount, this.gasOutput));
                    TileEntity tileEntity = Coord4D.get(this).getFromSide(MekanismUtils.getLeft(this.facing)).getTileEntity((IBlockAccess)this.field_145850_b);
                    if (tileEntity instanceof IGasHandler && ((IGasHandler)tileEntity).canReceiveGas(MekanismUtils.getLeft(this.facing).getOpposite(), this.gasTank.getGas().getGas())) {
                        this.gasTank.draw(((IGasHandler)tileEntity).receiveGas(MekanismUtils.getLeft(this.facing).getOpposite(), toSend, true), true);
                    }
                }
                if (this.inventory[2] != null) {
                    if (this.inventory[2].func_77973_b() instanceof IFluidContainerItem) {
                        this.fluidTank.fill(FluidContainerUtils.extractFluid(this.fluidTank, this.inventory[2]), true);
                        if ((((IFluidContainerItem)this.inventory[2].func_77973_b()).getFluid(this.inventory[2]) == null || this.fluidTank.getFluidAmount() == this.fluidTank.getCapacity()) && this.inventory[3] == null) {
                            this.inventory[3] = this.inventory[2].func_77946_l();
                            this.inventory[2] = null;
                            this.func_70296_d();
                        }
                    } else if (FluidContainerRegistry.isFilledContainer((ItemStack)this.inventory[2])) {
                        FluidStack itemFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inventory[2]);
                        if (this.fluidTank.getFluid() == null && itemFluid.amount <= 10000 || this.fluidTank.getFluid().amount + itemFluid.amount <= 10000) {
                            if (this.fluidTank.getFluid() != null && !this.fluidTank.getFluid().isFluidEqual(itemFluid)) {
                                return;
                            }
                            ItemStack containerItem = this.inventory[2].func_77973_b().getContainerItem(this.inventory[2]);
                            boolean filled = false;
                            if (containerItem != null) {
                                if (this.inventory[3] == null || this.inventory[3].func_77969_a(containerItem) && this.inventory[3].field_77994_a + 1 <= containerItem.func_77976_d()) {
                                    this.inventory[2] = null;
                                    if (this.inventory[3] == null) {
                                        this.inventory[3] = containerItem;
                                    } else {
                                        ++this.inventory[3].field_77994_a;
                                    }
                                    filled = true;
                                }
                            } else {
                                --this.inventory[2].field_77994_a;
                                if (this.inventory[2].field_77994_a == 0) {
                                    this.inventory[2] = null;
                                }
                                filled = true;
                            }
                            if (filled) {
                                this.fluidTank.fill(itemFluid, true);
                                this.func_70296_d();
                            }
                        }
                    }
                }
                if (this.getEnergy() >= this.energyPerTick && MekanismUtils.canFunction(this) && this.isValidFluid(this.fluidTank.getFluid()) && (this.gasTank.getGas() == null || this.gasTank.getStored() < 10000 && this.gasEquals(this.gasTank.getGas(), this.fluidTank.getFluid()))) {
                    int operations = this.getUpgradedUsage();
                    double prev = this.getEnergy();
                    this.setActive(true);
                    this.gasTank.receive(new GasStack(GasRegistry.getGas(this.fluidTank.getFluid().getFluid()), operations), true);
                    this.fluidTank.drain(operations, true);
                    this.setEnergy(this.getEnergy() - this.energyPerTick * (double)operations);
                    this.clientEnergyUsed = prev - this.getEnergy();
                } else if (this.prevEnergy >= this.getEnergy()) {
                    this.setActive(false);
                }
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public int getUpgradedUsage() {
        int possibleProcess = (int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED));
        possibleProcess = this.mode == 0 ? Math.min(Math.min(this.gasTank.getStored(), this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount()), possibleProcess) : Math.min(Math.min(this.fluidTank.getFluidAmount(), this.gasTank.getNeeded()), possibleProcess);
        possibleProcess = Math.min((int)(this.getEnergy() / this.energyPerTick), possibleProcess);
        return possibleProcess;
    }

    public boolean isValidGas(GasStack g) {
        if (g == null) {
            return false;
        }
        return g.getGas().hasFluid();
    }

    public boolean gasEquals(GasStack gas, FluidStack fluid) {
        if (fluid == null || gas == null || !gas.getGas().hasFluid()) {
            return false;
        }
        return gas.getGas().getFluid() == fluid.getFluid();
    }

    public boolean isValidFluid(FluidStack f) {
        if (f == null) {
            return false;
        }
        return GasRegistry.getGas(f.getFluid()) != null;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.mode = this.mode == 0 ? 1 : 0;
            }
            for (EntityPlayer player : this.playersUsing) {
                Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), (EntityPlayerMP)player);
            }
            return;
        }
        super.handlePacketData(dataStream);
        this.mode = dataStream.readInt();
        this.isActive = dataStream.readBoolean();
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        this.clientEnergyUsed = dataStream.readDouble();
        if (dataStream.readBoolean()) {
            this.fluidTank.setFluid(new FluidStack(dataStream.readInt(), dataStream.readInt()));
        } else {
            this.fluidTank.setFluid(null);
        }
        if (dataStream.readBoolean()) {
            this.gasTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
        } else {
            this.gasTank.setGas(null);
        }
        MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.mode);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        data.add(this.clientEnergyUsed);
        if (this.fluidTank.getFluid() != null) {
            data.add(true);
            data.add(this.fluidTank.getFluid().fluidID);
            data.add(this.fluidTank.getFluid().amount);
        } else {
            data.add(false);
        }
        if (this.gasTank.getGas() != null) {
            data.add(true);
            data.add(this.gasTank.getGas().getGas().getID());
            data.add(this.gasTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.mode = nbtTags.func_74762_e("mode");
        this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
        if (nbtTags.func_74764_b("fluidTank")) {
            this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74768_a("mode", this.mode);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
        if (this.fluidTank.getFluid() != null) {
            nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public boolean canSetFacing(int i) {
        return i != 0 && i != 1;
    }

    public int getScaledFluidLevel(int i) {
        return this.fluidTank.getFluid() != null ? this.fluidTank.getFluid().amount * i / 10000 : 0;
    }

    public int getScaledGasLevel(int i) {
        return this.gasTank.getGas() != null ? this.gasTank.getStored() * i / 10000 : 0;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return side == MekanismUtils.getLeft(this.facing);
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        return this.gasTank.receive(stack, doTransfer);
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        return this.gasTank.draw(amount, doTransfer);
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return this.drawGas(side, amount, true);
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return this.mode == 1 && side == MekanismUtils.getLeft(this.facing) ? this.gasTank.canDraw(type) : false;
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return this.mode == 0 && side == MekanismUtils.getLeft(this.facing) ? this.gasTank.canReceive(type) : false;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.fluidTank.getFluid() != null) {
            itemStack.field_77990_d.func_74782_a("fluidTank", (NBTBase)this.fluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        if (this.gasTank.getGas() != null) {
            itemStack.field_77990_d.func_74782_a("gasTank", (NBTBase)this.gasTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("fluidTank")));
        this.gasTank.setGas(GasStack.readFromNBT(itemStack.field_77990_d.func_74775_l("gasTank")));
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.canFill(from, resource.getFluid())) {
            return this.fluidTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() == resource.getFluid()) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.mode == 1 && from == MekanismUtils.getRight(this.facing) && (this.fluidTank.getFluid() == null ? this.isValidFluid(new FluidStack(fluid, 1)) : this.fluidTank.getFluid().getFluid() == fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.mode == 0 && from == MekanismUtils.getRight(this.facing);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (from == MekanismUtils.getRight(this.facing)) {
            return new FluidTankInfo[]{this.fluidTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.canDrain(from, null)) {
            return this.fluidTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case ENERGY: {
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
                this.energyPerTick = MekanismUtils.getBaseEnergyPerTick(this, this.BASE_ENERGY_USAGE);
            }
        }
    }

    @Override
    public List<String> getInfo(Upgrade upgrade) {
        return upgrade == Upgrade.SPEED ? upgrade.getExpScaledInfo(this) : upgrade.getMultScaledInfo(this);
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.gasTank, this.fluidTank};
    }
}

