/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.Mekanism;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.machines.SolarNeutronRecipe;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenDesert;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySolarNeutronActivator
extends TileEntityContainerBlock
implements IRedstoneControl,
IBoundingBlock,
IGasHandler,
ITubeConnection,
IActiveState,
ISustainedData,
ITankManager {
    public GasTank inputTank = new GasTank(10000);
    public GasTank outputTank = new GasTank(10000);
    public static final int MAX_GAS = 10000;
    public static final int TICKS_REQUIRED = 5;
    public int updateDelay;
    public boolean isActive;
    public boolean clientActive;
    public int gasOutput = 256;
    public int recipeTicks = 0;
    public SolarNeutronRecipe cachedRecipe;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;

    public TileEntitySolarNeutronActivator() {
        super("SolarNeutronActivator");
        this.inventory = new ItemStack[3];
    }

    @Override
    public void onUpdate() {
        if (this.field_145850_b.field_72995_K && this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            boolean sky;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
                }
            }
            if (this.inventory[0] != null && (this.inputTank.getGas() == null || this.inputTank.getStored() < this.inputTank.getMaxGas())) {
                this.inputTank.receive(GasTransmission.removeGas(this.inventory[0], this.inputTank.getGasType(), this.inputTank.getNeeded()), true);
            }
            if (this.inventory[1] != null && this.outputTank.getGas() != null) {
                this.outputTank.draw(GasTransmission.addGas(this.inventory[1], this.outputTank.getGas()), true);
            }
            SolarNeutronRecipe recipe = this.getRecipe();
            boolean bl = sky = (!this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I() || this.isDesert()) && !this.field_145850_b.field_73011_w.field_76576_e && this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            if (this.field_145850_b.func_72935_r() && sky && this.canOperate(recipe) && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                if (this.recipeTicks == 5) {
                    this.operate(recipe);
                    this.recipeTicks = 0;
                } else {
                    ++this.recipeTicks;
                }
            } else {
                this.setActive(false);
                this.recipeTicks = 0;
            }
            if (this.outputTank.getGas() != null) {
                GasStack toSend = new GasStack(this.outputTank.getGas().getGas(), Math.min(this.outputTank.getStored(), this.gasOutput));
                TileEntity tileEntity = Coord4D.get(this).getFromSide(ForgeDirection.getOrientation((int)this.facing)).getTileEntity((IBlockAccess)this.field_145850_b);
                if (tileEntity instanceof IGasHandler && ((IGasHandler)tileEntity).canReceiveGas(ForgeDirection.getOrientation((int)this.facing).getOpposite(), this.outputTank.getGas().getGas())) {
                    this.outputTank.draw(((IGasHandler)tileEntity).receiveGas(ForgeDirection.getOrientation((int)this.facing).getOpposite(), toSend, true), true);
                }
            }
        }
    }

    public boolean isDesert() {
        return this.field_145850_b.field_73011_w.getBiomeGenForCoords(this.field_145851_c >> 4, this.field_145849_e >> 4) instanceof BiomeGenDesert;
    }

    public SolarNeutronRecipe getRecipe() {
        GasInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((GasInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getSolarNeutronRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    public GasInput getInput() {
        return new GasInput(this.inputTank.getGas());
    }

    public boolean canOperate(SolarNeutronRecipe recipe) {
        return recipe != null && recipe.canOperate(this.inputTank, this.outputTank);
    }

    public void operate(SolarNeutronRecipe recipe) {
        recipe.operate(this.inputTank, this.outputTank);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        this.isActive = dataStream.readBoolean();
        this.recipeTicks = dataStream.readInt();
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        if (dataStream.readBoolean()) {
            this.inputTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
        } else {
            this.inputTank.setGas(null);
        }
        if (dataStream.readBoolean()) {
            this.outputTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
        } else {
            this.outputTank.setGas(null);
        }
        MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.recipeTicks);
        data.add(this.controlType.ordinal());
        if (this.inputTank.getGas() != null) {
            data.add(true);
            data.add(this.inputTank.getGas().getGas().getID());
            data.add(this.inputTank.getStored());
        } else {
            data.add(false);
        }
        if (this.outputTank.getGas() != null) {
            data.add(true);
            data.add(this.outputTank.getGas().getGas().getID());
            data.add(this.outputTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
        this.recipeTicks = nbtTags.func_74762_e("recipeTicks");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.inputTank.read(nbtTags.func_74775_l("inputTank"));
        this.outputTank.read(nbtTags.func_74775_l("outputTank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("recipeTicks", this.recipeTicks);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74782_a("inputTank", (NBTBase)this.inputTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("outputTank", (NBTBase)this.outputTank.write(new NBTTagCompound()));
    }

    @Override
    public boolean canSetFacing(int i) {
        return i != 0 && i != 1;
    }

    @Override
    public void onPlace() {
        MekanismUtils.makeBoundingBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, Coord4D.get(this));
    }

    @Override
    public void onBreak() {
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack != null ? stack.getGas() : null)) {
            return this.inputTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.outputTank.draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return this.drawGas(side, amount, true);
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return side == ForgeDirection.DOWN && this.inputTank.canReceive(type);
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return side == ForgeDirection.getOrientation((int)this.facing) && this.outputTank.canDraw(type);
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return side == ForgeDirection.getOrientation((int)this.facing) || side == ForgeDirection.DOWN;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.inputTank.getGas() != null) {
            itemStack.field_77990_d.func_74782_a("inputTank", (NBTBase)this.inputTank.getGas().write(new NBTTagCompound()));
        }
        if (this.outputTank.getGas() != null) {
            itemStack.field_77990_d.func_74782_a("outputTank", (NBTBase)this.outputTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.inputTank.setGas(GasStack.readFromNBT(itemStack.field_77990_d.func_74775_l("inputTank")));
        this.outputTank.setGas(GasStack.readFromNBT(itemStack.field_77990_d.func_74775_l("outputTank")));
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.inputTank, this.outputTank};
    }
}

