/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.api.Chunk3D;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.PacketHandler;
import mekanism.common.block.BlockMachine;
import mekanism.common.chunkloading.IChunkLoader;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.network.PacketPortalFX;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;

@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")
public class TileEntityTeleporter
extends TileEntityElectricBlock
implements IPeripheral,
IChunkLoader {
    private MinecraftServer server = MinecraftServer.func_71276_C();
    public AxisAlignedBB teleportBounds = null;
    public Set<Entity> didTeleport = new HashSet<Entity>();
    public int teleDelay = 0;
    public boolean shouldRender;
    public boolean prevShouldRender;
    public String owner;
    public Frequency frequency;
    public List<Frequency> publicCache = new ArrayList<Frequency>();
    public List<Frequency> privateCache = new ArrayList<Frequency>();
    public ForgeChunkManager.Ticket chunkTicket;
    public byte status = 0;

    public TileEntityTeleporter() {
        super("Teleporter", BlockMachine.MachineType.TELEPORTER.baseEnergy);
        this.inventory = new ItemStack[1];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.teleportBounds == null) {
            this.resetBounds();
        }
        if (!this.field_145850_b.field_72995_K) {
            FrequencyManager manager;
            ForgeChunkManager.Ticket ticket;
            if (this.chunkTicket == null && (ticket = ForgeChunkManager.requestTicket((Object)Mekanism.instance, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL)) != null) {
                ticket.getModData().func_74768_a("xCoord", this.field_145851_c);
                ticket.getModData().func_74768_a("yCoord", this.field_145848_d);
                ticket.getModData().func_74768_a("zCoord", this.field_145849_e);
                this.forceChunks(ticket);
            }
            if ((manager = this.getManager(this.frequency)) != null) {
                if (this.frequency != null && !this.frequency.valid) {
                    this.frequency = manager.validateFrequency(this.owner, Coord4D.get(this), this.frequency);
                }
                if (this.frequency != null) {
                    this.frequency = manager.update(this.owner, Coord4D.get(this), this.frequency);
                }
            } else {
                this.frequency = null;
            }
            this.status = this.canTeleport();
            if (this.status == 1 && this.teleDelay == 0) {
                this.teleport();
            }
            if (this.teleDelay == 0 && this.didTeleport.size() > 0) {
                this.cleanTeleportCache();
            }
            boolean bl = this.shouldRender = this.status == 1 || this.status > 4;
            if (this.shouldRender != this.prevShouldRender) {
                Mekanism.packetHandler.sendToAllAround(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), Coord4D.get(this).getTargetPoint(40.0));
            }
            this.prevShouldRender = this.shouldRender;
            this.teleDelay = Math.max(0, this.teleDelay - 1);
        }
        ChargeUtils.discharge(0, this);
    }

    public Coord4D getClosest() {
        if (this.frequency != null) {
            return this.frequency.getClosestCoords(Coord4D.get(this));
        }
        return null;
    }

    public void setFrequency(String name, boolean publicFreq) {
        if (name.equals(this.frequency)) {
            return;
        }
        FrequencyManager manager = this.getManager(new Frequency(name, null).setPublic(publicFreq));
        manager.deactivate(Coord4D.get(this));
        for (Frequency freq : manager.getFrequencies()) {
            if (!freq.name.equals(name)) continue;
            this.frequency = freq;
            this.frequency.activeCoords.add(Coord4D.get(this));
            return;
        }
        Frequency freq = new Frequency(name, this.owner).setPublic(publicFreq);
        freq.activeCoords.add(Coord4D.get(this));
        manager.addFrequency(freq);
        this.frequency = freq;
        MekanismUtils.saveChunk(this);
    }

    public FrequencyManager getManager(Frequency freq) {
        if (this.owner == null || freq == null) {
            return null;
        }
        if (freq.isPublic()) {
            return Mekanism.publicTeleporters;
        }
        if (!Mekanism.privateTeleporters.containsKey(this.owner)) {
            FrequencyManager manager = new FrequencyManager(Frequency.class, this.owner);
            Mekanism.privateTeleporters.put(this.owner, manager);
            manager.createOrLoad(this.field_145850_b);
        }
        return Mekanism.privateTeleporters.get(this.owner);
    }

    public static FrequencyManager loadManager(String owner, World world) {
        if (Mekanism.privateTeleporters.containsKey(owner)) {
            return Mekanism.privateTeleporters.get(owner);
        }
        return FrequencyManager.loadOnly(world, owner, Frequency.class);
    }

    @Override
    public void onChunkUnload() {
        FrequencyManager manager;
        super.onChunkUnload();
        if (!this.field_145850_b.field_72995_K && this.frequency != null && (manager = this.getManager(this.frequency)) != null) {
            manager.deactivate(Coord4D.get(this));
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            FrequencyManager manager;
            this.releaseChunks();
            if (this.frequency != null && (manager = this.getManager(this.frequency)) != null) {
                manager.deactivate(Coord4D.get(this));
            }
        }
    }

    public void cleanTeleportCache() {
        List list = this.field_145850_b.func_72872_a(Entity.class, this.teleportBounds);
        Set teleportCopy = (Set)((HashSet)this.didTeleport).clone();
        for (Entity entity : teleportCopy) {
            if (list.contains(entity)) continue;
            this.didTeleport.remove(entity);
        }
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return true;
    }

    public void resetBounds() {
        this.teleportBounds = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 1));
    }

    public byte canTeleport() {
        if (!this.hasFrame()) {
            return 2;
        }
        if (this.getClosest() == null) {
            return 3;
        }
        List<Entity> entitiesInPortal = this.getToTeleport();
        Coord4D closestCoords = this.getClosest();
        int electricityNeeded = 0;
        for (Entity entity : entitiesInPortal) {
            electricityNeeded += this.calculateEnergyCost(entity, closestCoords);
        }
        if (this.getEnergy() < (double)electricityNeeded) {
            return 4;
        }
        return 1;
    }

    public void teleport() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        List<Entity> entitiesInPortal = this.getToTeleport();
        Coord4D closestCoords = this.getClosest();
        if (closestCoords == null) {
            return;
        }
        for (Entity entity : entitiesInPortal) {
            WorldServer teleWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(closestCoords.dimensionId);
            TileEntityTeleporter teleporter = (TileEntityTeleporter)closestCoords.getTileEntity((IBlockAccess)teleWorld);
            if (teleporter == null) continue;
            teleporter.didTeleport.add(entity);
            teleporter.teleDelay = 5;
            if (entity instanceof EntityPlayerMP) {
                TileEntityTeleporter.teleportPlayerTo((EntityPlayerMP)entity, closestCoords, teleporter);
            } else {
                this.teleportEntityTo(entity, closestCoords, teleporter);
            }
            for (Coord4D coords : this.frequency.activeCoords) {
                Mekanism.packetHandler.sendToAllAround(new PacketPortalFX.PortalFXMessage(coords), coords.getTargetPoint(40.0));
            }
            this.setEnergy(this.getEnergy() - (double)this.calculateEnergyCost(entity, closestCoords));
            this.field_145850_b.func_72956_a(entity, "mob.endermen.portal", 1.0f, 1.0f);
        }
    }

    public static void teleportPlayerTo(EntityPlayerMP player, Coord4D coord, TileEntityTeleporter teleporter) {
        if (player.field_71093_bK != coord.dimensionId) {
            int id = player.field_71093_bK;
            WorldServer oldWorld = player.field_71133_b.func_71218_a(player.field_71093_bK);
            player.field_71093_bK = coord.dimensionId;
            WorldServer newWorld = player.field_71133_b.func_71218_a(player.field_71093_bK);
            player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, player.field_70170_p.field_73013_u, newWorld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
            oldWorld.func_72973_f((Entity)player);
            player.field_70128_L = false;
            if (player.func_70089_S()) {
                newWorld.func_72838_d((Entity)player);
                player.func_70012_b((double)coord.xCoord + 0.5, (double)(coord.yCoord + 1), (double)coord.zCoord + 0.5, player.field_70177_z, player.field_70125_A);
                newWorld.func_72866_a((Entity)player, false);
                player.func_70029_a((World)newWorld);
            }
            player.field_71133_b.func_71203_ab().func_72375_a(player, oldWorld);
            player.field_71135_a.func_147364_a((double)coord.xCoord + 0.5, (double)(coord.yCoord + 1), (double)coord.zCoord + 0.5, player.field_70177_z, player.field_70125_A);
            player.field_71134_c.func_73080_a(newWorld);
            player.field_71133_b.func_71203_ab().func_72354_b(player, newWorld);
            player.field_71133_b.func_71203_ab().func_72385_f(player);
            for (PotionEffect potioneffect : player.func_70651_bq()) {
                player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), potioneffect));
            }
            FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, id, coord.dimensionId);
        } else {
            player.field_71135_a.func_147364_a((double)coord.xCoord + 0.5, (double)(coord.yCoord + 1), (double)coord.zCoord + 0.5, player.field_70177_z, player.field_70125_A);
        }
    }

    public void teleportEntityTo(Entity entity, Coord4D coord, TileEntityTeleporter teleporter) {
        WorldServer world = this.server.func_71218_a(coord.dimensionId);
        if (entity.field_70170_p.field_73011_w.field_76574_g != coord.dimensionId) {
            entity.field_70170_p.func_72900_e(entity);
            entity.field_70128_L = false;
            world.func_72838_d(entity);
            entity.func_70012_b((double)coord.xCoord + 0.5, (double)(coord.yCoord + 1), (double)coord.zCoord + 0.5, entity.field_70177_z, entity.field_70125_A);
            world.func_72866_a(entity, false);
            entity.func_70029_a((World)world);
            world.func_82742_i();
            Entity e = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)entity), (World)world);
            if (e != null) {
                e.func_82141_a(entity, true);
                world.func_72838_d(e);
                teleporter.didTeleport.add(e);
            }
            entity.field_70128_L = true;
        }
    }

    public List<Entity> getToTeleport() {
        List entities = this.field_145850_b.func_72872_a(Entity.class, this.teleportBounds);
        ArrayList<Entity> ret = new ArrayList<Entity>();
        for (Entity entity : entities) {
            if (this.didTeleport.contains(entity)) continue;
            ret.add(entity);
        }
        return ret;
    }

    public int calculateEnergyCost(Entity entity, Coord4D coords) {
        int energyCost = 1000;
        if (entity.field_70170_p.field_73011_w.field_76574_g != coords.dimensionId) {
            energyCost += 10000;
        }
        int distance = (int)entity.func_70011_f((double)coords.xCoord, (double)coords.yCoord, (double)coords.zCoord);
        return energyCost += distance * 10;
    }

    public boolean hasFrame() {
        if (this.isFrame(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) && this.isFrame(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) && this.isFrame(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e) && this.isFrame(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e) && this.isFrame(this.field_145851_c - 1, this.field_145848_d + 2, this.field_145849_e) && this.isFrame(this.field_145851_c + 1, this.field_145848_d + 2, this.field_145849_e) && this.isFrame(this.field_145851_c - 1, this.field_145848_d + 3, this.field_145849_e) && this.isFrame(this.field_145851_c + 1, this.field_145848_d + 3, this.field_145849_e) && this.isFrame(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e)) {
            return true;
        }
        return this.isFrame(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) && this.isFrame(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) && this.isFrame(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 1) && this.isFrame(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 1) && this.isFrame(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e - 1) && this.isFrame(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e + 1) && this.isFrame(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e - 1) && this.isFrame(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e + 1) && this.isFrame(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e);
    }

    public boolean isFrame(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z) == MekanismBlocks.BasicBlock && this.field_145850_b.func_72805_g(x, y, z) == 7;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (nbtTags.func_74764_b("owner")) {
            this.owner = nbtTags.func_74779_i("owner");
        }
        if (nbtTags.func_74764_b("frequency")) {
            this.frequency = new Frequency(nbtTags.func_74775_l("frequency"));
            this.frequency.valid = false;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        if (this.owner != null) {
            nbtTags.func_74778_a("owner", this.owner);
        }
        if (this.frequency != null) {
            NBTTagCompound frequencyTag = new NBTTagCompound();
            this.frequency.write(frequencyTag);
            nbtTags.func_74782_a("frequency", (NBTBase)frequencyTag);
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        int i;
        if (!this.field_145850_b.field_72995_K) {
            boolean isPublic;
            String freq;
            FrequencyManager manager;
            int type = dataStream.readInt();
            if (type == 0) {
                String name = PacketHandler.readString(dataStream);
                boolean isPublic2 = dataStream.readBoolean();
                this.setFrequency(name, isPublic2);
            } else if (type == 1 && (manager = this.getManager(new Frequency(freq = PacketHandler.readString(dataStream), null).setPublic(isPublic = dataStream.readBoolean()))) != null) {
                manager.remove(freq, this.owner);
            }
            return;
        }
        super.handlePacketData(dataStream);
        this.owner = dataStream.readBoolean() ? PacketHandler.readString(dataStream) : null;
        this.frequency = dataStream.readBoolean() ? new Frequency(dataStream) : null;
        this.status = dataStream.readByte();
        this.shouldRender = dataStream.readBoolean();
        this.publicCache.clear();
        this.privateCache.clear();
        int amount = dataStream.readInt();
        for (i = 0; i < amount; ++i) {
            this.publicCache.add(new Frequency(dataStream));
        }
        amount = dataStream.readInt();
        for (i = 0; i < amount; ++i) {
            this.privateCache.add(new Frequency(dataStream));
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.owner != null) {
            data.add(true);
            data.add(this.owner);
        } else {
            data.add(false);
        }
        if (this.frequency != null) {
            data.add(true);
            this.frequency.write(data);
        } else {
            data.add(false);
        }
        data.add(this.status);
        data.add(this.shouldRender);
        data.add(Mekanism.publicTeleporters.getFrequencies().size());
        for (Frequency freq : Mekanism.publicTeleporters.getFrequencies()) {
            freq.write(data);
        }
        FrequencyManager manager = this.getManager(new Frequency(null, null).setPublic(false));
        if (manager != null) {
            data.add(manager.getFrequencies().size());
            for (Frequency freq : manager.getFrequencies()) {
                freq.write(data);
            }
        } else {
            data.add(0);
        }
        return data;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        return ChargeUtils.canBeOutputted(itemstack, false);
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return this.func_145825_b();
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getStored", "canTeleport", "getMaxEnergy", "getEnergyNeeded", "teleport", "set"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.canTeleport()};
            }
            case 2: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 3: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
            case 4: {
                this.teleport();
                return new Object[]{"Attempted to teleport."};
            }
            case 5: {
                if (!(arguments[0] instanceof String) || !(arguments[1] instanceof Boolean)) {
                    return new Object[]{"Invalid parameters."};
                }
                String freq = ((String)arguments[0]).trim();
                boolean isPublic = (Boolean)arguments[1];
                this.setFrequency(freq, isPublic);
                return new Object[]{"Frequency set."};
            }
        }
        Mekanism.logger.error("Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return this == other;
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public void forceChunks(ForgeChunkManager.Ticket ticket) {
        this.releaseChunks();
        this.chunkTicket = ticket;
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)new Chunk3D(Coord4D.get(this)).toPair());
    }

    public void releaseChunks() {
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
            this.chunkTicket = null;
        }
    }
}

