/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.util.ListUtils;
import mekanism.client.gui.GuiChemicalInjectionChamber;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.nei.AdvancedMachineRecipeHandler;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.machines.InjectionRecipe;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ChemicalInjectionChamberRecipeHandler
extends AdvancedMachineRecipeHandler {
    public String getRecipeName() {
        return LangUtils.localize("nei.chemicalInjectionChamber");
    }

    @Override
    public String getRecipeId() {
        return "mekanism.chemicalinjectionchamber";
    }

    public String getOverlayIdentifier() {
        return "chemicalinjectionchamber";
    }

    public Collection<InjectionRecipe> getRecipes() {
        return RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.get().values();
    }

    @Override
    public List<ItemStack> getFuelStacks(Gas gasType) {
        if (gasType == GasRegistry.getGas("sulfuricAcid")) {
            ArrayList<ItemStack> fuels = new ArrayList<ItemStack>();
            fuels.addAll(OreDictionary.getOres((String)"dustSulfur"));
            fuels.add(MekanismUtils.getFullGasTank(GasRegistry.getGas("sulfuricAcid")));
            return fuels;
        }
        if (gasType == GasRegistry.getGas("water")) {
            return ListUtils.asList(MekanismUtils.getFullGasTank(GasRegistry.getGas("water")));
        }
        if (gasType == GasRegistry.getGas("hydrogenChloride")) {
            ArrayList<ItemStack> fuels = new ArrayList<ItemStack>();
            fuels.addAll(OreDictionary.getOres((String)"dustSalt"));
            fuels.add(MekanismUtils.getFullGasTank(GasRegistry.getGas("hydrogenChloride")));
            return fuels;
        }
        return new ArrayList<ItemStack>();
    }

    @Override
    public GuiProgress.ProgressBar getProgressType() {
        return GuiProgress.ProgressBar.YELLOW;
    }

    public Class getGuiClass() {
        return GuiChemicalInjectionChamber.class;
    }
}

