/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import java.util.Collection;
import mekanism.api.Coord4D;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.ITransmitterTile;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.multipart.PartTransmitter;
import mekanism.common.transmitters.Transmitter;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MultipartTransmitter<A, N extends DynamicNetwork<A, N>>
extends Transmitter<A, N> {
    public PartTransmitter<A, N> containingPart;

    public MultipartTransmitter(PartTransmitter<A, N> multiPart) {
        this.setPart(multiPart);
    }

    @Override
    public int getCapacity() {
        return this.getPart().getCapacity();
    }

    @Override
    public World world() {
        return this.getPart().world();
    }

    @Override
    public Coord4D coord() {
        return new Coord4D(this.getPart().x(), this.getPart().y(), this.getPart().z(), this.getPart().world().field_73011_w.field_76574_g);
    }

    @Override
    public Coord4D getAdjacentConnectableTransmitterCoord(ForgeDirection side) {
        IGridTransmitter transmitter;
        Coord4D sideCoord = this.coord().getFromSide(side);
        TileEntity potentialTransmitterTile = sideCoord.getTileEntity((IBlockAccess)this.world());
        if (!this.containingPart.canConnectMutual(side)) {
            return null;
        }
        if (potentialTransmitterTile instanceof ITransmitterTile && TransmissionType.checkTransmissionType(transmitter = ((ITransmitterTile)potentialTransmitterTile).getTransmitter(), this.getTransmissionType())) {
            return sideCoord;
        }
        return null;
    }

    @Override
    public A getAcceptor(ForgeDirection side) {
        return this.getPart().getCachedAcceptor(side);
    }

    @Override
    public boolean isValid() {
        return this.getPart().tile() != null && !this.getPart().tile().func_145837_r() && !this.getPart().unloaded && this.coord().exists(this.world());
    }

    @Override
    public N createEmptyNetwork() {
        return this.getPart().createNewNetwork();
    }

    @Override
    public N getExternalNetwork(Coord4D from) {
        TileEntity tile = from.getTileEntity((IBlockAccess)this.world());
        if (tile instanceof ITransmitterTile) {
            IGridTransmitter transmitter = ((ITransmitterTile)tile).getTransmitter();
            if (TransmissionType.checkTransmissionType(transmitter, this.getTransmissionType())) {
                // empty if block
            }
            return transmitter.getTransmitterNetwork();
        }
        return null;
    }

    @Override
    public void takeShare() {
        this.containingPart.takeShare();
    }

    @Override
    public Object getBuffer() {
        return this.getPart().getBuffer();
    }

    @Override
    public N mergeNetworks(Collection<N> toMerge) {
        return this.getPart().createNetworkByMerging(toMerge);
    }

    @Override
    public TransmissionType getTransmissionType() {
        return this.getPart().getTransmissionType();
    }

    public PartTransmitter<A, N> getPart() {
        return this.containingPart;
    }

    public void setPart(PartTransmitter<A, N> containingPart) {
        this.containingPart = containingPart;
    }
}

