/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.integration.IComputerIntegration;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.CableUtils;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityEnergyCube
extends TileEntityElectricBlock
implements IComputerIntegration,
IRedstoneControl {
    public Tier.EnergyCubeTier tier = Tier.EnergyCubeTier.BASIC;
    public int currentRedstoneLevel;
    public IRedstoneControl.RedstoneControl controlType;
    public int prevScale;
    private static final String[] methods = new String[]{"getStored", "getOutput", "getMaxEnergy", "getEnergyNeeded"};

    public TileEntityEnergyCube() {
        super("EnergyCube", 0.0);
        this.inventory = new ItemStack[2];
        this.controlType = IRedstoneControl.RedstoneControl.DISABLED;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            int newScale;
            ChargeUtils.charge(0, this);
            ChargeUtils.discharge(1, this);
            if (MekanismUtils.canFunction(this)) {
                CableUtils.emit(this);
            }
            if ((newScale = this.getScaledEnergyLevel(20)) != this.prevScale) {
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            }
            this.prevScale = newScale;
        }
    }

    @Override
    public String func_145825_b() {
        return LangUtils.localize("tile.EnergyCube" + this.tier.getBaseTier().getName() + ".name");
    }

    @Override
    public double getMaxOutput() {
        return this.tier.output;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return ChargeUtils.canBeCharged(itemstack);
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return true;
    }

    @Override
    public EnumSet<ForgeDirection> getConsumingSides() {
        EnumSet<ForgeDirection> set = EnumSet.allOf(ForgeDirection.class);
        set.removeAll(this.getOutputtingSides());
        return set;
    }

    @Override
    public EnumSet<ForgeDirection> getOutputtingSides() {
        return EnumSet.of(ForgeDirection.getOrientation((int)this.facing));
    }

    @Override
    public boolean canSetFacing(int side) {
        return true;
    }

    @Override
    public double getMaxEnergy() {
        return this.tier.maxEnergy;
    }

    @Override
    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side <= 1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        return nArray;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        if (slotID == 0) {
            return ChargeUtils.canBeOutputted(itemstack, true);
        }
        return false;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.tier.output};
            }
            case 2: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 3: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        this.tier = Tier.EnergyCubeTier.values()[dataStream.readInt()];
        super.handlePacketData(dataStream);
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        data.add(this.tier.ordinal());
        super.getNetworkedData(data);
        data.add(this.controlType.ordinal());
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.tier = Tier.EnergyCubeTier.getFromName(nbtTags.func_74779_i("tier"));
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74778_a("tier", this.tier.getBaseTier().getName());
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
    }

    @Override
    public void setEnergy(double energy) {
        if (this.tier == Tier.EnergyCubeTier.CREATIVE && energy != 2.147483647E9) {
            return;
        }
        super.setEnergy(energy);
        int newRedstoneLevel = this.getRedstoneLevel();
        if (newRedstoneLevel != this.currentRedstoneLevel) {
            this.func_70296_d();
            this.currentRedstoneLevel = newRedstoneLevel;
        }
    }

    public int getRedstoneLevel() {
        double fractionFull = this.getEnergy() / this.getMaxEnergy();
        return MathHelper.func_76141_d((float)((float)(fractionFull * 14.0))) + (fractionFull > 0.0 ? 1 : 0);
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public boolean canPulse() {
        return false;
    }
}

