/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.Mekanism;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityGasTank
extends TileEntityContainerBlock
implements IGasHandler,
ITubeConnection,
IRedstoneControl {
    public GasTank gasTank = new GasTank(96000);
    public static final int MAX_GAS = 96000;
    public int output = 256;
    public GasMode dumping;
    public int currentGasAmount;
    public IRedstoneControl.RedstoneControl controlType;

    public TileEntityGasTank() {
        super("GasTank");
        this.inventory = new ItemStack[2];
        this.dumping = GasMode.IDLE;
        this.controlType = IRedstoneControl.RedstoneControl.DISABLED;
    }

    @Override
    public void onUpdate() {
        int newGasAmount;
        if (this.inventory[0] != null && this.gasTank.getGas() != null) {
            this.gasTank.draw(GasTransmission.addGas(this.inventory[0], this.gasTank.getGas()), true);
        }
        if (this.inventory[1] != null && (this.gasTank.getGas() == null || this.gasTank.getGas().amount < this.gasTank.getMaxGas())) {
            this.gasTank.receive(GasTransmission.removeGas(this.inventory[1], this.gasTank.getGasType(), this.gasTank.getNeeded()), true);
        }
        if (!this.field_145850_b.field_72995_K && this.gasTank.getGas() != null && MekanismUtils.canFunction(this) && this.dumping != GasMode.DUMPING) {
            GasStack toSend = new GasStack(this.gasTank.getGas().getGas(), Math.min(this.gasTank.getStored(), this.output));
            TileEntity tileEntity = Coord4D.get(this).getFromSide(ForgeDirection.getOrientation((int)this.facing)).getTileEntity((IBlockAccess)this.field_145850_b);
            if (tileEntity instanceof IGasHandler && ((IGasHandler)tileEntity).canReceiveGas(ForgeDirection.getOrientation((int)this.facing).getOpposite(), this.gasTank.getGas().getGas())) {
                this.gasTank.draw(((IGasHandler)tileEntity).receiveGas(ForgeDirection.getOrientation((int)this.facing).getOpposite(), toSend, true), true);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.dumping == GasMode.DUMPING) {
            this.gasTank.draw(8, true);
        }
        if (!this.field_145850_b.field_72995_K && this.dumping == GasMode.DUMPING_EXCESS && this.gasTank.getNeeded() < this.output) {
            this.gasTank.draw(this.output - this.gasTank.getNeeded(), true);
        }
        if (!this.field_145850_b.field_72995_K && (newGasAmount = this.gasTank.getStored()) != this.currentGasAmount) {
            this.func_70296_d();
            this.currentGasAmount = newGasAmount;
        }
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) == null;
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) != null && ((IGasItem)itemstack.func_77973_b()).getGas((ItemStack)itemstack).amount == ((IGasItem)itemstack.func_77973_b()).getMaxGas(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IGasItem && (this.gasTank.getGas() == null || ((IGasItem)itemstack.func_77973_b()).canReceiveGas(itemstack, this.gasTank.getGas().getGas()));
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IGasItem && (this.gasTank.getGas() == null || ((IGasItem)itemstack.func_77973_b()).canProvideGas(itemstack, this.gasTank.getGas().getGas()));
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == 1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        return nArray;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        return this.gasTank.receive(stack, doTransfer);
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return this.drawGas(side, amount, true);
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return this.gasTank.canDraw(type);
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        if (side != ForgeDirection.getOrientation((int)this.facing)) {
            return this.gasTank.canReceive(type);
        }
        return false;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            int type = dataStream.readInt();
            if (type == 0) {
                TileEntityGasTank tileEntityGasTank = this;
                int index = (this.dumping.ordinal() + 1) % tileEntityGasTank.dumping.values().length;
                this.dumping = GasMode.values()[index];
            }
            for (EntityPlayer player : this.playersUsing) {
                Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), (EntityPlayerMP)player);
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (dataStream.readBoolean()) {
            this.gasTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
        } else {
            this.gasTank.setGas(null);
        }
        this.dumping = GasMode.values()[dataStream.readInt()];
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
        this.dumping = GasMode.values()[nbtTags.func_74762_e("dumping")];
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
        nbtTags.func_74768_a("dumping", this.dumping.ordinal());
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.gasTank.getGas() != null) {
            data.add(true);
            data.add(this.gasTank.getGas().getGas().getID());
            data.add(this.gasTank.getStored());
        } else {
            data.add(false);
        }
        data.add(this.dumping.ordinal());
        data.add(this.controlType.ordinal());
        return data;
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return true;
    }

    public int getRedstoneLevel() {
        int stored = this.gasTank.getStored();
        if (stored == 0) {
            return 0;
        }
        return MathHelper.func_76141_d((float)((float)stored / 96000.0f * 14.0f + 1.0f));
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    public static enum GasMode {
        IDLE,
        DUMPING,
        DUMPING_EXCESS;

    }
}

