/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.energy.ICableOutputter;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.api.lasers.ILaserReceptor;
import mekanism.common.LaserManager;
import mekanism.common.Mekanism;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.integration.IComputerIntegration;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLaserAmplifier
extends TileEntityContainerBlock
implements ILaserReceptor,
IRedstoneControl,
ICableOutputter,
IStrictEnergyStorage,
IComputerIntegration {
    public static final double MAX_ENERGY = 5.0E9;
    public double collectedEnergy = 0.0;
    public double lastFired = 0.0;
    public double minThreshold = 0.0;
    public double maxThreshold = 5.0E9;
    public int ticks = 0;
    public int time = 0;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public boolean on = false;
    public Coord4D digging;
    public double diggingProgress;
    public boolean emittingRedstone;
    public boolean entityDetection;
    private static final String[] methods = new String[]{"getStored", "getMaxEnergy"};

    public TileEntityLaserAmplifier() {
        super("LaserAmplifier");
        this.inventory = new ItemStack[0];
    }

    @Override
    public void receiveLaserEnergy(double energy, ForgeDirection side) {
        this.setEnergy(this.getEnergy() + energy);
    }

    @Override
    public boolean canLasersDig() {
        return false;
    }

    @Override
    public void onUpdate() {
        if (this.field_145850_b.field_72995_K) {
            if (this.on) {
                Coord4D hitCoord;
                MovingObjectPosition mop = LaserManager.fireLaserClient(this, ForgeDirection.getOrientation((int)this.facing), this.lastFired, this.field_145850_b);
                Coord4D coord4D = hitCoord = mop == null ? null : new Coord4D(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                if (hitCoord == null || !hitCoord.equals(this.digging)) {
                    this.digging = hitCoord;
                    this.diggingProgress = 0.0;
                }
                if (hitCoord != null) {
                    Block blockHit = hitCoord.getBlock((IBlockAccess)this.field_145850_b);
                    TileEntity tileHit = hitCoord.getTileEntity((IBlockAccess)this.field_145850_b);
                    float hardness = blockHit.func_149712_f(this.field_145850_b, hitCoord.xCoord, hitCoord.yCoord, hitCoord.zCoord);
                    if (!(hardness < 0.0f || tileHit instanceof ILaserReceptor && !((ILaserReceptor)tileHit).canLasersDig())) {
                        this.diggingProgress += this.lastFired;
                        if (this.diggingProgress < (double)hardness * MekanismConfig.general.laserEnergyNeededPerHardness) {
                            Mekanism.proxy.addHitEffects(hitCoord, mop);
                        }
                    }
                }
            }
        } else {
            boolean prevRedstone = this.emittingRedstone;
            this.emittingRedstone = false;
            this.ticks = this.ticks < this.time ? ++this.ticks : 0;
            if (this.toFire() > 0.0) {
                Coord4D hitCoord;
                double firing = this.toFire();
                if (!this.on || firing != this.lastFired) {
                    this.on = true;
                    this.lastFired = firing;
                    Mekanism.packetHandler.sendToAllAround(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), Coord4D.get(this).getTargetPoint(50.0));
                }
                LaserManager.LaserInfo info = LaserManager.fireLaser(this, ForgeDirection.getOrientation((int)this.facing), firing, this.field_145850_b);
                Coord4D coord4D = hitCoord = info.movingPos == null ? null : new Coord4D(info.movingPos.field_72311_b, info.movingPos.field_72312_c, info.movingPos.field_72309_d);
                if (hitCoord == null || !hitCoord.equals(this.digging)) {
                    this.digging = hitCoord;
                    this.diggingProgress = 0.0;
                }
                if (hitCoord != null) {
                    Block blockHit = hitCoord.getBlock((IBlockAccess)this.field_145850_b);
                    TileEntity tileHit = hitCoord.getTileEntity((IBlockAccess)this.field_145850_b);
                    float hardness = blockHit.func_149712_f(this.field_145850_b, hitCoord.xCoord, hitCoord.yCoord, hitCoord.zCoord);
                    if (!(hardness < 0.0f || tileHit instanceof ILaserReceptor && !((ILaserReceptor)tileHit).canLasersDig())) {
                        this.diggingProgress += firing;
                        if (this.diggingProgress >= (double)hardness * MekanismConfig.general.laserEnergyNeededPerHardness) {
                            LaserManager.breakBlock(hitCoord, true, this.field_145850_b);
                            this.diggingProgress = 0.0;
                        }
                    }
                }
                this.emittingRedstone = info.foundEntity;
                this.setEnergy(this.getEnergy() - firing);
            } else if (this.on) {
                this.on = false;
                this.diggingProgress = 0.0;
                Mekanism.packetHandler.sendToAllAround(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), Coord4D.get(this).getTargetPoint(50.0));
            }
            if (!this.entityDetection) {
                this.emittingRedstone = false;
            }
            if (this.emittingRedstone != prevRedstone) {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            }
        }
    }

    @Override
    public void setEnergy(double energy) {
        this.collectedEnergy = Math.max(0.0, Math.min(energy, 5.0E9));
    }

    @Override
    public double getEnergy() {
        return this.collectedEnergy;
    }

    public boolean shouldFire() {
        return this.collectedEnergy >= this.minThreshold && this.ticks >= this.time && MekanismUtils.canFunction(this);
    }

    public double toFire() {
        return this.shouldFire() ? Math.min(this.collectedEnergy, this.maxThreshold) : 0.0;
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.on);
        data.add(this.minThreshold);
        data.add(this.maxThreshold);
        data.add(this.time);
        data.add(this.collectedEnergy);
        data.add(this.lastFired);
        data.add(this.controlType.ordinal());
        data.add(this.emittingRedstone);
        data.add(this.entityDetection);
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (this.field_145850_b.field_72995_K) {
            super.handlePacketData(dataStream);
            this.on = dataStream.readBoolean();
            this.minThreshold = dataStream.readDouble();
            this.maxThreshold = dataStream.readDouble();
            this.time = dataStream.readInt();
            this.collectedEnergy = dataStream.readDouble();
            this.lastFired = dataStream.readDouble();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            this.emittingRedstone = dataStream.readBoolean();
            this.entityDetection = dataStream.readBoolean();
            return;
        }
        switch (dataStream.readInt()) {
            case 0: {
                this.minThreshold = Math.min(5.0E9, MekanismUtils.convertToJoules(dataStream.readDouble()));
                break;
            }
            case 1: {
                this.maxThreshold = Math.min(5.0E9, MekanismUtils.convertToJoules(dataStream.readDouble()));
                break;
            }
            case 2: {
                this.time = dataStream.readInt();
                break;
            }
            case 3: {
                this.entityDetection = !this.entityDetection;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.on = nbtTags.func_74767_n("on");
        this.minThreshold = nbtTags.func_74769_h("minThreshold");
        this.maxThreshold = nbtTags.func_74769_h("maxThreshold");
        this.time = nbtTags.func_74762_e("time");
        this.collectedEnergy = nbtTags.func_74769_h("collectedEnergy");
        this.lastFired = nbtTags.func_74769_h("lastFired");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.entityDetection = nbtTags.func_74767_n("entityDetection");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74757_a("on", this.on);
        nbtTags.func_74780_a("minThreshold", this.minThreshold);
        nbtTags.func_74780_a("maxThreshold", this.maxThreshold);
        nbtTags.func_74768_a("time", this.time);
        nbtTags.func_74780_a("collectedEnergy", this.collectedEnergy);
        nbtTags.func_74780_a("lastFired", this.lastFired);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74757_a("entityDetection", this.entityDetection);
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @Override
    public boolean canOutputTo(ForgeDirection side) {
        return true;
    }

    @Override
    public double getMaxEnergy() {
        return 5.0E9;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.getMaxEnergy()};
            }
        }
        throw new NoSuchMethodException();
    }
}

