/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.api.infuse.InfuseObject;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.InfuseStorage;
import mekanism.common.Mekanism;
import mekanism.common.MekanismItems;
import mekanism.common.PacketHandler;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.IEjector;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.BlockMachine;
import mekanism.common.integration.IComputerIntegration;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.tile.TileEntityNoisyElectricBlock;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMetallurgicInfuser
extends TileEntityNoisyElectricBlock
implements IComputerIntegration,
ISideConfiguration,
IUpgradeTile,
IRedstoneControl {
    public int MAX_INFUSE = 1000;
    public double BASE_ENERGY_PER_TICK;
    public double energyPerTick = this.BASE_ENERGY_PER_TICK = MekanismConfig.usage.metallurgicInfuserUsage;
    public int BASE_TICKS_REQUIRED;
    public int ticksRequired = this.BASE_TICKS_REQUIRED = 200;
    public InfuseStorage infuseStored = new InfuseStorage();
    public int operatingTicks;
    public boolean isActive;
    public boolean clientActive;
    public int updateDelay;
    public double prevEnergy;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentUpgrade upgradeComponent;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY);
    private static final String[] methods = new String[]{"getStored", "getProgress", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded", "getInfuse", "getInfuseNeeded"};

    public TileEntityMetallurgicInfuser() {
        super("machine.metalinfuser", "MetallurgicInfuser", BlockMachine.MachineType.METALLURGIC_INFUSER.baseEnergy);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Infuse", EnumColor.PURPLE, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Input", EnumColor.DARK_RED, new int[]{2}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Output", EnumColor.DARK_BLUE, new int[]{3}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Energy", EnumColor.DARK_GREEN, new int[]{4}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{1, 0, 0, 4, 2, 3});
        this.configComponent.setInputEnergyConfig();
        this.inventory = new ItemStack[5];
        this.upgradeComponent = new TileComponentUpgrade(this, 0);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(3));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K && this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            MetallurgicInfuserRecipe recipe;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
                }
            }
            ChargeUtils.discharge(0, this);
            if (this.inventory[1] != null && InfuseRegistry.getObject(this.inventory[1]) != null) {
                InfuseObject infuse = InfuseRegistry.getObject(this.inventory[1]);
                if ((this.infuseStored.type == null || this.infuseStored.type == infuse.type) && this.infuseStored.amount + infuse.stored <= this.MAX_INFUSE) {
                    this.infuseStored.amount += infuse.stored;
                    this.infuseStored.type = infuse.type;
                    --this.inventory[1].field_77994_a;
                    if (this.inventory[1].field_77994_a <= 0) {
                        this.inventory[1] = null;
                    }
                }
            }
            if (this.canOperate(recipe = RecipeHandler.getMetallurgicInfuserRecipe(this.getInput())) && MekanismUtils.canFunction(this) && this.getEnergy() >= this.energyPerTick) {
                this.setActive(true);
                this.setEnergy(this.getEnergy() - this.energyPerTick);
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                } else {
                    this.operate(recipe);
                    this.operatingTicks = 0;
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (!this.canOperate(recipe)) {
                this.operatingTicks = 0;
            }
            if (this.infuseStored.amount <= 0) {
                this.infuseStored.amount = 0;
                this.infuseStored.type = null;
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    @Override
    public EnumSet<ForgeDirection> getConsumingSides() {
        return this.configComponent.getSidesForData(TransmissionType.ENERGY, this.facing, 1);
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 4) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 3;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 3) {
            return false;
        }
        if (slotID == 1) {
            return InfuseRegistry.getObject(itemstack) != null && (this.infuseStored.type == null || this.infuseStored.type == InfuseRegistry.getObject((ItemStack)itemstack).type);
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() == MekanismItems.SpeedUpgrade || itemstack.func_77973_b() == MekanismItems.EnergyUpgrade;
        }
        if (slotID == 2) {
            if (this.infuseStored.type != null) {
                if (RecipeHandler.getMetallurgicInfuserRecipe(new InfusionInput(this.infuseStored, itemstack)) != null) {
                    return true;
                }
            } else {
                for (Object obj : RecipeHandler.Recipe.METALLURGIC_INFUSER.get().keySet()) {
                    InfusionInput input = (InfusionInput)obj;
                    if (!input.inputStack.func_77969_a(itemstack)) continue;
                    return true;
                }
            }
        } else if (slotID == 4) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    public InfusionInput getInput() {
        return new InfusionInput(this.infuseStored, this.inventory[2]);
    }

    public void operate(MetallurgicInfuserRecipe recipe) {
        recipe.output(this.inventory, this.infuseStored);
        this.func_70296_d();
        this.ejectorComponent.outputItems();
    }

    public boolean canOperate(MetallurgicInfuserRecipe recipe) {
        return recipe != null && recipe.canOperate(this.inventory, this.infuseStored);
    }

    public int getScaledInfuseLevel(int i) {
        return this.infuseStored.amount * i / this.MAX_INFUSE;
    }

    public double getScaledProgress() {
        return (double)this.operatingTicks / (double)this.ticksRequired;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.clientActive = this.isActive = nbtTags.func_74767_n("isActive");
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.infuseStored.amount = nbtTags.func_74762_e("infuseStored");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.infuseStored.type = InfuseRegistry.get(nbtTags.func_74779_i("type"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74768_a("infuseStored", this.infuseStored.amount);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        if (this.infuseStored.type != null) {
            nbtTags.func_74778_a("type", this.infuseStored.type.name);
        } else {
            nbtTags.func_74778_a("type", "null");
        }
        nbtTags.func_74757_a("sideDataStored", true);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            this.infuseStored.amount = dataStream.readInt();
            return;
        }
        super.handlePacketData(dataStream);
        this.clientActive = dataStream.readBoolean();
        this.operatingTicks = dataStream.readInt();
        this.infuseStored.amount = dataStream.readInt();
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        this.infuseStored.type = InfuseRegistry.get(PacketHandler.readString(dataStream));
        if (this.updateDelay == 0 && this.clientActive != this.isActive) {
            this.updateDelay = MekanismConfig.general.UPDATE_DELAY;
            this.isActive = this.clientActive;
            MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.operatingTicks);
        data.add(this.infuseStored.amount);
        data.add(this.controlType.ordinal());
        if (this.infuseStored.type != null) {
            data.add(this.infuseStored.type.name);
        } else {
            data.add("null");
        }
        return data;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.operatingTicks};
            }
            case 2: {
                return new Object[]{this.facing};
            }
            case 3: {
                return new Object[]{this.canOperate(RecipeHandler.getMetallurgicInfuserRecipe(this.getInput()))};
            }
            case 4: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 5: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
            case 6: {
                return new Object[]{this.infuseStored};
            }
            case 7: {
                return new Object[]{this.MAX_INFUSE - this.infuseStored.amount};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public int[] func_94128_d(int side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (int)side, (int)this.facing).availableSlots;
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public int getOrientation() {
        return this.facing;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public IEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case SPEED: {
                this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
            }
            case ENERGY: {
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
            }
        }
    }
}

