/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.multiblock.IMultiblock;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.multiblock.UpdateProtocol;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityContainerBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityMultiblock<T extends SynchronizedData<T>>
extends TileEntityContainerBlock
implements IMultiblock<T> {
    public T structure;
    public boolean sendStructure;
    public boolean prevStructure;
    public boolean clientHasStructure;
    public boolean isRendering;
    public MultiblockCache cachedData = this.getNewCache();
    public int cachedID = -1;

    public TileEntityMultiblock(String name) {
        super(name);
    }

    @Override
    public void onUpdate() {
        if (this.field_145850_b.field_72995_K) {
            if (this.structure == null) {
                this.structure = this.getNewStructure();
            }
            if (this.structure != null && this.clientHasStructure && this.isRendering && !this.prevStructure) {
                Mekanism.proxy.doMultiblockSparkle(this);
            }
            this.prevStructure = this.clientHasStructure;
        }
        if (this.playersUsing.size() > 0 && (this.field_145850_b.field_72995_K && !this.clientHasStructure || !this.field_145850_b.field_72995_K && this.structure == null)) {
            for (EntityPlayer player : this.playersUsing) {
                player.func_71053_j();
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.structure == null) {
                this.isRendering = false;
                if (this.cachedID != -1) {
                    this.getManager().updateCache(this);
                }
            }
            if (this.structure == null && this.ticker == 5) {
                this.update();
            }
            if (this.prevStructure != (this.structure != null)) {
                if (this.structure != null && !((SynchronizedData)this.getSynchronizedData()).hasRenderer) {
                    ((SynchronizedData)this.getSynchronizedData()).hasRenderer = true;
                    this.isRendering = true;
                    this.sendStructure = true;
                }
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    Coord4D obj = Coord4D.get(this).getFromSide(side);
                    if (obj.isAirBlock((IBlockAccess)this.field_145850_b) || obj.getTileEntity((IBlockAccess)this.field_145850_b) != null && obj.getTileEntity((IBlockAccess)this.field_145850_b).getClass() == this.getClass()) continue;
                    obj.getBlock((IBlockAccess)this.field_145850_b).onNeighborChange((IBlockAccess)this.field_145850_b, obj.xCoord, obj.yCoord, obj.zCoord, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            }
            boolean bl = this.prevStructure = this.structure != null;
            if (this.structure != null) {
                ((SynchronizedData)this.getSynchronizedData()).didTick = false;
                if (((SynchronizedData)this.getSynchronizedData()).inventoryID != -1) {
                    this.cachedData.sync(this.getSynchronizedData());
                    this.cachedID = ((SynchronizedData)this.getSynchronizedData()).inventoryID;
                    this.getManager().updateCache(this);
                }
            }
        }
    }

    public void update() {
        if (!(this.field_145850_b.field_72995_K || this.structure != null && ((SynchronizedData)this.getSynchronizedData()).didTick)) {
            this.getProtocol().doUpdate();
            if (this.structure != null) {
                ((SynchronizedData)this.getSynchronizedData()).didTick = true;
            }
        }
    }

    public void sendPacketToRenderer() {
        if (this.structure != null) {
            for (Coord4D obj : ((SynchronizedData)this.getSynchronizedData()).locations) {
                TileEntityMultiblock tileEntity = (TileEntityMultiblock)obj.getTileEntity((IBlockAccess)this.field_145850_b);
                if (tileEntity == null || !tileEntity.isRendering) continue;
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(tileEntity)));
            }
        }
    }

    protected abstract T getNewStructure();

    public abstract MultiblockCache<T> getNewCache();

    protected abstract UpdateProtocol<T> getProtocol();

    public abstract MultiblockManager<T> getManager();

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isRendering);
        data.add(this.structure != null);
        if (this.structure != null && this.isRendering) {
            if (this.sendStructure) {
                this.sendStructure = false;
                data.add(true);
                data.add(((SynchronizedData)this.getSynchronizedData()).volHeight);
                data.add(((SynchronizedData)this.getSynchronizedData()).volWidth);
                data.add(((SynchronizedData)this.getSynchronizedData()).volLength);
                ((SynchronizedData)this.getSynchronizedData()).renderLocation.write(data);
            } else {
                data.add(false);
            }
        }
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.structure == null) {
            this.structure = this.getNewStructure();
        }
        this.isRendering = dataStream.readBoolean();
        this.clientHasStructure = dataStream.readBoolean();
        if (this.clientHasStructure && this.isRendering && dataStream.readBoolean()) {
            ((SynchronizedData)this.getSynchronizedData()).volHeight = dataStream.readInt();
            ((SynchronizedData)this.getSynchronizedData()).volWidth = dataStream.readInt();
            ((SynchronizedData)this.getSynchronizedData()).volLength = dataStream.readInt();
            ((SynchronizedData)this.getSynchronizedData()).renderLocation = Coord4D.read(dataStream);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (this.structure == null) {
            this.cachedID = nbtTags.func_74762_e("cachedID");
            if (this.cachedID != -1) {
                this.cachedData.load(nbtTags);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74768_a("cachedID", this.cachedID);
        if (this.cachedID != -1) {
            this.cachedData.save(nbtTags);
        }
    }

    @Override
    public ItemStack func_70301_a(int slotID) {
        return this.structure != null && ((SynchronizedData)this.getSynchronizedData()).getInventory() != null ? ((SynchronizedData)this.getSynchronizedData()).getInventory()[slotID] : null;
    }

    @Override
    public void func_70299_a(int slotID, ItemStack itemstack) {
        if (this.structure != null && ((SynchronizedData)this.getSynchronizedData()).getInventory() != null) {
            ((SynchronizedData)this.getSynchronizedData()).getInventory()[slotID] = itemstack;
            if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
                itemstack.field_77994_a = this.func_70297_j_();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public boolean handleInventory() {
        return false;
    }

    @Override
    public T getSynchronizedData() {
        return this.structure;
    }
}

