/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transmitters;

import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;

public abstract class Transmitter<A, N extends DynamicNetwork<A, N>>
implements IGridTransmitter<A, N> {
    public N theNetwork = null;
    public boolean orphaned = true;

    @Override
    public N getTransmitterNetwork() {
        return this.theNetwork;
    }

    @Override
    public boolean hasTransmitterNetwork() {
        return !this.isOrphan() && this.getTransmitterNetwork() != null;
    }

    @Override
    public void setTransmitterNetwork(N network) {
        if (this.theNetwork == network) {
            return;
        }
        if (this.world().field_72995_K && this.theNetwork != null) {
            ((DynamicNetwork)this.theNetwork).transmitters.remove(this);
            if (((DynamicNetwork)this.theNetwork).transmitters.isEmpty()) {
                ((DynamicNetwork)this.theNetwork).deregister();
            }
        }
        this.theNetwork = network;
        boolean bl = this.orphaned = this.theNetwork == null;
        if (this.world().field_72995_K && this.theNetwork != null) {
            ((DynamicNetwork)this.theNetwork).transmitters.add(this);
        }
    }

    @Override
    public int getTransmitterNetworkSize() {
        return this.hasTransmitterNetwork() ? ((DynamicNetwork)this.getTransmitterNetwork()).getSize() : 0;
    }

    @Override
    public int getTransmitterNetworkAcceptorSize() {
        return this.hasTransmitterNetwork() ? ((DynamicNetwork)this.getTransmitterNetwork()).getAcceptorSize() : 0;
    }

    @Override
    public String getTransmitterNetworkNeeded() {
        return this.hasTransmitterNetwork() ? this.getTransmitterNetwork().getNeededInfo() : "No Network";
    }

    @Override
    public String getTransmitterNetworkFlow() {
        return this.hasTransmitterNetwork() ? this.getTransmitterNetwork().getFlowInfo() : "No Network";
    }

    @Override
    public String getTransmitterNetworkBuffer() {
        return this.hasTransmitterNetwork() ? this.getTransmitterNetwork().getStoredInfo() : "No Network";
    }

    @Override
    public double getTransmitterNetworkCapacity() {
        return this.hasTransmitterNetwork() ? (double)((DynamicNetwork)this.getTransmitterNetwork()).getCapacity() : (double)this.getCapacity();
    }

    @Override
    public boolean isOrphan() {
        return this.orphaned;
    }

    @Override
    public void setOrphan(boolean nowOrphaned) {
        this.orphaned = nowOrphaned;
    }
}

