/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mekanism.api.MekanismConfig;
import mekanism.api.util.ListUtils;
import mekanism.api.util.UnitDisplayUtils;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiBoilerTab;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiGraph;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiBoilerStats
extends GuiMekanism {
    public TileEntityBoilerCasing tileEntity;
    public GuiGraph boilGraph;
    public GuiGraph maxGraph;

    public GuiBoilerStats(InventoryPlayer inventory, TileEntityBoilerCasing tentity) {
        super(tentity, new ContainerNull(inventory.field_70458_d, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiBoilerTab(this, this.tileEntity, GuiBoilerTab.BoilerTab.MAIN, 6, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiBoilerStats.png")));
        this.guiElements.add(new GuiHeatInfo(new GuiElement.IInfoHandler(){

            @Override
            public List<String> getInfo() {
                UnitDisplayUtils.TemperatureUnit unit = UnitDisplayUtils.TemperatureUnit.values()[MekanismConfig.general.tempUnit.ordinal()];
                String environment = UnitDisplayUtils.getDisplayShort(((SynchronizedBoilerData)GuiBoilerStats.this.tileEntity.structure).lastEnvironmentLoss * unit.intervalSize, unit);
                return ListUtils.asList(LangUtils.localize("gui.dissipated") + ": " + environment + "/t");
            }
        }, (IGuiWrapper)this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiBoilerStats.png")));
        this.boilGraph = new GuiGraph(this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiBoilerStats.png"), 8, 83, 160, 36, new GuiGraph.GraphDataHandler(){

            @Override
            public String getDataDisplay(int data) {
                return LangUtils.localize("gui.boilRate") + ": " + data + " mB/t";
            }
        });
        this.guiElements.add(this.boilGraph);
        this.maxGraph = new GuiGraph(this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiBoilerStats.png"), 8, 122, 160, 36, new GuiGraph.GraphDataHandler(){

            @Override
            public String getDataDisplay(int data) {
                return LangUtils.localize("gui.maxBoil") + ": " + data + " mB/t";
            }
        });
        this.guiElements.add(this.maxGraph);
        this.maxGraph.enableFixedScale((int)((double)((SynchronizedBoilerData)tentity.structure).superheatingElements * MekanismConfig.general.superheatingHeatTransfer / SynchronizedBoilerData.getHeatEnthalpy()));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        String stats = LangUtils.localize("gui.boilerStats");
        this.field_146289_q.func_78276_b(stats, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(stats) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.maxWater") + ": " + this.tileEntity.clientWaterCapacity + " mB", 8, 26, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.maxSteam") + ": " + this.tileEntity.clientSteamCapacity + " mB", 8, 35, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.heatTransfer"), 8, 49, 0x797979);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.superheaters") + ": " + ((SynchronizedBoilerData)this.tileEntity.structure).superheatingElements, 14, 58, 0x404040);
        int boilCapacity = (int)((double)((SynchronizedBoilerData)this.tileEntity.structure).superheatingElements * MekanismConfig.general.superheatingHeatTransfer / SynchronizedBoilerData.getHeatEnthalpy());
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.boilCapacity") + ": " + boilCapacity + " mB/t", 8, 72, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.boilGraph.addData(((SynchronizedBoilerData)this.tileEntity.structure).lastBoilRate);
        this.maxGraph.addData(((SynchronizedBoilerData)this.tileEntity.structure).lastMaxBoil);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiBoilerStats.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        super.func_146976_a(partialTick, mouseX, mouseY);
    }
}

