/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.util.ListUtils;
import mekanism.api.util.UnitDisplayUtils;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerResistiveHeater;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityResistiveHeater;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiResistiveHeater
extends GuiMekanism {
    public TileEntityResistiveHeater tileEntity;
    private GuiTextField energyUsageField;

    public GuiResistiveHeater(InventoryPlayer inventory, TileEntityResistiveHeater tentity) {
        super(tentity, new ContainerResistiveHeater(inventory, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiResistiveHeater.png"), 164, 15));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.POWER, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiResistiveHeater.png"), 14, 34).with(GuiSlot.SlotOverlay.POWER));
        this.guiElements.add(new GuiSecurityTab(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiResistiveHeater.png")));
        this.guiElements.add(new GuiRedstoneControl(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiResistiveHeater.png")));
        this.guiElements.add(new GuiEnergyInfo(new GuiElement.IInfoHandler(){

            @Override
            public List<String> getInfo() {
                String multiplier = MekanismUtils.getEnergyDisplay(GuiResistiveHeater.this.tileEntity.energyUsage);
                return ListUtils.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(GuiResistiveHeater.this.tileEntity.getMaxEnergy() - GuiResistiveHeater.this.tileEntity.getEnergy()));
            }
        }, (IGuiWrapper)this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiResistiveHeater.png")));
        this.guiElements.add(new GuiHeatInfo(new GuiElement.IInfoHandler(){

            @Override
            public List<String> getInfo() {
                System.out.println(GuiResistiveHeater.this.tileEntity.lastEnvironmentLoss);
                UnitDisplayUtils.TemperatureUnit unit = UnitDisplayUtils.TemperatureUnit.values()[MekanismConfig.general.tempUnit.ordinal()];
                String environment = UnitDisplayUtils.getDisplayShort(GuiResistiveHeater.this.tileEntity.lastEnvironmentLoss * unit.intervalSize, false, unit);
                return ListUtils.asList(LangUtils.localize("gui.dissipated") + ": " + environment + "/t");
            }
        }, (IGuiWrapper)this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiResistiveHeater.png")));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        String prevEnergyUsage = this.energyUsageField != null ? this.energyUsageField.func_146179_b() : "";
        this.energyUsageField = new GuiTextField(this.field_146289_q, guiWidth + 49, guiHeight + 52, 66, 11);
        this.energyUsageField.func_146203_f(7);
        this.energyUsageField.func_146185_a(false);
        this.energyUsageField.func_146180_a(prevEnergyUsage);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.tileEntity.func_145825_b(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.tileEntity.func_145825_b()) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 94 + 2, 0x404040);
        this.renderScaledText(LangUtils.localize("gui.temp") + ": " + MekanismUtils.getTemperatureDisplay(this.tileEntity.temperature, UnitDisplayUtils.TemperatureUnit.AMBIENT), 50, 25, 52480, 76);
        this.renderScaledText(LangUtils.localize("gui.usage") + ": " + MekanismUtils.getEnergyDisplay(this.tileEntity.energyUsage) + "/t", 50, 41, 52480, 76);
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiResistiveHeater.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 116 && xAxis <= 126 && yAxis >= 51 && yAxis <= 61) {
            this.func_73729_b(guiWidth + 116, guiHeight + 51, this.field_146999_f, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 116, guiHeight + 51, this.field_146999_f, 11, 11, 11);
        }
        super.func_146976_a(partialTick, mouseX, mouseY);
        this.energyUsageField.func_146194_f();
    }

    private void setEnergyUsage() {
        if (!this.energyUsageField.func_146179_b().isEmpty()) {
            int toUse = Integer.parseInt(this.energyUsageField.func_146179_b());
            ArrayList<Integer> data = new ArrayList<Integer>();
            data.add(toUse);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
            this.energyUsageField.func_146180_a("");
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.energyUsageField.func_146178_a();
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        this.energyUsageField.func_146192_a(mouseX, mouseY, button);
        if (button == 0) {
            int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
            int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
            if (xAxis >= 116 && xAxis <= 126 && yAxis >= 51 && yAxis <= 61) {
                this.setEnergyUsage();
                SoundHandler.playSound("gui.button.press");
            }
        }
    }

    public void func_73869_a(char c, int i) {
        if (!this.energyUsageField.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (this.energyUsageField.func_146206_l() && i == 28) {
            this.setEnergyUsage();
            return;
        }
        if (Character.isDigit(c) || i == 14 || i == 211 || i == 203 || i == 205) {
            this.energyUsageField.func_146201_a(c, i);
        }
    }
}

