/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiScrollList;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.frequency.Frequency;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.inventory.container.ContainerTeleporter;
import mekanism.common.item.ItemPortableTeleporter;
import mekanism.common.network.PacketPortableTeleporter;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.IOwnerItem;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTeleporter
extends GuiMekanism {
    public static int MAX_LENGTH = 16;
    public ResourceLocation resource;
    public TileEntityTeleporter tileEntity;
    public ItemStack itemStack;
    public EntityPlayer entityPlayer;
    public GuiButton publicButton;
    public GuiButton privateButton;
    public GuiButton setButton;
    public GuiButton deleteButton;
    public GuiButton teleportButton;
    public GuiScrollList scrollList;
    public GuiTextField frequencyField;
    public boolean privateMode;
    public Frequency clientFreq;
    public byte clientStatus;
    public List<Frequency> clientPublicCache = new ArrayList<Frequency>();
    public List<Frequency> clientPrivateCache = new ArrayList<Frequency>();
    public boolean isInit = true;

    public GuiTeleporter(InventoryPlayer inventory, TileEntityTeleporter tentity) {
        super(tentity, new ContainerTeleporter(inventory, tentity));
        this.tileEntity = tentity;
        this.resource = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiTeleporter.png");
        this.guiElements.add(new GuiRedstoneControl(this, this.tileEntity, this.resource));
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, new GuiPowerBar.IPowerInfoHandler(){

            @Override
            public String getTooltip() {
                return MekanismUtils.getEnergyDisplay(GuiTeleporter.this.getEnergy());
            }

            @Override
            public double getLevel() {
                return GuiTeleporter.this.getEnergy() / GuiTeleporter.this.getMaxEnergy();
            }
        }, this.resource, 158, 26));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.NORMAL, this, this.resource, 152, 6).with(GuiSlot.SlotOverlay.POWER));
        this.scrollList = new GuiScrollList(this, this.resource, 28, 37, 120, 4);
        this.guiElements.add(this.scrollList);
        if (this.tileEntity.frequency != null) {
            this.privateMode = !this.tileEntity.frequency.publicFreq;
        }
        this.field_147000_g += 64;
    }

    public GuiTeleporter(EntityPlayer player, ItemStack stack) {
        super(new ContainerNull());
        this.itemStack = stack;
        this.entityPlayer = player;
        this.resource = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiPortableTeleporter.png");
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, new GuiPowerBar.IPowerInfoHandler(){

            @Override
            public String getTooltip() {
                return MekanismUtils.getEnergyDisplay(GuiTeleporter.this.getEnergy());
            }

            @Override
            public double getLevel() {
                return GuiTeleporter.this.getEnergy() / GuiTeleporter.this.getMaxEnergy();
            }
        }, this.resource, 158, 26));
        this.scrollList = new GuiScrollList(this, this.resource, 28, 37, 120, 4);
        this.guiElements.add(this.scrollList);
        ItemPortableTeleporter item = (ItemPortableTeleporter)this.itemStack.func_77973_b();
        if (item.getFrequency(stack) != null) {
            this.privateMode = item.isPrivateMode(this.itemStack);
            this.setFrequency(item.getFrequency(stack));
        } else {
            Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.DATA_REQUEST, this.clientFreq));
        }
        this.field_147000_g = 175;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.clear();
        this.publicButton = new GuiButton(0, guiWidth + 27, guiHeight + 14, 60, 20, LangUtils.localize("gui.public"));
        this.privateButton = new GuiButton(1, guiWidth + 89, guiHeight + 14, 60, 20, LangUtils.localize("gui.private"));
        this.setButton = new GuiButton(2, guiWidth + 27, guiHeight + 116, 60, 20, LangUtils.localize("gui.set"));
        this.deleteButton = new GuiButton(3, guiWidth + 89, guiHeight + 116, 60, 20, LangUtils.localize("gui.delete"));
        if (this.itemStack != null) {
            this.teleportButton = new GuiButton(4, guiWidth + 42, guiHeight + 140, 92, 20, LangUtils.localize("gui.teleport"));
        }
        this.frequencyField = new GuiTextField(this.field_146289_q, guiWidth + 50, guiHeight + 104, 86, 11);
        this.frequencyField.func_146203_f(MAX_LENGTH);
        this.frequencyField.func_146185_a(false);
        this.updateButtons();
        this.field_146292_n.add(this.publicButton);
        this.field_146292_n.add(this.privateButton);
        this.field_146292_n.add(this.setButton);
        this.field_146292_n.add(this.deleteButton);
        if (this.itemStack != null) {
            this.field_146292_n.add(this.teleportButton);
            if (!this.isInit) {
                Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.DATA_REQUEST, this.clientFreq));
            } else {
                this.isInit = false;
            }
        }
    }

    public void setFrequency(String freq) {
        if (freq.isEmpty()) {
            return;
        }
        if (this.tileEntity != null) {
            ArrayList<Object> data = new ArrayList<Object>();
            data.add(0);
            data.add(freq);
            data.add(!this.privateMode);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
        } else {
            Frequency newFreq = new Frequency(freq, null).setPublic(!this.privateMode);
            Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.SET_FREQ, newFreq));
        }
    }

    public String getSecurity(Frequency freq) {
        return !freq.publicFreq ? (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.private") : LangUtils.localize("gui.public");
    }

    public void updateButtons() {
        if (this.getOwner() == null) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        if (this.privateMode) {
            for (Frequency freq : this.getPrivateCache()) {
                text.add(freq.name);
            }
        } else {
            for (Frequency freq : this.getPublicCache()) {
                text.add(freq.name + " (" + freq.owner + ")");
            }
        }
        this.scrollList.setText(text);
        if (this.privateMode) {
            this.publicButton.field_146124_l = true;
            this.privateButton.field_146124_l = false;
        } else {
            this.publicButton.field_146124_l = false;
            this.privateButton.field_146124_l = true;
        }
        if (this.scrollList.hasSelection()) {
            Frequency freq = this.privateMode ? this.getPrivateCache().get(this.scrollList.selected) : this.getPublicCache().get(this.scrollList.selected);
            this.setButton.field_146124_l = this.getFrequency() == null || !this.getFrequency().equals(freq);
            this.deleteButton.field_146124_l = this.getOwner().equals(freq.owner);
        } else {
            this.setButton.field_146124_l = false;
            this.deleteButton.field_146124_l = false;
        }
        if (this.itemStack != null) {
            this.teleportButton.field_146124_l = this.clientFreq != null && this.clientStatus == 1;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateButtons();
        this.frequencyField.func_146178_a();
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        this.updateButtons();
        this.frequencyField.func_146192_a(mouseX, mouseY, button);
        if (button == 0) {
            int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
            int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
            if (xAxis >= 137 && xAxis <= 148 && yAxis >= 103 && yAxis <= 114) {
                this.setFrequency(this.frequencyField.func_146179_b());
                this.frequencyField.func_146180_a("");
                SoundHandler.playSound("gui.button.press");
            }
        }
    }

    public void func_73869_a(char c, int i) {
        if (!this.frequencyField.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (i == 28 && this.frequencyField.func_146206_l()) {
            this.setFrequency(this.frequencyField.func_146179_b());
            this.frequencyField.func_146180_a("");
        }
        if (Character.isDigit(c) || Character.isLetter(c) || i == 14 || i == 211 || i == 203 || i == 205) {
            this.frequencyField.func_146201_a(c, i);
        }
        this.updateButtons();
    }

    protected void func_146284_a(GuiButton guibutton) {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 0) {
            this.privateMode = false;
        } else if (guibutton.field_146127_k == 1) {
            this.privateMode = true;
        } else if (guibutton.field_146127_k == 2) {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                Frequency freq = this.privateMode ? this.getPrivateCache().get(selection) : this.getPublicCache().get(selection);
                this.setFrequency(freq.name);
            }
        } else if (guibutton.field_146127_k == 3) {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                Frequency freq;
                Frequency frequency = freq = this.privateMode ? this.getPrivateCache().get(selection) : this.getPublicCache().get(selection);
                if (this.tileEntity != null) {
                    ArrayList<Object> data = new ArrayList<Object>();
                    data.add(1);
                    data.add(freq.name);
                    data.add(freq.publicFreq);
                    Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
                } else {
                    Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.DEL_FREQ, freq));
                    Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.DATA_REQUEST, null));
                }
                this.scrollList.selected = -1;
            }
        } else if (guibutton.field_146127_k == 4 && this.clientFreq != null && this.clientStatus == 1) {
            this.field_146297_k.func_71381_h();
            Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.TELEPORT, this.clientFreq));
        }
        this.updateButtons();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146289_q.func_78276_b(this.getInventoryName(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.getInventoryName()) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.owner") + ": " + (this.getOwner() != null ? this.getOwner() : LangUtils.localize("gui.none")), 8, this.itemStack != null ? this.field_147000_g - 12 : this.field_147000_g - 96 + 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.freq") + ":", 32, 81, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.security") + ":", 32, 91, 0x404040);
        this.field_146289_q.func_78276_b(" " + (this.getFrequency() != null ? this.getFrequency().name : (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.none")), 32 + this.field_146289_q.func_78256_a(LangUtils.localize("gui.freq") + ":"), 81, 0x797979);
        this.field_146289_q.func_78276_b(" " + (this.getFrequency() != null ? this.getSecurity(this.getFrequency()) : (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.none")), 32 + this.field_146289_q.func_78256_a(LangUtils.localize("gui.security") + ":"), 91, 0x797979);
        String str = LangUtils.localize("gui.set") + ":";
        this.renderScaledText(str, 27, 104, 0x404040, 20);
        if (xAxis >= 6 && xAxis <= 24 && yAxis >= 6 && yAxis <= 24) {
            if (this.getFrequency() == null) {
                this.func_146279_a((Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.teleporter.noFreq"), xAxis, yAxis);
            } else {
                this.func_146279_a(this.getStatusDisplay(), xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.resource);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 137 && xAxis <= 148 && yAxis >= 103 && yAxis <= 114) {
            this.func_73729_b(guiWidth + 137, guiHeight + 103, this.field_146999_f, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 137, guiHeight + 103, this.field_146999_f, 11, 11, 11);
        }
        int y = this.getFrequency() == null ? 94 : (this.getStatus() == 2 ? 22 : (this.getStatus() == 3 ? 40 : (this.getStatus() == 4 ? 58 : 76)));
        this.func_73729_b(guiWidth + 6, guiHeight + 6, 176, y, 18, 18);
        super.func_146976_a(partialTick, mouseX, mouseY);
        this.frequencyField.func_146194_f();
    }

    public String getStatusDisplay() {
        switch (this.getStatus()) {
            case 1: {
                return (Object)((Object)EnumColor.DARK_GREEN) + LangUtils.localize("gui.teleporter.ready");
            }
            case 2: {
                return (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.teleporter.noFrame");
            }
            case 3: {
                return (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.teleporter.noLink");
            }
            case 4: {
                return (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.teleporter.needsEnergy");
            }
        }
        return (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.teleporter.noLink");
    }

    private String getOwner() {
        if (this.tileEntity != null) {
            return this.tileEntity.getSecurity().getOwner();
        }
        return ((IOwnerItem)this.itemStack.func_77973_b()).getOwner(this.itemStack);
    }

    private byte getStatus() {
        return this.tileEntity != null ? this.tileEntity.status : this.clientStatus;
    }

    private List<Frequency> getPublicCache() {
        return this.tileEntity != null ? this.tileEntity.publicCache : this.clientPublicCache;
    }

    private List<Frequency> getPrivateCache() {
        return this.tileEntity != null ? this.tileEntity.privateCache : this.clientPrivateCache;
    }

    private Frequency getFrequency() {
        return this.tileEntity != null ? this.tileEntity.frequency : this.clientFreq;
    }

    private String getInventoryName() {
        return this.tileEntity != null ? this.tileEntity.func_145825_b() : this.itemStack.func_82833_r();
    }

    private double getEnergy() {
        if (this.itemStack != null) {
            return ((ItemPortableTeleporter)this.itemStack.func_77973_b()).getEnergy(this.itemStack);
        }
        return this.tileEntity.getEnergy();
    }

    private double getMaxEnergy() {
        if (this.itemStack != null) {
            return ((ItemPortableTeleporter)this.itemStack.func_77973_b()).getMaxEnergy(this.itemStack);
        }
        return this.tileEntity.getMaxEnergy();
    }
}

