/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import cofh.api.energy.IEnergyReceiver;
import ic2.api.energy.tile.IEnergySink;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class EnergyAcceptorWrapper
implements IStrictEnergyAcceptor {
    public Coord4D coord;

    public static EnergyAcceptorWrapper get(TileEntity tileEntity) {
        if (tileEntity != null && tileEntity.func_145831_w() == null) {
            return null;
        }
        EnergyAcceptorWrapper wrapper = null;
        if (tileEntity instanceof IStrictEnergyAcceptor) {
            wrapper = new MekanismAcceptor((IStrictEnergyAcceptor)tileEntity);
        } else if (MekanismUtils.useRF() && tileEntity instanceof IEnergyReceiver) {
            wrapper = new RFAcceptor((IEnergyReceiver)tileEntity);
        } else if (MekanismUtils.useIC2() && tileEntity instanceof IEnergySink) {
            wrapper = new IC2Acceptor((IEnergySink)tileEntity);
        }
        if (wrapper != null) {
            wrapper.coord = Coord4D.get(tileEntity);
        }
        return wrapper;
    }

    public abstract boolean needsEnergy(ForgeDirection var1);

    public static class IC2Acceptor
    extends EnergyAcceptorWrapper {
        private IEnergySink acceptor;

        public IC2Acceptor(IEnergySink ic2Acceptor) {
            this.acceptor = ic2Acceptor;
        }

        @Override
        public double transferEnergyToAcceptor(ForgeDirection side, double amount) {
            return amount - this.fromEU(this.acceptor.injectEnergy(side, Math.min(this.acceptor.getDemandedEnergy(), this.toEU(amount)), 0.0));
        }

        @Override
        public boolean canReceiveEnergy(ForgeDirection side) {
            return this.acceptor.acceptsEnergyFrom(null, side);
        }

        @Override
        public double getEnergy() {
            return 0.0;
        }

        @Override
        public void setEnergy(double energy) {
        }

        @Override
        public double getMaxEnergy() {
            return 0.0;
        }

        @Override
        public boolean needsEnergy(ForgeDirection side) {
            return this.acceptor.getDemandedEnergy() > 0.0;
        }

        public double toEU(double joules) {
            return joules * MekanismConfig.general.TO_IC2;
        }

        public double fromEU(double eu) {
            return eu * MekanismConfig.general.FROM_IC2;
        }
    }

    public static class RFAcceptor
    extends EnergyAcceptorWrapper {
        private IEnergyReceiver acceptor;

        public RFAcceptor(IEnergyReceiver rfAcceptor) {
            this.acceptor = rfAcceptor;
        }

        @Override
        public double transferEnergyToAcceptor(ForgeDirection side, double amount) {
            int needed = this.acceptor.getMaxEnergyStored(side) - this.acceptor.getEnergyStored(side);
            int transferred = this.acceptor.receiveEnergy(side, Math.min(needed, this.toRF(amount)), false);
            return this.fromRF(transferred);
        }

        @Override
        public boolean canReceiveEnergy(ForgeDirection side) {
            return this.acceptor.canConnectEnergy(side);
        }

        @Override
        public double getEnergy() {
            return this.fromRF(this.acceptor.getEnergyStored(ForgeDirection.UNKNOWN));
        }

        @Override
        public void setEnergy(double energy) {
            int rfToSet = this.toRF(energy);
            int amountToReceive = rfToSet - this.acceptor.getEnergyStored(ForgeDirection.UNKNOWN);
            this.acceptor.receiveEnergy(ForgeDirection.UNKNOWN, amountToReceive, false);
        }

        @Override
        public double getMaxEnergy() {
            return this.fromRF(this.acceptor.getMaxEnergyStored(ForgeDirection.UNKNOWN));
        }

        @Override
        public boolean needsEnergy(ForgeDirection side) {
            return this.acceptor.receiveEnergy(side, 1, true) > 0;
        }

        public int toRF(double joules) {
            return (int)Math.round(joules * MekanismConfig.general.TO_TE);
        }

        public double fromRF(int rf) {
            return (double)rf * MekanismConfig.general.FROM_TE;
        }
    }

    public static class MekanismAcceptor
    extends EnergyAcceptorWrapper {
        private IStrictEnergyAcceptor acceptor;

        public MekanismAcceptor(IStrictEnergyAcceptor mekAcceptor) {
            this.acceptor = mekAcceptor;
        }

        @Override
        public double transferEnergyToAcceptor(ForgeDirection side, double amount) {
            return this.acceptor.transferEnergyToAcceptor(side, amount);
        }

        @Override
        public boolean canReceiveEnergy(ForgeDirection side) {
            return this.acceptor.canReceiveEnergy(side);
        }

        @Override
        public double getEnergy() {
            return this.acceptor.getEnergy();
        }

        @Override
        public void setEnergy(double energy) {
            this.acceptor.setEnergy(energy);
        }

        @Override
        public double getMaxEnergy() {
            return this.acceptor.getMaxEnergy();
        }

        @Override
        public boolean needsEnergy(ForgeDirection side) {
            return this.acceptor.getMaxEnergy() - this.acceptor.getEnergy() > 0.0;
        }
    }
}

