/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import mekanism.api.Coord4D;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.CTMData;
import mekanism.common.CommonProxy;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.Tier;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IBlockCTM;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.base.ITierItem;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.inventory.InventoryBin;
import mekanism.common.item.ItemBlockBasic;
import mekanism.common.multiblock.IMultiblock;
import mekanism.common.multiblock.IStructuralMultiblock;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.tile.TileEntityBoilerValve;
import mekanism.common.tile.TileEntityDynamicTank;
import mekanism.common.tile.TileEntityDynamicValve;
import mekanism.common.tile.TileEntityInductionCasing;
import mekanism.common.tile.TileEntityInductionCell;
import mekanism.common.tile.TileEntityInductionPort;
import mekanism.common.tile.TileEntityInductionProvider;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.tile.TileEntityPressureDisperser;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.tile.TileEntityStructuralGlass;
import mekanism.common.tile.TileEntitySuperheatingElement;
import mekanism.common.tile.TileEntityThermalEvaporationBlock;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import mekanism.common.tile.TileEntityThermalEvaporationValve;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BlockBasic
extends Block
implements IBlockCTM,
MekanismRenderer.ICustomBlockIcon {
    public IIcon[][] icons = new IIcon[16][16];
    public IIcon[][] binIcons = new IIcon[16][16];
    public CTMData[][] ctms = new CTMData[16][4];
    public static String ICON_BASE = "mekanism:SteelCasing";
    public BasicBlock blockType;

    public BlockBasic(BasicBlock type) {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149752_b(20.0f);
        this.func_149647_a(Mekanism.tabMekanism);
        this.blockType = type;
    }

    @Override
    public IIcon getIcon(ItemStack stack, int side) {
        if (BasicType.get(stack) == BasicType.BIN) {
            return this.binIcons[((ItemBlockBasic)stack.func_77973_b()).getBaseTier(stack).ordinal()][side];
        }
        if (BasicType.get(stack) == BasicType.INDUCTION_CELL) {
            return this.icons[3][((ItemBlockBasic)stack.func_77973_b()).getBaseTier(stack).ordinal()];
        }
        if (BasicType.get(stack) == BasicType.INDUCTION_PROVIDER) {
            return this.icons[4][((ItemBlockBasic)stack.func_77973_b()).getBaseTier(stack).ordinal()];
        }
        return this.func_149691_a(side, stack.func_77960_j());
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (block == this && tileEntity instanceof IMultiblock) {
                ((IMultiblock)tileEntity).update();
            }
            if (tileEntity instanceof TileEntityBasicBlock) {
                ((TileEntityBasicBlock)tileEntity).onNeighborChange(block);
            }
            if (tileEntity instanceof IStructuralMultiblock) {
                ((IStructuralMultiblock)tileEntity).update();
            }
        }
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        BasicType type = BasicType.get(this, world.func_72805_g(x, y, z));
        if (type == BasicType.REFINED_OBSIDIAN) {
            return 4000.0f;
        }
        return this.field_149781_w;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        switch (this.blockType) {
            case BASIC_BLOCK_1: {
                this.ctms[7][0] = new CTMData("ctm/TeleporterFrame", this, Arrays.asList(7)).addOtherBlockConnectivities(MekanismBlocks.MachineBlock, Arrays.asList(11)).registerIcons(register);
                this.ctms[9][0] = new CTMData("ctm/DynamicTank", this, Arrays.asList(9, 11)).registerIcons(register);
                this.ctms[10][0] = new CTMData("ctm/StructuralGlass", this, Arrays.asList(10)).registerIcons(register);
                this.ctms[11][0] = new CTMData("ctm/DynamicValve", this, Arrays.asList(11, 9)).registerIcons(register);
                this.ctms[14][0] = new CTMData("ctm/ThermalEvaporationBlock", this, Arrays.asList(14, 15)).addOtherBlockConnectivities(MekanismBlocks.BasicBlock2, Arrays.asList(0)).addFacingOverride("ctm/ThermalEvaporationController").registerIcons(register);
                this.ctms[14][1] = new CTMData("ctm/ThermalEvaporationBlock", this, Arrays.asList(14, 15)).addOtherBlockConnectivities(MekanismBlocks.BasicBlock2, Arrays.asList(0)).addFacingOverride("ctm/ThermalEvaporationControllerOn").registerIcons(register);
                this.ctms[15][0] = new CTMData("ctm/ThermalEvaporationValve", this, Arrays.asList(15, 14)).addOtherBlockConnectivities(MekanismBlocks.BasicBlock2, Arrays.asList(0)).registerIcons(register);
                this.icons[0][0] = register.func_94245_a("mekanism:OsmiumBlock");
                this.icons[1][0] = register.func_94245_a("mekanism:BronzeBlock");
                this.icons[2][0] = register.func_94245_a("mekanism:RefinedObsidian");
                this.icons[3][0] = register.func_94245_a("mekanism:CoalBlock");
                this.icons[4][0] = register.func_94245_a("mekanism:RefinedGlowstone");
                this.icons[5][0] = register.func_94245_a("mekanism:SteelBlock");
                this.icons[6][0] = register.func_94245_a(ICON_BASE);
                MekanismRenderer.loadDynamicTextures(register, "bin/BinBasic", this.binIcons[0], new MekanismRenderer.DefIcon(register.func_94245_a("mekanism:bin/BinBasicTop"), 0), new MekanismRenderer.DefIcon(register.func_94245_a("mekanism:bin/BinBasicTopOn"), 6));
                MekanismRenderer.loadDynamicTextures(register, "bin/BinAdvanced", this.binIcons[1], new MekanismRenderer.DefIcon(register.func_94245_a("mekanism:bin/BinAdvancedTop"), 0), new MekanismRenderer.DefIcon(register.func_94245_a("mekanism:bin/BinAdvancedTopOn"), 6));
                MekanismRenderer.loadDynamicTextures(register, "bin/BinElite", this.binIcons[2], new MekanismRenderer.DefIcon(register.func_94245_a("mekanism:bin/BinEliteTop"), 0), new MekanismRenderer.DefIcon(register.func_94245_a("mekanism:bin/BinEliteTopOn"), 6));
                MekanismRenderer.loadDynamicTextures(register, "bin/BinUltimate", this.binIcons[3], new MekanismRenderer.DefIcon(register.func_94245_a("mekanism:bin/BinUltimateTop"), 0), new MekanismRenderer.DefIcon(register.func_94245_a("mekanism:bin/BinUltimateTopOn"), 6));
                this.icons[7][0] = this.ctms[7][0].mainTextureData.icon;
                this.icons[8][0] = register.func_94245_a("mekanism:SteelCasing");
                this.icons[9][0] = this.ctms[9][0].mainTextureData.icon;
                this.icons[10][0] = this.ctms[10][0].mainTextureData.icon;
                this.icons[11][0] = this.ctms[11][0].mainTextureData.icon;
                this.icons[12][0] = register.func_94245_a("mekanism:CopperBlock");
                this.icons[13][0] = register.func_94245_a("mekanism:TinBlock");
                this.icons[14][0] = this.ctms[14][0].facingOverride.icon;
                this.icons[14][1] = this.ctms[14][1].facingOverride.icon;
                this.icons[14][2] = this.ctms[14][0].mainTextureData.icon;
                this.icons[15][0] = this.ctms[15][0].mainTextureData.icon;
                break;
            }
            case BASIC_BLOCK_2: {
                this.ctms[0][0] = new CTMData("ctm/ThermalEvaporationBlock", this, Arrays.asList(0)).addOtherBlockConnectivities(MekanismBlocks.BasicBlock, Arrays.asList(14, 15)).registerIcons(register);
                this.ctms[1][0] = new CTMData("ctm/InductionCasing", this, Arrays.asList(1, 2)).registerIcons(register);
                this.ctms[2][0] = new CTMData("ctm/InductionPortInput", this, Arrays.asList(1, 2)).registerIcons(register);
                this.ctms[2][1] = new CTMData("ctm/InductionPortOutput", this, Arrays.asList(1, 2)).registerIcons(register);
                this.ctms[3][0] = new CTMData("ctm/InductionCellBasic", this, Arrays.asList(3, 4)).registerIcons(register).setRenderConvexConnections();
                this.ctms[3][1] = new CTMData("ctm/InductionCellAdvanced", this, Arrays.asList(3, 4)).registerIcons(register).setRenderConvexConnections();
                this.ctms[3][2] = new CTMData("ctm/InductionCellElite", this, Arrays.asList(3, 4)).registerIcons(register).setRenderConvexConnections();
                this.ctms[3][3] = new CTMData("ctm/InductionCellUltimate", this, Arrays.asList(3, 4)).registerIcons(register).setRenderConvexConnections();
                this.ctms[4][0] = new CTMData("ctm/InductionProviderBasic", this, Arrays.asList(3, 4)).registerIcons(register).setRenderConvexConnections();
                this.ctms[4][1] = new CTMData("ctm/InductionProviderAdvanced", this, Arrays.asList(3, 4)).registerIcons(register).setRenderConvexConnections();
                this.ctms[4][2] = new CTMData("ctm/InductionProviderElite", this, Arrays.asList(3, 4)).registerIcons(register).setRenderConvexConnections();
                this.ctms[4][3] = new CTMData("ctm/InductionProviderUltimate", this, Arrays.asList(3, 4)).registerIcons(register).setRenderConvexConnections();
                this.ctms[5][0] = new CTMData("ctm/SuperheatingElement", this, Arrays.asList(5)).registerIcons(register).setRenderConvexConnections();
                this.ctms[5][1] = new CTMData("ctm/SuperheatingElementOn", this, Arrays.asList(5)).registerIcons(register).setRenderConvexConnections();
                this.ctms[7][0] = new CTMData("ctm/BoilerCasing", this, Arrays.asList(7, 8)).registerIcons(register);
                this.ctms[8][0] = new CTMData("ctm/BoilerValve", this, Arrays.asList(7, 8)).registerIcons(register);
                this.icons[6][0] = register.func_94245_a("mekanism:PressureDisperser");
                this.icons[0][0] = this.ctms[0][0].mainTextureData.icon;
                this.icons[1][0] = this.ctms[1][0].mainTextureData.icon;
                this.icons[2][0] = this.ctms[2][0].mainTextureData.icon;
                this.icons[2][1] = this.ctms[2][1].mainTextureData.icon;
                this.icons[3][0] = this.ctms[3][0].mainTextureData.icon;
                this.icons[3][1] = this.ctms[3][1].mainTextureData.icon;
                this.icons[3][2] = this.ctms[3][2].mainTextureData.icon;
                this.icons[3][3] = this.ctms[3][3].mainTextureData.icon;
                this.icons[4][0] = this.ctms[4][0].mainTextureData.icon;
                this.icons[4][1] = this.ctms[4][1].mainTextureData.icon;
                this.icons[4][2] = this.ctms[4][2].mainTextureData.icon;
                this.icons[4][3] = this.ctms[4][3].mainTextureData.icon;
                this.icons[5][0] = this.ctms[5][0].mainTextureData.icon;
                this.icons[5][1] = this.ctms[5][1].mainTextureData.icon;
                this.icons[7][0] = this.ctms[7][0].mainTextureData.icon;
                this.icons[8][0] = this.ctms[8][0].mainTextureData.icon;
                this.icons[9][0] = register.func_94245_a(ICON_BASE);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        switch (this.blockType) {
            case BASIC_BLOCK_1: {
                switch (meta) {
                    case 6: {
                        TileEntityBin tileEntity = (TileEntityBin)world.func_147438_o(x, y, z);
                        boolean active = MekanismUtils.isActive(world, x, y, z);
                        return this.binIcons[tileEntity.tier.ordinal()][MekanismUtils.getBaseOrientation(side, tileEntity.facing) + (active ? 6 : 0)];
                    }
                    case 14: {
                        TileEntityThermalEvaporationController tileEntity1 = (TileEntityThermalEvaporationController)world.func_147438_o(x, y, z);
                        if (side == tileEntity1.facing) {
                            return MekanismUtils.isActive(world, x, y, z) ? this.icons[meta][1] : this.icons[meta][0];
                        }
                        return this.icons[meta][2];
                    }
                }
                return this.func_149691_a(side, meta);
            }
            case BASIC_BLOCK_2: {
                switch (meta) {
                    case 2: {
                        TileEntityInductionPort tileEntity = (TileEntityInductionPort)world.func_147438_o(x, y, z);
                        return this.icons[meta][tileEntity.mode ? 1 : 0];
                    }
                    case 3: {
                        TileEntityInductionCell tileEntity1 = (TileEntityInductionCell)world.func_147438_o(x, y, z);
                        return this.icons[meta][tileEntity1.tier.ordinal()];
                    }
                    case 4: {
                        TileEntityInductionProvider tileEntity2 = (TileEntityInductionProvider)world.func_147438_o(x, y, z);
                        return this.icons[meta][tileEntity2.tier.ordinal()];
                    }
                    case 5: {
                        TileEntitySuperheatingElement element = (TileEntitySuperheatingElement)world.func_147438_o(x, y, z);
                        if (element.multiblockUUID != null && SynchronizedBoilerData.clientHotMap.get(element.multiblockUUID) != null) {
                            return this.icons[meta][SynchronizedBoilerData.clientHotMap.get(element.multiblockUUID) != false ? 1 : 0];
                        }
                        return this.icons[meta][0];
                    }
                }
                return this.func_149691_a(side, meta);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        switch (this.blockType) {
            case BASIC_BLOCK_1: {
                switch (meta) {
                    case 14: {
                        if (side == 2) {
                            return this.icons[meta][0];
                        }
                        return this.icons[meta][2];
                    }
                }
                return this.icons[meta][0];
            }
            case BASIC_BLOCK_2: {
                return this.icons[meta][0];
            }
        }
        return this.icons[meta][0];
    }

    public int func_149692_a(int i) {
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativetabs, List list) {
        block3: for (BasicType type : BasicType.values()) {
            if (type.typeBlock != this.blockType) continue;
            switch (type) {
                case INDUCTION_CELL: 
                case INDUCTION_PROVIDER: 
                case BIN: {
                    for (Tier.BaseTier tier : Tier.BaseTier.values()) {
                        if (!tier.isObtainable()) continue;
                        ItemStack stack = new ItemStack(item, 1, type.meta);
                        ((ItemBlockBasic)stack.func_77973_b()).setBaseTier(stack, tier);
                        list.add(stack);
                    }
                    continue block3;
                }
                default: {
                    list.add(new ItemStack(item, 1, type.meta));
                }
            }
        }
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        switch (this.blockType) {
            case BASIC_BLOCK_1: {
                switch (meta) {
                    case 10: {
                        return false;
                    }
                    case 9: 
                    case 11: {
                        TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)world.func_147438_o(x, y, z);
                        if (tileEntity == null || !(FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? tileEntity.structure != null : tileEntity.clientHasStructure)) break;
                        return false;
                    }
                }
                return super.canCreatureSpawn(type, world, x, y, z);
            }
            case BASIC_BLOCK_2: {
                switch (meta) {
                    case 1: 
                    case 2: 
                    case 7: 
                    case 8: {
                        TileEntityMultiblock tileEntity = (TileEntityMultiblock)world.func_147438_o(x, y, z);
                        if (tileEntity == null || !(FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? tileEntity.structure != null : tileEntity.clientHasStructure)) break;
                        return false;
                    }
                }
                return super.canCreatureSpawn(type, world, x, y, z);
            }
        }
        return super.canCreatureSpawn(type, world, x, y, z);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        BasicType type = BasicType.get(this, world.func_72805_g(x, y, z));
        if (!world.field_72995_K && type == BasicType.BIN) {
            TileEntityBin bin = (TileEntityBin)world.func_147438_o(x, y, z);
            MovingObjectPosition pos = MekanismUtils.rayTrace(world, player);
            if (pos != null && pos.field_72310_e == bin.facing && bin.bottomStack != null) {
                if (!player.func_70093_af()) {
                    world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, bin.removeStack().func_77946_l()));
                } else {
                    world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, bin.remove(1).func_77946_l()));
                }
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int i1, float f1, float f2, float f3) {
        int metadata = world.func_72805_g(x, y, z);
        BasicType type = BasicType.get(this, metadata);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (type == BasicType.REFINED_OBSIDIAN && entityplayer.func_70093_af()) {
            entityplayer.openGui((Object)Mekanism.instance, 1, world, x, y, z);
            return true;
        }
        if (tile instanceof TileEntityThermalEvaporationController) {
            if (!entityplayer.func_70093_af()) {
                if (!world.field_72995_K) {
                    entityplayer.openGui((Object)Mekanism.instance, 33, world, x, y, z);
                }
                return true;
            }
        } else if (tile instanceof TileEntitySecurityDesk) {
            String owner = ((TileEntitySecurityDesk)tile).owner;
            if (!entityplayer.func_70093_af()) {
                if (!world.field_72995_K) {
                    if (owner == null || entityplayer.func_70005_c_().equals(owner)) {
                        entityplayer.openGui((Object)Mekanism.instance, 57, world, x, y, z);
                    } else {
                        SecurityUtils.displayNoAccess(entityplayer);
                    }
                }
                return true;
            }
        } else {
            if (tile instanceof TileEntityBin) {
                TileEntityBin bin = (TileEntityBin)world.func_147438_o(x, y, z);
                if (entityplayer.func_71045_bC() != null && MekanismUtils.hasUsableWrench(entityplayer, x, y, z)) {
                    if (!world.field_72995_K) {
                        Item tool = entityplayer.func_71045_bC().func_77973_b();
                        if (entityplayer.func_70093_af()) {
                            this.dismantleBlock(world, x, y, z, false);
                            return true;
                        }
                        if (MekanismUtils.isBCWrench(tool)) {
                            ((IToolWrench)tool).wrenchUsed(entityplayer, x, y, z);
                        }
                        int change = ForgeDirection.ROTATION_MATRIX[ForgeDirection.UP.ordinal()][bin.facing];
                        bin.setFacing((short)change);
                        world.func_147459_d(x, y, z, (Block)this);
                    }
                    return true;
                }
                if (!world.field_72995_K && bin.getItemCount() < bin.tier.storage) {
                    if (bin.addTicks == 0 && entityplayer.func_71045_bC() != null) {
                        if (entityplayer.func_71045_bC() != null) {
                            ItemStack remain = bin.add(entityplayer.func_71045_bC());
                            entityplayer.func_70062_b(0, remain);
                            bin.addTicks = 5;
                        }
                    } else if (bin.addTicks > 0 && bin.getItemCount() > 0) {
                        ItemStack[] inv = entityplayer.field_71071_by.field_70462_a;
                        for (int i = 0; i < inv.length && bin.getItemCount() != bin.tier.storage; ++i) {
                            if (inv[i] != null) {
                                ItemStack remain;
                                inv[i] = remain = bin.add(inv[i]);
                                bin.addTicks = 5;
                            }
                            ((EntityPlayerMP)entityplayer).func_71110_a(entityplayer.field_71070_bA, entityplayer.field_71070_bA.func_75138_a());
                        }
                    }
                }
                return true;
            }
            if (tile instanceof IMultiblock) {
                if (world.field_72995_K) {
                    return true;
                }
                return ((IMultiblock)world.func_147438_o(x, y, z)).onActivate(entityplayer);
            }
            if (tile instanceof IStructuralMultiblock) {
                if (world.field_72995_K) {
                    return true;
                }
                return ((IStructuralMultiblock)world.func_147438_o(x, y, z)).onActivate(entityplayer);
            }
        }
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return BasicType.get(this, world.func_72805_g(x, y, z)) != BasicType.STRUCTURAL_GLASS;
    }

    public static boolean manageInventory(EntityPlayer player, TileEntityDynamicTank tileEntity) {
        ItemStack itemStack = player.func_71045_bC();
        if (itemStack != null && tileEntity.structure != null) {
            if (FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack)) {
                ItemStack filled;
                if (((SynchronizedTankData)tileEntity.structure).fluidStored != null && ((SynchronizedTankData)tileEntity.structure).fluidStored.amount >= 1000 && (filled = FluidContainerRegistry.fillFluidContainer((FluidStack)((SynchronizedTankData)tileEntity.structure).fluidStored, (ItemStack)itemStack)) != null) {
                    if (player.field_71075_bZ.field_75098_d) {
                        ((SynchronizedTankData)tileEntity.structure).fluidStored.amount -= FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount;
                        if (((SynchronizedTankData)tileEntity.structure).fluidStored.amount == 0) {
                            ((SynchronizedTankData)tileEntity.structure).fluidStored = null;
                        }
                        return true;
                    }
                    if (itemStack.field_77994_a > 1) {
                        if (player.field_71071_by.func_70441_a(filled)) {
                            --itemStack.field_77994_a;
                            ((SynchronizedTankData)tileEntity.structure).fluidStored.amount -= FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount;
                            if (((SynchronizedTankData)tileEntity.structure).fluidStored.amount == 0) {
                                ((SynchronizedTankData)tileEntity.structure).fluidStored = null;
                            }
                            return true;
                        }
                    } else if (itemStack.field_77994_a == 1) {
                        player.func_70062_b(0, filled);
                        ((SynchronizedTankData)tileEntity.structure).fluidStored.amount -= FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount;
                        if (((SynchronizedTankData)tileEntity.structure).fluidStored.amount == 0) {
                            ((SynchronizedTankData)tileEntity.structure).fluidStored = null;
                        }
                        return true;
                    }
                }
            } else if (FluidContainerRegistry.isFilledContainer((ItemStack)itemStack)) {
                FluidStack itemFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
                int max = ((SynchronizedTankData)tileEntity.structure).volume * 16000;
                if (((SynchronizedTankData)tileEntity.structure).fluidStored == null || ((SynchronizedTankData)tileEntity.structure).fluidStored.isFluidEqual(itemFluid) && ((SynchronizedTankData)tileEntity.structure).fluidStored.amount + itemFluid.amount <= max) {
                    boolean filled = false;
                    if (player.field_71075_bZ.field_75098_d) {
                        filled = true;
                    } else {
                        ItemStack containerItem = itemStack.func_77973_b().getContainerItem(itemStack);
                        if (containerItem != null) {
                            if (itemStack.field_77994_a == 1) {
                                player.func_70062_b(0, containerItem);
                                filled = true;
                            } else if (player.field_71071_by.func_70441_a(containerItem)) {
                                --itemStack.field_77994_a;
                                filled = true;
                            }
                        } else {
                            --itemStack.field_77994_a;
                            if (itemStack.field_77994_a == 0) {
                                player.func_70062_b(0, null);
                            }
                            filled = true;
                        }
                    }
                    if (filled) {
                        if (((SynchronizedTankData)tileEntity.structure).fluidStored == null) {
                            ((SynchronizedTankData)tileEntity.structure).fluidStored = itemFluid;
                        } else {
                            ((SynchronizedTankData)tileEntity.structure).fluidStored.amount += itemFluid.amount;
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return CommonProxy.CTM_RENDER_ID;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (tileEntity instanceof IActiveState && ((IActiveState)tileEntity).getActive() && ((IActiveState)tileEntity).lightUpdate()) {
            return 15;
        }
        if (this.blockType == BasicBlock.BASIC_BLOCK_1) {
            switch (metadata) {
                case 2: {
                    return 8;
                }
                case 4: {
                    return 15;
                }
                case 7: {
                    return 12;
                }
            }
        } else if (this.blockType == BasicBlock.BASIC_BLOCK_2 && metadata == 5) {
            TileEntitySuperheatingElement element = (TileEntitySuperheatingElement)tileEntity;
            if (element.multiblockUUID != null && SynchronizedBoilerData.clientHotMap.get(element.multiblockUUID) != null) {
                return SynchronizedBoilerData.clientHotMap.get(element.multiblockUUID) != false ? 15 : 0;
            }
            return 0;
        }
        return 0;
    }

    public boolean hasTileEntity(int metadata) {
        BasicType type = BasicType.get(this.blockType, metadata);
        return type != null && type.tileEntityClass != null;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!world.field_72995_K && tileEntity instanceof TileEntityBasicBlock) {
            ((TileEntityBasicBlock)tileEntity).onAdded();
        }
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (BasicType.get(this.blockType, metadata) == null) {
            return null;
        }
        return BasicType.get(this.blockType, metadata).create();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemstack) {
        TileEntityBasicBlock tileEntity;
        if (world.func_147438_o(x, y, z) instanceof TileEntityBasicBlock) {
            tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
            int side = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int height = Math.round(entityliving.field_70125_A);
            int change = 3;
            if (tileEntity.canSetFacing(0) && tileEntity.canSetFacing(1)) {
                if (height >= 65) {
                    change = 1;
                } else if (height <= -65) {
                    change = 0;
                }
            }
            if (change != 0 && change != 1) {
                switch (side) {
                    case 0: {
                        change = 2;
                        break;
                    }
                    case 1: {
                        change = 5;
                        break;
                    }
                    case 2: {
                        change = 3;
                        break;
                    }
                    case 3: {
                        change = 4;
                    }
                }
            }
            tileEntity.setFacing((short)change);
            tileEntity.redstone = world.func_72864_z(x, y, z);
            if (tileEntity instanceof TileEntitySecurityDesk) {
                ((TileEntitySecurityDesk)tileEntity).owner = entityliving.func_70005_c_();
            }
            if (tileEntity instanceof IBoundingBlock) {
                ((IBoundingBlock)((Object)tileEntity)).onPlace();
            }
        }
        world.func_147479_m(x, y, z);
        world.func_147463_c(EnumSkyBlock.Block, x, y, z);
        world.func_147463_c(EnumSkyBlock.Sky, x, y, z);
        if (!world.field_72995_K && world.func_147438_o(x, y, z) != null) {
            tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity instanceof IMultiblock) {
                ((IMultiblock)((Object)tileEntity)).update();
            }
            if (tileEntity instanceof IStructuralMultiblock) {
                ((IStructuralMultiblock)((Object)tileEntity)).update();
            }
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IBoundingBlock) {
            ((IBoundingBlock)tileEntity).onBreak();
        }
        super.func_149749_a(world, x, y, z, block, meta);
        world.func_147475_p(x, y, z);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        TileEntityBasicBlock tileEntity;
        BasicType type = BasicType.get(this, world.func_72805_g(x, y, z));
        ItemStack ret = new ItemStack((Block)this, 1, type.meta);
        if (type == BasicType.BIN) {
            tileEntity = (TileEntityBin)world.func_147438_o(x, y, z);
            InventoryBin inv = new InventoryBin(ret);
            ((ITierItem)ret.func_77973_b()).setBaseTier(ret, ((TileEntityBin)tileEntity).tier.getBaseTier());
            inv.setItemCount(((TileEntityBin)tileEntity).getItemCount());
            if (((TileEntityBin)tileEntity).getItemCount() > 0) {
                inv.setItemType(((TileEntityBin)tileEntity).itemType);
            }
        } else if (type == BasicType.INDUCTION_CELL) {
            tileEntity = (TileEntityInductionCell)world.func_147438_o(x, y, z);
            ((ItemBlockBasic)ret.func_77973_b()).setBaseTier(ret, ((TileEntityInductionCell)tileEntity).tier.getBaseTier());
        } else if (type == BasicType.INDUCTION_PROVIDER) {
            tileEntity = (TileEntityInductionProvider)world.func_147438_o(x, y, z);
            ((ItemBlockBasic)ret.func_77973_b()).setBaseTier(ret, ((TileEntityInductionProvider)tileEntity).tier.getBaseTier());
        }
        tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IStrictEnergyStorage) {
            IEnergizedItem energizedItem = (IEnergizedItem)ret.func_77973_b();
            energizedItem.setEnergy(ret, ((IStrictEnergyStorage)((Object)tileEntity)).getEnergy());
        }
        return ret;
    }

    public Item func_149650_a(int i, Random random, int j) {
        return null;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && willHarvest) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, this.getPickBlock(null, world, x, y, z, player));
            world.func_72838_d((Entity)entityItem);
        }
        return world.func_147468_f(x, y, z);
    }

    public ItemStack dismantleBlock(World world, int x, int y, int z, boolean returnBlock) {
        ItemStack itemStack = this.getPickBlock(null, world, x, y, z, null);
        world.func_147468_f(x, y, z);
        if (!returnBlock) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, itemStack);
            world.func_72838_d((Entity)entityItem);
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        Coord4D obj = new Coord4D(x, y, z).getFromSide(ForgeDirection.getOrientation((int)side).getOpposite());
        if (BasicType.get(this, obj.getMetadata(world)) == BasicType.STRUCTURAL_GLASS) {
            return this.ctms[10][0].shouldRenderSide(world, x, y, z, side);
        }
        return super.func_149646_a(world, x, y, z, side);
    }

    public ForgeDirection[] getValidRotations(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        ForgeDirection[] valid = new ForgeDirection[6];
        if (tile instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock basicTile = (TileEntityBasicBlock)tile;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!basicTile.canSetFacing(dir.ordinal())) continue;
                valid[dir.ordinal()] = dir;
            }
        }
        return valid;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntityBasicBlock basicTile;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityBasicBlock && (basicTile = (TileEntityBasicBlock)tile).canSetFacing(axis.ordinal())) {
            basicTile.setFacing((short)axis.ordinal());
            return true;
        }
        return false;
    }

    @Override
    public CTMData getCTMData(IBlockAccess world, int x, int y, int z, int meta) {
        if (this.ctms[meta][1] != null && MekanismUtils.isActive(world, x, y, z)) {
            return this.ctms[meta][1];
        }
        BasicType type = BasicType.get(this, world.func_72805_g(x, y, z));
        if (type == BasicType.INDUCTION_CELL) {
            TileEntityInductionCell tileEntity = (TileEntityInductionCell)world.func_147438_o(x, y, z);
            return this.ctms[meta][tileEntity.tier.ordinal()];
        }
        if (type == BasicType.INDUCTION_PROVIDER) {
            TileEntityInductionProvider tileEntity = (TileEntityInductionProvider)world.func_147438_o(x, y, z);
            return this.ctms[meta][tileEntity.tier.ordinal()];
        }
        if (type == BasicType.SUPERHEATING_ELEMENT) {
            TileEntitySuperheatingElement element = (TileEntitySuperheatingElement)world.func_147438_o(x, y, z);
            if (element.multiblockUUID != null && SynchronizedBoilerData.clientHotMap.get(element.multiblockUUID) != null) {
                return this.ctms[meta][SynchronizedBoilerData.clientHotMap.get(element.multiblockUUID) != false ? 1 : 0];
            }
            return this.ctms[meta][0];
        }
        return this.ctms[meta][0];
    }

    @Override
    public boolean shouldRenderBlock(IBlockAccess world, int x, int y, int z, int meta) {
        return BasicType.get(this, world.func_72805_g(x, y, z)) != BasicType.SECURITY_DESK;
    }

    public static enum BasicBlock {
        BASIC_BLOCK_1,
        BASIC_BLOCK_2;


        public Block getBlock() {
            switch (this) {
                case BASIC_BLOCK_1: {
                    return MekanismBlocks.BasicBlock;
                }
                case BASIC_BLOCK_2: {
                    return MekanismBlocks.BasicBlock2;
                }
            }
            return null;
        }
    }

    public static enum BasicType {
        OSMIUM_BLOCK(BasicBlock.BASIC_BLOCK_1, 0, "OsmiumBlock", null, false),
        BRONZE_BLOCK(BasicBlock.BASIC_BLOCK_1, 1, "BronzeBlock", null, false),
        REFINED_OBSIDIAN(BasicBlock.BASIC_BLOCK_1, 2, "RefinedObsidian", null, false),
        CHARCOAL_BLOCK(BasicBlock.BASIC_BLOCK_1, 3, "CharcoalBlock", null, false),
        REFINED_GLOWSTONE(BasicBlock.BASIC_BLOCK_1, 4, "RefinedGlowstone", null, false),
        STEEL_BLOCK(BasicBlock.BASIC_BLOCK_1, 5, "SteelBlock", null, false),
        BIN(BasicBlock.BASIC_BLOCK_1, 6, "Bin", TileEntityBin.class, true),
        TELEPORTER_FRAME(BasicBlock.BASIC_BLOCK_1, 7, "TeleporterFrame", null, true),
        STEEL_CASING(BasicBlock.BASIC_BLOCK_1, 8, "SteelCasing", null, true),
        DYNAMIC_TANK(BasicBlock.BASIC_BLOCK_1, 9, "DynamicTank", TileEntityDynamicTank.class, true),
        STRUCTURAL_GLASS(BasicBlock.BASIC_BLOCK_1, 10, "StructuralGlass", TileEntityStructuralGlass.class, true),
        DYNAMIC_VALVE(BasicBlock.BASIC_BLOCK_1, 11, "DynamicValve", TileEntityDynamicValve.class, true),
        COPPER_BLOCK(BasicBlock.BASIC_BLOCK_1, 12, "CopperBlock", null, false),
        TIN_BLOCK(BasicBlock.BASIC_BLOCK_1, 13, "TinBlock", null, false),
        THERMAL_EVAPORATION_CONTROLLER(BasicBlock.BASIC_BLOCK_1, 14, "ThermalEvaporationController", TileEntityThermalEvaporationController.class, true),
        THERMAL_EVAPORATION_VALVE(BasicBlock.BASIC_BLOCK_1, 15, "ThermalEvaporationValve", TileEntityThermalEvaporationValve.class, true),
        THERMAL_EVAPORATION_BLOCK(BasicBlock.BASIC_BLOCK_2, 0, "ThermalEvaporationBlock", TileEntityThermalEvaporationBlock.class, true),
        INDUCTION_CASING(BasicBlock.BASIC_BLOCK_2, 1, "InductionCasing", TileEntityInductionCasing.class, true),
        INDUCTION_PORT(BasicBlock.BASIC_BLOCK_2, 2, "InductionPort", TileEntityInductionPort.class, true),
        INDUCTION_CELL(BasicBlock.BASIC_BLOCK_2, 3, "InductionCell", TileEntityInductionCell.class, true),
        INDUCTION_PROVIDER(BasicBlock.BASIC_BLOCK_2, 4, "InductionProvider", TileEntityInductionProvider.class, true),
        SUPERHEATING_ELEMENT(BasicBlock.BASIC_BLOCK_2, 5, "SuperheatingElement", TileEntitySuperheatingElement.class, true),
        PRESSURE_DISPERSER(BasicBlock.BASIC_BLOCK_2, 6, "PressureDisperser", TileEntityPressureDisperser.class, true),
        BOILER_CASING(BasicBlock.BASIC_BLOCK_2, 7, "BoilerCasing", TileEntityBoilerCasing.class, true),
        BOILER_VALVE(BasicBlock.BASIC_BLOCK_2, 8, "BoilerValve", TileEntityBoilerValve.class, true),
        SECURITY_DESK(BasicBlock.BASIC_BLOCK_2, 9, "SecurityDesk", TileEntitySecurityDesk.class, true);

        public BasicBlock typeBlock;
        public int meta;
        public String name;
        public Class<? extends TileEntity> tileEntityClass;
        public boolean hasDescription;

        private BasicType(BasicBlock block, int i, String s, Class<? extends TileEntity> tileClass, boolean hasDesc) {
            this.typeBlock = block;
            this.meta = i;
            this.name = s;
            this.tileEntityClass = tileClass;
            this.hasDescription = hasDesc;
        }

        public static BasicType get(Block block, int meta) {
            if (block instanceof BlockBasic) {
                return BasicType.get(((BlockBasic)block).blockType, meta);
            }
            return null;
        }

        public static BasicType get(BasicBlock block, int meta) {
            for (BasicType type : BasicType.values()) {
                if (type.meta != meta || type.typeBlock != block) continue;
                return type;
            }
            return null;
        }

        public TileEntity create() {
            try {
                return this.tileEntityClass.newInstance();
            }
            catch (Exception e) {
                Mekanism.logger.error("Unable to indirectly create tile entity.");
                e.printStackTrace();
                return null;
            }
        }

        public String getDescription() {
            return LangUtils.localize("tooltip." + this.name);
        }

        public ItemStack getStack() {
            return new ItemStack(this.typeBlock.getBlock(), 1, this.meta);
        }

        public static BasicType get(ItemStack stack) {
            return BasicType.get(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77960_j());
        }
    }
}

