/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.entangloporter;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.common.frequency.Frequency;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class InventoryFrequency
extends Frequency {
    public static final String ENTANGLOPORTER = "Entangloporter";
    public static final double MAX_ENERGY = 1000000.0;
    public double storedEnergy;
    public FluidTank storedFluid;
    public GasTank storedGas;
    public ItemStack storedItem;
    public double temperature;

    public InventoryFrequency(String n, String o) {
        super(n, o);
        this.storedFluid = new FluidTank(1000);
        this.storedGas = new GasTank(1000);
    }

    public InventoryFrequency(NBTTagCompound nbtTags) {
        super(nbtTags);
    }

    public InventoryFrequency(ByteBuf dataStream) {
        super(dataStream);
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74780_a("storedEnergy", this.storedEnergy);
        if (this.storedFluid.getFluid() != null) {
            nbtTags.func_74782_a("storedFluid", (NBTBase)this.storedFluid.writeToNBT(new NBTTagCompound()));
        }
        if (this.storedGas.getGas() != null) {
            nbtTags.func_74782_a("storedGas", (NBTBase)this.storedGas.write(new NBTTagCompound()));
        }
        if (this.storedItem != null) {
            nbtTags.func_74782_a("storedItem", (NBTBase)this.storedItem.func_77955_b(new NBTTagCompound()));
        }
        nbtTags.func_74780_a("temperature", this.temperature);
    }

    @Override
    protected void read(NBTTagCompound nbtTags) {
        super.read(nbtTags);
        this.storedFluid = new FluidTank(1000);
        this.storedGas = new GasTank(1000);
        this.storedEnergy = nbtTags.func_74769_h("storedEnergy");
        if (nbtTags.func_74764_b("storedFluid")) {
            this.storedFluid.readFromNBT(nbtTags.func_74775_l("storedFluid"));
        }
        if (nbtTags.func_74764_b("storedGas")) {
            this.storedGas.read(nbtTags.func_74775_l("storedGas"));
        }
        if (nbtTags.func_74764_b("storedItem")) {
            this.storedItem.func_77963_c(nbtTags.func_74775_l("storedItem"));
        }
        this.temperature = nbtTags.func_74769_h("temperature");
    }

    @Override
    public void write(ArrayList data) {
        super.write(data);
        data.add(this.storedEnergy);
        if (this.storedFluid.getFluid() != null) {
            data.add(true);
            data.add(this.storedFluid.getFluid().getFluidID());
            data.add(this.storedFluid.getFluidAmount());
        } else {
            data.add(false);
        }
        if (this.storedGas.getGas() != null) {
            data.add(true);
            data.add(this.storedGas.getGasType().getID());
            data.add(this.storedGas.getStored());
        } else {
            data.add(false);
        }
        data.add(this.temperature);
    }

    @Override
    protected void read(ByteBuf dataStream) {
        super.read(dataStream);
        this.storedFluid = new FluidTank(1000);
        this.storedGas = new GasTank(1000);
        this.storedEnergy = dataStream.readDouble();
        if (dataStream.readBoolean()) {
            this.storedFluid.setFluid(new FluidStack(FluidRegistry.getFluid((int)dataStream.readInt()), dataStream.readInt()));
        } else {
            this.storedFluid.setFluid(null);
        }
        if (dataStream.readBoolean()) {
            this.storedGas.setGas(new GasStack(dataStream.readInt(), dataStream.readInt()));
        } else {
            this.storedGas.setGas(null);
        }
        this.temperature = dataStream.readDouble();
    }
}

