/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.frequency;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.IFrequencyHandler;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class FrequencyManager {
    public static boolean loaded;
    private static Set<FrequencyManager> managers;
    private Set<Frequency> frequencies = new HashSet<Frequency>();
    private FrequencyDataHandler dataHandler;
    private String owner;
    private String name;
    private Class<? extends Frequency> frequencyClass;

    public FrequencyManager(Class c, String n) {
        this.frequencyClass = c;
        this.name = n;
        managers.add(this);
    }

    public FrequencyManager(Class c, String n, String s) {
        this(c, n);
        this.owner = s;
    }

    public static void load(World world) {
        loaded = true;
        for (FrequencyManager manager : managers) {
            manager.createOrLoad(world);
        }
    }

    public Frequency update(String user, Coord4D coord, Frequency freq) {
        for (Frequency iterFreq : this.frequencies) {
            if (!freq.equals(iterFreq)) continue;
            iterFreq.activeCoords.add(coord);
            this.dataHandler.func_76185_a();
            return iterFreq;
        }
        this.deactivate(coord);
        return null;
    }

    public void remove(String name, String owner) {
        Iterator<Frequency> iter = this.getFrequencies().iterator();
        while (iter.hasNext()) {
            Frequency iterFreq = iter.next();
            if (!iterFreq.name.equals(name) || !iterFreq.owner.equals(owner)) continue;
            iter.remove();
            this.dataHandler.func_76185_a();
        }
    }

    public void remove(String name) {
        Iterator<Frequency> iter = this.getFrequencies().iterator();
        while (iter.hasNext()) {
            Frequency iterFreq = iter.next();
            if (!iterFreq.name.equals(name)) continue;
            iter.remove();
            this.dataHandler.func_76185_a();
        }
    }

    public int removeAll(String user) {
        int amount = 0;
        Iterator<Frequency> iter = this.getFrequencies().iterator();
        while (iter.hasNext()) {
            Frequency iterFreq = iter.next();
            if (!iterFreq.owner.equals(user)) continue;
            iter.remove();
            this.dataHandler.func_76185_a();
            ++amount;
        }
        return amount;
    }

    public void deactivate(Coord4D coord) {
        for (Frequency freq : this.frequencies) {
            freq.activeCoords.remove(coord);
            this.dataHandler.func_76185_a();
        }
    }

    public Frequency validateFrequency(String user, Coord4D coord, Frequency freq) {
        for (Frequency iterFreq : this.frequencies) {
            if (!freq.equals(iterFreq)) continue;
            iterFreq.activeCoords.add(coord);
            this.dataHandler.func_76185_a();
            return iterFreq;
        }
        if (user.equals(freq.owner)) {
            freq.activeCoords.add(coord);
            this.frequencies.add(freq);
            this.dataHandler.func_76185_a();
            return freq;
        }
        return null;
    }

    public void createOrLoad(World world) {
        String name = this.getName();
        if (this.dataHandler == null) {
            this.dataHandler = (FrequencyDataHandler)world.perWorldStorage.func_75742_a(FrequencyDataHandler.class, name);
            if (this.dataHandler == null) {
                this.dataHandler = new FrequencyDataHandler(name);
                this.dataHandler.setManager(this);
                world.perWorldStorage.func_75745_a(name, (WorldSavedData)this.dataHandler);
            } else {
                this.dataHandler.setManager(this);
                this.dataHandler.syncManager();
            }
        }
    }

    public static FrequencyManager loadOnly(World world, String owner, Class<? extends Frequency> freqClass, String n) {
        FrequencyManager manager = new FrequencyManager(freqClass, n);
        String name = manager.getName();
        FrequencyDataHandler handler = (FrequencyDataHandler)world.perWorldStorage.func_75742_a(FrequencyDataHandler.class, name);
        if (handler == null) {
            return null;
        }
        manager.dataHandler = handler;
        manager.dataHandler.syncManager();
        return manager;
    }

    public Set<Frequency> getFrequencies() {
        return this.frequencies;
    }

    public void addFrequency(Frequency freq) {
        this.frequencies.add(freq);
        this.dataHandler.func_76185_a();
    }

    public boolean containsFrequency(String name) {
        for (Frequency freq : this.frequencies) {
            if (!freq.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static void tick(World world) {
        if (!loaded) {
            FrequencyManager.load(world);
        }
        for (FrequencyManager manager : managers) {
            manager.tickSelf(world);
        }
    }

    public void tickSelf(World world) {
        for (Frequency iterFreq : this.frequencies) {
            Iterator<Coord4D> iter = iterFreq.activeCoords.iterator();
            while (iter.hasNext()) {
                Coord4D coord = iter.next();
                if (coord.dimensionId != world.field_73011_w.field_76574_g) continue;
                if (!coord.exists(world)) {
                    iter.remove();
                    continue;
                }
                TileEntity tile = coord.getTileEntity((IBlockAccess)world);
                if (!(tile instanceof IFrequencyHandler)) {
                    iter.remove();
                    continue;
                }
                Frequency freq = ((IFrequencyHandler)tile).getFrequency(this);
                if (freq != null && freq.equals(iterFreq)) continue;
                iter.remove();
            }
        }
    }

    public void writeFrequencies(ArrayList data) {
        data.add(this.frequencies.size());
        for (Frequency freq : this.frequencies) {
            freq.write(data);
        }
    }

    public Set<Frequency> readFrequencies(ByteBuf dataStream) {
        HashSet<Frequency> ret = new HashSet<Frequency>();
        int size = dataStream.readInt();
        try {
            for (int i = 0; i < size; ++i) {
                Frequency freq = this.frequencyClass.getConstructor(ByteBuf.class).newInstance(dataStream);
                freq.read(dataStream);
                ret.add(freq);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public String getName() {
        return this.owner != null ? this.owner + "_" + this.name + "FrequencyHandler" : this.name + "FrequencyHandler";
    }

    public static void reset() {
        for (FrequencyManager manager : managers) {
            manager.frequencies.clear();
            manager.dataHandler = null;
        }
        loaded = false;
    }

    static {
        managers = new HashSet<FrequencyManager>();
    }

    public static class FrequencyDataHandler
    extends WorldSavedData {
        public FrequencyManager manager;
        public Set<Frequency> loadedFrequencies;
        public String loadedOwner;

        public FrequencyDataHandler(String tagName) {
            super(tagName);
        }

        public void setManager(FrequencyManager m) {
            this.manager = m;
        }

        public void syncManager() {
            if (this.loadedFrequencies != null) {
                this.manager.frequencies = this.loadedFrequencies;
                this.manager.owner = this.loadedOwner;
            }
        }

        public void func_76184_a(NBTTagCompound nbtTags) {
            try {
                String frequencyClass = nbtTags.func_74779_i("frequencyClass");
                if (nbtTags.func_74764_b("owner")) {
                    this.loadedOwner = nbtTags.func_74779_i("owner");
                }
                NBTTagList list = nbtTags.func_150295_c("freqList", 10);
                this.loadedFrequencies = new HashSet<Frequency>();
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound compound = list.func_150305_b(i);
                    Constructor<?> c = Class.forName(frequencyClass).getConstructor(NBTTagCompound.class);
                    Frequency freq = (Frequency)c.newInstance(compound);
                    this.loadedFrequencies.add(freq);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void func_76187_b(NBTTagCompound nbtTags) {
            nbtTags.func_74778_a("frequencyClass", this.manager.frequencyClass.getName());
            if (this.manager.owner != null) {
                nbtTags.func_74778_a("owner", this.manager.owner);
            }
            NBTTagList list = new NBTTagList();
            for (Frequency freq : this.manager.getFrequencies()) {
                NBTTagCompound compound = new NBTTagCompound();
                freq.write(compound);
                list.func_74742_a((NBTBase)compound);
            }
            nbtTags.func_74782_a("freqList", (NBTBase)list);
        }
    }
}

