/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container;

import mekanism.api.infuse.InfuseRegistry;
import mekanism.common.Tier;
import mekanism.common.base.IFactory;
import mekanism.common.inventory.slot.SlotEnergy;
import mekanism.common.inventory.slot.SlotOutput;
import mekanism.common.item.ItemBlockMachine;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.util.ChargeUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerFactory
extends Container {
    private TileEntityFactory tileEntity;

    public ContainerFactory(InventoryPlayer inventory, TileEntityFactory tentity) {
        int slotX;
        int xAxis;
        int i;
        this.tileEntity = tentity;
        this.func_75146_a(new SlotEnergy.SlotDischarge(tentity, 1, 7, 13));
        this.func_75146_a(new Slot((IInventory)tentity, 2, 180, 75));
        this.func_75146_a(new Slot((IInventory)tentity, 3, 180, 112));
        this.func_75146_a(new Slot((IInventory)tentity, 4, 7, 57));
        if (this.tileEntity.tier == Tier.FactoryTier.BASIC) {
            for (i = 0; i < this.tileEntity.tier.processes; ++i) {
                xAxis = 55 + i * 38;
                this.func_75146_a(new Slot((IInventory)tentity, 5 + i, xAxis, 13));
            }
            for (i = 0; i < this.tileEntity.tier.processes; ++i) {
                xAxis = 55 + i * 38;
                this.func_75146_a(new SlotOutput(tentity, this.tileEntity.tier.processes + 5 + i, xAxis, 57));
            }
        } else if (this.tileEntity.tier == Tier.FactoryTier.ADVANCED) {
            for (i = 0; i < this.tileEntity.tier.processes; ++i) {
                xAxis = 35 + i * 26;
                this.func_75146_a(new Slot((IInventory)tentity, 5 + i, xAxis, 13));
            }
            for (i = 0; i < this.tileEntity.tier.processes; ++i) {
                xAxis = 35 + i * 26;
                this.func_75146_a(new SlotOutput(tentity, this.tileEntity.tier.processes + 5 + i, xAxis, 57));
            }
        } else if (this.tileEntity.tier == Tier.FactoryTier.ELITE) {
            for (i = 0; i < this.tileEntity.tier.processes; ++i) {
                xAxis = 29 + i * 19;
                this.func_75146_a(new Slot((IInventory)tentity, 5 + i, xAxis, 13));
            }
            for (i = 0; i < this.tileEntity.tier.processes; ++i) {
                xAxis = 29 + i * 19;
                this.func_75146_a(new SlotOutput(tentity, this.tileEntity.tier.processes + 5 + i, xAxis, 57));
            }
        }
        for (int slotY = 0; slotY < 3; ++slotY) {
            for (slotX = 0; slotX < 9; ++slotX) {
                this.func_75146_a(new Slot((IInventory)inventory, slotX + slotY * 9 + 9, 8 + slotX * 18, 95 + slotY * 18));
            }
        }
        for (slotX = 0; slotX < 9; ++slotX) {
            this.func_75146_a(new Slot((IInventory)inventory, slotX, 8 + slotX * 18, 153));
        }
        this.tileEntity.open(inventory.field_70458_d);
        this.tileEntity.func_70295_k_();
    }

    public void func_75134_a(EntityPlayer entityplayer) {
        super.func_75134_a(entityplayer);
        this.tileEntity.close(entityplayer);
        this.tileEntity.func_70305_f();
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return this.tileEntity.func_70300_a(entityplayer);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotID) {
        ItemStack stack = null;
        Slot currentSlot = (Slot)this.field_75151_b.get(slotID);
        if (currentSlot != null && currentSlot.func_75216_d()) {
            int slotEnd;
            ItemStack slotStack = currentSlot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (this.isOutputSlot(slotID) ? !this.func_75135_a(slotStack, this.tileEntity.inventory.length - 1, this.field_75151_b.size(), true) : (slotID != 1 && slotID != 2 && this.isProperMachine(slotStack) && !slotStack.func_77969_a(this.tileEntity.getMachineStack()) ? !this.func_75135_a(slotStack, 1, 2, false) : (slotID == 2 ? !this.func_75135_a(slotStack, this.tileEntity.inventory.length - 1, this.field_75151_b.size(), true) : (this.tileEntity.recipeType.getAnyRecipe(slotStack, this.tileEntity.gasTank.getGasType(), this.tileEntity.infuseStored) != null ? (!this.isInputSlot(slotID) ? !this.func_75135_a(slotStack, 4, 4 + this.tileEntity.tier.processes, false) : !this.func_75135_a(slotStack, this.tileEntity.inventory.length - 1, this.field_75151_b.size(), true)) : (ChargeUtils.canBeDischarged(slotStack) ? (slotID != 0 ? !this.func_75135_a(slotStack, 0, 1, false) : slotID == 0 && !this.func_75135_a(slotStack, this.tileEntity.inventory.length - 1, this.field_75151_b.size(), true)) : (this.tileEntity.recipeType.getItemGas(slotStack) != null ? (slotID > this.tileEntity.inventory.length - 1 ? !this.func_75135_a(slotStack, 3, 4, false) : !this.func_75135_a(slotStack, this.tileEntity.inventory.length - 1, this.field_75151_b.size(), true)) : (this.tileEntity.recipeType == IFactory.RecipeType.INFUSING && InfuseRegistry.getObject(slotStack) != null && (this.tileEntity.infuseStored.type == null || this.tileEntity.infuseStored.type == InfuseRegistry.getObject((ItemStack)slotStack).type) ? (slotID > this.tileEntity.inventory.length - 1 ? !this.func_75135_a(slotStack, 3, 4, false) : !this.func_75135_a(slotStack, this.tileEntity.inventory.length - 1, this.field_75151_b.size(), true)) : (slotID >= (slotEnd = this.tileEntity.inventory.length - 1) && slotID <= slotEnd + 26 ? !this.func_75135_a(slotStack, slotEnd + 27, this.field_75151_b.size(), false) : (slotID > slotEnd + 26 ? !this.func_75135_a(slotStack, slotEnd, slotEnd + 26, false) : !this.func_75135_a(slotStack, slotEnd, this.field_75151_b.size(), true)))))))))) {
                return null;
            }
            if (slotStack.field_77994_a == 0) {
                currentSlot.func_75215_d((ItemStack)null);
            } else {
                currentSlot.func_75218_e();
            }
            if (slotStack.field_77994_a == stack.field_77994_a) {
                return null;
            }
            currentSlot.func_82870_a(player, slotStack);
        }
        return stack;
    }

    public boolean isProperMachine(ItemStack itemStack) {
        IFactory.RecipeType[] arr$;
        int len$;
        int i$;
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemBlockMachine && (i$ = 0) < (len$ = (arr$ = IFactory.RecipeType.values()).length)) {
            IFactory.RecipeType type = arr$[i$];
            return itemStack.func_77969_a(type.getStack());
        }
        return false;
    }

    public boolean isInputSlot(int slot) {
        if (this.tileEntity.tier == Tier.FactoryTier.BASIC) {
            return slot >= 4 && slot <= 6;
        }
        if (this.tileEntity.tier == Tier.FactoryTier.ADVANCED) {
            return slot >= 4 && slot <= 8;
        }
        if (this.tileEntity.tier == Tier.FactoryTier.ELITE) {
            return slot >= 4 && slot <= 10;
        }
        return false;
    }

    public boolean isOutputSlot(int slot) {
        if (this.tileEntity.tier == Tier.FactoryTier.BASIC) {
            return slot >= 7 && slot <= 9;
        }
        if (this.tileEntity.tier == Tier.FactoryTier.ADVANCED) {
            return slot >= 9 && slot <= 13;
        }
        if (this.tileEntity.tier == Tier.FactoryTier.ELITE) {
            return slot >= 11 && slot <= 17;
        }
        return false;
    }
}

