/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Range4D;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.Tier;
import mekanism.common.base.ITierItem;
import mekanism.common.block.BlockBasic;
import mekanism.common.inventory.InventoryBin;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityInductionCell;
import mekanism.common.tile.TileEntityInductionProvider;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemBlockBasic
extends ItemBlock
implements IEnergizedItem,
ITierItem {
    public Block metaBlock;

    public ItemBlockBasic(Block block) {
        super(block);
        this.metaBlock = block;
        this.func_77627_a(true);
    }

    public int getItemStackLimit(ItemStack stack) {
        if (BlockBasic.BasicType.get(stack) == BlockBasic.BasicType.BIN) {
            return new InventoryBin(stack).getItemCount() == 0 ? super.getItemStackLimit(stack) : 1;
        }
        return super.getItemStackLimit(stack);
    }

    public ItemStack getUnchargedCell(Tier.InductionCellTier tier) {
        ItemStack stack = new ItemStack(MekanismBlocks.BasicBlock2, 1, 3);
        this.setBaseTier(stack, tier.getBaseTier());
        return stack;
    }

    public ItemStack getUnchargedProvider(Tier.InductionProviderTier tier) {
        ItemStack stack = new ItemStack(MekanismBlocks.BasicBlock2, 1, 4);
        this.setBaseTier(stack, tier.getBaseTier());
        return stack;
    }

    @Override
    public Tier.BaseTier getBaseTier(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return Tier.BaseTier.BASIC;
        }
        return Tier.BaseTier.values()[itemstack.field_77990_d.func_74762_e("tier")];
    }

    @Override
    public void setBaseTier(ItemStack itemstack, Tier.BaseTier tier) {
        if (itemstack.field_77990_d == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.field_77990_d.func_74768_a("tier", tier.ordinal());
    }

    public int func_77647_b(int i) {
        return i;
    }

    public IIcon func_77617_a(int i) {
        return this.metaBlock.func_149691_a(2, i);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        BlockBasic.BasicType type = BlockBasic.BasicType.get(itemstack);
        if (type.hasDescription) {
            if (!MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.sneakKey)) {
                if (type == BlockBasic.BasicType.BIN) {
                    InventoryBin inv = new InventoryBin(itemstack);
                    if (inv.getItemCount() > 0) {
                        list.add((Object)((Object)EnumColor.BRIGHT_GREEN) + inv.getItemType().func_82833_r());
                        list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.itemAmount") + ": " + (Object)((Object)EnumColor.GREY) + inv.getItemCount());
                    } else {
                        list.add((Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.empty"));
                    }
                } else if (type == BlockBasic.BasicType.INDUCTION_CELL) {
                    Tier.InductionCellTier tier = Tier.InductionCellTier.values()[this.getBaseTier(itemstack).ordinal()];
                    list.add((Object)((Object)tier.getBaseTier().getColor()) + LangUtils.localize("tooltip.capacity") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(tier.maxEnergy));
                } else if (type == BlockBasic.BasicType.INDUCTION_PROVIDER) {
                    Tier.InductionProviderTier tier = Tier.InductionProviderTier.values()[this.getBaseTier(itemstack).ordinal()];
                    list.add((Object)((Object)tier.getBaseTier().getColor()) + LangUtils.localize("tooltip.outputRate") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(tier.output));
                }
                if (this.getMaxEnergy(itemstack) > 0.0) {
                    list.add((Object)((Object)EnumColor.BRIGHT_GREEN) + LangUtils.localize("tooltip.storedEnergy") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(this.getEnergy(itemstack)));
                }
                list.add(LangUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.INDIGO) + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.forDetails") + ".");
            } else {
                list.addAll(MekanismUtils.splitTooltip(type.getDescription(), itemstack));
            }
        }
    }

    public boolean hasContainerItem(ItemStack stack) {
        return BlockBasic.BasicType.get(stack) == BlockBasic.BasicType.BIN && stack.field_77990_d != null && stack.field_77990_d.func_74764_b("newCount");
    }

    public boolean func_77630_h(ItemStack stack) {
        return BlockBasic.BasicType.get(stack) != BlockBasic.BasicType.BIN;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (BlockBasic.BasicType.get(stack) == BlockBasic.BasicType.BIN) {
            if (stack.field_77990_d == null || !stack.field_77990_d.func_74764_b("newCount")) {
                return null;
            }
            int newCount = stack.field_77990_d.func_74762_e("newCount");
            stack.field_77990_d.func_82580_o("newCount");
            ItemStack ret = stack.func_77946_l();
            ret.field_77990_d.func_74768_a("itemCount", newCount);
            return ret;
        }
        return null;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean place = true;
        BlockBasic.BasicType type = BlockBasic.BasicType.get(stack);
        if (!(type != BlockBasic.BasicType.SECURITY_DESK || y + 1 <= 255 && world.func_147439_a(x, y + 1, z).isReplaceable((IBlockAccess)world, x, y + 1, z))) {
            place = false;
        }
        if (place && super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            TileEntityBasicBlock tileEntity;
            if (type == BlockBasic.BasicType.BIN && stack.field_77990_d != null) {
                tileEntity = (TileEntityBin)world.func_147438_o(x, y, z);
                InventoryBin inv = new InventoryBin(stack);
                ((TileEntityBin)tileEntity).tier = Tier.BinTier.values()[this.getBaseTier(stack).ordinal()];
                if (inv.getItemType() != null) {
                    ((TileEntityBin)tileEntity).setItemType(inv.getItemType());
                }
                ((TileEntityBin)tileEntity).setItemCount(inv.getItemCount());
            } else if (type == BlockBasic.BasicType.INDUCTION_CELL) {
                tileEntity = (TileEntityInductionCell)world.func_147438_o(x, y, z);
                ((TileEntityInductionCell)tileEntity).tier = Tier.InductionCellTier.values()[this.getBaseTier(stack).ordinal()];
                if (!world.field_72995_K) {
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), ((TileEntityInductionCell)tileEntity).getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(tileEntity)));
                }
            } else if (type == BlockBasic.BasicType.INDUCTION_PROVIDER) {
                tileEntity = (TileEntityInductionProvider)world.func_147438_o(x, y, z);
                ((TileEntityInductionProvider)tileEntity).tier = Tier.InductionProviderTier.values()[this.getBaseTier(stack).ordinal()];
                if (!world.field_72995_K) {
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), ((TileEntityInductionProvider)tileEntity).getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(tileEntity)));
                }
            }
            tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity instanceof IStrictEnergyStorage && !(tileEntity instanceof TileEntityMultiblock)) {
                ((IStrictEnergyStorage)((Object)tileEntity)).setEnergy(this.getEnergy(stack));
            }
        }
        return place;
    }

    public String func_77667_c(ItemStack itemstack) {
        BlockBasic.BasicType type = BlockBasic.BasicType.get(itemstack);
        if (type != null) {
            String name = this.func_77658_a() + "." + BlockBasic.BasicType.get((ItemStack)itemstack).name;
            if (type == BlockBasic.BasicType.BIN || type == BlockBasic.BasicType.INDUCTION_CELL || type == BlockBasic.BasicType.INDUCTION_PROVIDER) {
                name = name + this.getBaseTier(itemstack).getName();
            }
            return name;
        }
        return "null";
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        if (BlockBasic.BasicType.get(itemStack) == BlockBasic.BasicType.INDUCTION_CELL) {
            if (itemStack.field_77990_d == null) {
                return 0.0;
            }
            return itemStack.field_77990_d.func_74769_h("energyStored");
        }
        return 0.0;
    }

    @Override
    public void setEnergy(ItemStack itemStack, double amount) {
        if (BlockBasic.BasicType.get(itemStack) == BlockBasic.BasicType.INDUCTION_CELL) {
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74780_a("energyStored", Math.max(Math.min(amount, this.getMaxEnergy(itemStack)), 0.0));
        }
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        if (BlockBasic.BasicType.get(itemStack) == BlockBasic.BasicType.INDUCTION_CELL) {
            return Tier.InductionCellTier.values()[this.getBaseTier((ItemStack)itemStack).ordinal()].maxEnergy;
        }
        return 0.0;
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return 0.0;
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }
}

