/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import codechicken.lib.inventory.InventoryUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.common.item.ItemMekanism;
import mekanism.common.util.LangUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemCraftingFormula
extends ItemMekanism {
    public IIcon[] icons = new IIcon[3];

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icons[0] = register.func_94245_a("mekanism:CraftingFormula");
        this.icons[1] = register.func_94245_a("mekanism:CraftingFormulaInvalid");
        this.icons[2] = register.func_94245_a("mekanism:CraftingFormulaEncoded");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        return this.getInventory(stack) == null ? this.icons[0] : (this.isInvalid(stack) ? this.icons[1] : this.icons[2]);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        ItemStack[] inv = this.getInventory(itemstack);
        if (inv != null) {
            this.addIngredientDetails(inv, list);
        }
    }

    private void addIngredientDetails(ItemStack[] inv, List list) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack stack : inv) {
            if (stack == null) continue;
            boolean found = false;
            for (ItemStack iterStack : stacks) {
                if (!InventoryUtils.canStack((ItemStack)stack, (ItemStack)iterStack)) continue;
                iterStack.field_77994_a += stack.field_77994_a;
                found = true;
            }
            if (found) continue;
            stacks.add(stack);
        }
        list.add((Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.ingredients") + ":");
        for (ItemStack stack : stacks) {
            list.add((Object)((Object)EnumColor.GREY) + " - " + stack.func_82833_r() + " (" + stack.field_77994_a + ")");
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af() && !world.field_72995_K) {
            this.setInventory(stack, null);
            this.setInvalid(stack, false);
            ((EntityPlayerMP)player).func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
            return stack;
        }
        return stack;
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.getInventory(stack) != null ? 1 : 64;
    }

    public String func_77653_i(ItemStack stack) {
        if (this.getInventory(stack) == null) {
            return super.func_77653_i(stack);
        }
        return super.func_77653_i(stack) + " " + (this.isInvalid(stack) ? (Object)((Object)EnumColor.DARK_RED) + "(" + LangUtils.localize("tooltip.invalid") : (Object)((Object)EnumColor.DARK_GREEN) + "(" + LangUtils.localize("tooltip.encoded")) + ")";
    }

    public boolean isInvalid(ItemStack stack) {
        if (stack.field_77990_d == null) {
            return false;
        }
        return stack.field_77990_d.func_74767_n("invalid");
    }

    public void setInvalid(ItemStack stack, boolean invalid) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74757_a("invalid", invalid);
    }

    public ItemStack[] getInventory(ItemStack stack) {
        if (stack.field_77990_d == null || !stack.field_77990_d.func_74764_b("Items")) {
            return null;
        }
        NBTTagList tagList = stack.field_77990_d.func_150295_c("Items", 10);
        ItemStack[] inventory = new ItemStack[9];
        for (int tagCount = 0; tagCount < tagList.func_74745_c(); ++tagCount) {
            NBTTagCompound tagCompound = tagList.func_150305_b(tagCount);
            byte slotID = tagCompound.func_74771_c("Slot");
            if (slotID < 0 || slotID >= 9) continue;
            inventory[slotID] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        return inventory;
    }

    public void setInventory(ItemStack stack, ItemStack[] inv) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (inv == null) {
            stack.field_77990_d.func_82580_o("Items");
            return;
        }
        NBTTagList tagList = new NBTTagList();
        for (int slotCount = 0; slotCount < 9; ++slotCount) {
            if (inv[slotCount] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)slotCount);
            inv[slotCount].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        stack.field_77990_d.func_74782_a("Items", (NBTBase)tagList);
    }
}

