/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import mekanism.common.Tier;
import mekanism.common.base.IFactory;
import mekanism.common.item.ItemMekanism;
import mekanism.common.tile.TileEntityAdvancedElectricMachine;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.tile.TileEntityElectricMachine;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.TileEntityMetallurgicInfuser;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemFactoryInstaller
extends ItemMekanism {
    public IIcon[] icons = new IIcon[256];

    public ItemFactoryInstaller() {
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        Tier.FactoryTier tier = Tier.FactoryTier.values()[stack.func_77960_j()];
        if (tile instanceof TileEntityBasicBlock && ((TileEntityBasicBlock)tile).playersUsing.size() > 0) {
            return true;
        }
        if (tile instanceof TileEntityFactory && tier != Tier.FactoryTier.BASIC) {
            TileEntityFactory factory = (TileEntityFactory)tile;
            if (factory.tier.ordinal() + 1 == tier.ordinal()) {
                if (!world.field_72995_K) {
                    factory.upgrade();
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.field_77994_a = 0;
                }
                return true;
            }
        } else if (tile != null && tier == Tier.FactoryTier.BASIC) {
            IFactory.RecipeType type = null;
            for (IFactory.RecipeType iterType : IFactory.RecipeType.values()) {
                ItemStack machineStack = iterType.getStack();
                if (Block.func_149634_a((Item)machineStack.func_77973_b()) != world.func_147439_a(x, y, z) || machineStack.func_77960_j() != world.func_72805_g(x, y, z)) continue;
                type = iterType;
                break;
            }
            if (type != null) {
                if (tile instanceof TileEntityElectricMachine) {
                    ((TileEntityElectricMachine)tile).upgrade(type);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.field_77994_a = 0;
                    }
                    return true;
                }
                if (tile instanceof TileEntityAdvancedElectricMachine) {
                    ((TileEntityAdvancedElectricMachine)tile).upgrade(type);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.field_77994_a = 0;
                    }
                    return true;
                }
                if (tile instanceof TileEntityMetallurgicInfuser) {
                    ((TileEntityMetallurgicInfuser)tile).upgrade(type);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.field_77994_a = 0;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private int getOutputSlot(Tier.FactoryTier tier, int operation) {
        return 5 + tier.processes + operation;
    }

    @Override
    public void func_94581_a(IIconRegister register) {
        for (Tier.FactoryTier tier : Tier.FactoryTier.values()) {
            this.icons[tier.ordinal()] = register.func_94245_a("mekanism:" + tier.getBaseTier().getName() + "FactoryInstaller");
        }
    }

    public IIcon func_77617_a(int meta) {
        return this.icons[meta];
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        for (Tier.FactoryTier tier : Tier.FactoryTier.values()) {
            itemList.add(new ItemStack(item, 1, tier.ordinal()));
        }
    }

    public String func_77667_c(ItemStack item) {
        return "item." + Tier.BaseTier.values()[item.func_77960_j()].getName().toLowerCase() + "FactoryInstaller";
    }
}

