/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Range4D;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.render.RenderPartTransmitter;
import mekanism.common.InventoryNetwork;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.base.ITransporterTile;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.multipart.MultipartTransporter;
import mekanism.common.multipart.PartSidedPipe;
import mekanism.common.multipart.PartTransmitter;
import mekanism.common.multipart.TransmitterIcons;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.network.PacketDataRequest;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class PartLogisticalTransporter
extends PartTransmitter<IInventory, InventoryNetwork>
implements ITransporterTile {
    public Tier.TransporterTier tier = Tier.TransporterTier.BASIC;
    public static TransmitterIcons transporterIcons = new TransmitterIcons(8, 16);
    public int pullDelay = 0;

    public PartLogisticalTransporter(Tier.TransporterTier transporterTier) {
        this();
        this.tier = transporterTier;
    }

    public PartLogisticalTransporter() {
        this.transmitterDelegate = new MultipartTransporter(this);
    }

    public String getType() {
        return "mekanism:logistical_transporter_" + this.tier.name().toLowerCase();
    }

    @Override
    public TransmitterType getTransmitterType() {
        return this.tier.type;
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.ITEM;
    }

    public static void registerIcons(IIconRegister register) {
        transporterIcons.registerCenterIcons(register, new String[]{"LogisticalTransporterBasic", "LogisticalTransporterAdvanced", "LogisticalTransporterElite", "LogisticalTransporterUltimate", "RestrictiveTransporter", "DiversionTransporter", "LogisticalTransporterGlass", "LogisticalTransporterGlassColored"});
        transporterIcons.registerSideIcons(register, new String[]{"LogisticalTransporterVerticalBasic", "LogisticalTransporterVerticalAdvanced", "LogisticalTransporterVerticalElite", "LogisticalTransporterVerticalUltimate", "LogisticalTransporterHorizontalBasic", "LogisticalTransporterHorizontalAdvanced", "LogisticalTransporterHorizontalElite", "LogisticalTransporterHorizontalUltimate", "RestrictiveTransporterVertical", "RestrictiveTransporterHorizontal", "LogisticalTransporterVerticalGlass", "LogisticalTransporterVerticalGlassColored", "LogisticalTransporterHorizontalGlass", "LogisticalTransporterHorizontalGlassColored", "DiversionTransporterVertical", "DiversionTransporterHorizontal"});
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float f, int pass) {
        if (pass == 0) {
            RenderPartTransmitter.getInstance().renderContents(this, f, pos);
        }
    }

    public void onWorldSeparate() {
        super.onWorldSeparate();
        if (!this.world().field_72995_K) {
            PathfinderCache.onChanged(Coord4D.get((TileEntity)this.tile()));
        }
    }

    @Override
    protected boolean isValidTransmitter(TileEntity tileEntity) {
        ILogisticalTransporter transporter = ((ITransporterTile)tileEntity).getTransmitter();
        if (this.getTransmitter().getColor() == null || transporter.getColor() == null || this.getTransmitter().getColor() == transporter.getColor()) {
            return super.isValidTransmitter(tileEntity);
        }
        return false;
    }

    @Override
    public IIcon getCenterIcon(boolean opaque) {
        return transporterIcons.getCenterIcon(opaque ? this.tier.ordinal() : (this.getTransmitter().color != null ? 7 : 6));
    }

    @Override
    public IIcon getSideIcon(boolean opaque) {
        return transporterIcons.getSideIcon(opaque ? this.tier.ordinal() : (this.getTransmitter().color != null ? 11 : 10));
    }

    @Override
    public IIcon getSideIconRotated(boolean opaque) {
        return transporterIcons.getSideIcon(opaque ? 4 + this.tier.ordinal() : (this.getTransmitter().color != null ? 13 : 12));
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, ForgeDirection side) {
        return TransporterUtils.isValidAcceptorOnSide(tile, side);
    }

    @Override
    public boolean handlesRedstone() {
        return false;
    }

    @Override
    public void update() {
        super.update();
        this.getTransmitter().update();
    }

    protected void pullItems() {
        if (this.pullDelay == 0) {
            boolean did = false;
            for (ForgeDirection side : this.getConnections(PartSidedPipe.ConnectionType.PULL)) {
                IInventory inv;
                InvStack stack;
                TileEntity tile = Coord4D.get((TileEntity)this.tile()).getFromSide(side).getTileEntity((IBlockAccess)this.world());
                if (!(tile instanceof IInventory) || (stack = InventoryUtils.takeTopItem(inv = (IInventory)tile, side.ordinal(), this.tier.pullAmount)) == null || stack.getStack() == null) continue;
                ItemStack rejects = TransporterUtils.insert(tile, this.getTransmitter(), stack.getStack(), this.getTransmitter().getColor(), true, 0);
                if (!TransporterManager.didEmit(stack.getStack(), rejects)) continue;
                did = true;
                stack.use(TransporterManager.getToUse((ItemStack)stack.getStack(), (ItemStack)rejects).field_77994_a);
            }
            if (did) {
                this.pullDelay = 10;
            }
        } else {
            --this.pullDelay;
        }
    }

    @Override
    public void onWorldJoin() {
        super.onWorldJoin();
        if (this.world().field_72995_K) {
            Mekanism.packetHandler.sendToServer(new PacketDataRequest.DataRequestMessage(Coord4D.get((TileEntity)this.tile())));
        } else {
            PathfinderCache.onChanged(Coord4D.get((TileEntity)this.tile()));
        }
    }

    @Override
    public InventoryNetwork createNewNetwork() {
        return new InventoryNetwork();
    }

    @Override
    public InventoryNetwork createNetworkByMerging(Collection<InventoryNetwork> networks) {
        return new InventoryNetwork(networks);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) throws Exception {
        super.handlePacketData(dataStream);
        if (this.world().field_72995_K) {
            int type = dataStream.readInt();
            if (type == 0) {
                int c = dataStream.readInt();
                EnumColor prev = this.getTransmitter().getColor();
                if (c != -1) {
                    this.getTransmitter().setColor(TransporterUtils.colors.get(c));
                } else {
                    this.getTransmitter().setColor(null);
                }
                if (prev != this.getTransmitter().getColor()) {
                    this.tile().markRender();
                }
                this.getTransmitter().transit.clear();
                int amount = dataStream.readInt();
                for (int i = 0; i < amount; ++i) {
                    this.getTransmitter().transit.add(TransporterStack.readFromPacket(dataStream));
                }
            } else if (type == 1) {
                boolean kill = dataStream.readBoolean();
                int index = dataStream.readInt();
                if (kill) {
                    this.getTransmitter().transit.remove(index);
                } else {
                    TransporterStack stack = TransporterStack.readFromPacket(dataStream);
                    if (stack.progress == 0) {
                        stack.progress = 5;
                    }
                    this.getTransmitter().transit.replace(index, stack);
                }
            }
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(0);
        if (this.getTransmitter().getColor() != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.getTransmitter().getColor()));
        } else {
            data.add(-1);
        }
        data.add(this.getTransmitter().transit.size());
        for (TransporterStack stack : this.getTransmitter().transit) {
            stack.write(this.getTransmitter(), data);
        }
        return data;
    }

    public ArrayList getSyncPacket(TransporterStack stack, boolean kill) {
        ArrayList<Constable> data = new ArrayList<Constable>();
        data.add(Integer.valueOf(1));
        data.add(Boolean.valueOf(kill));
        data.add(Integer.valueOf(this.getTransmitter().transit.indexOf(stack)));
        if (!kill) {
            stack.write(this.getTransmitter(), data);
        }
        return data;
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        super.load(nbtTags);
        this.tier = Tier.TransporterTier.values()[nbtTags.func_74762_e("tier")];
        if (nbtTags.func_74764_b("color")) {
            this.getTransmitter().setColor(TransporterUtils.colors.get(nbtTags.func_74762_e("color")));
        }
        if (nbtTags.func_74764_b("stacks")) {
            NBTTagList tagList = nbtTags.func_150295_c("stacks", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                TransporterStack stack = TransporterStack.readFromNBT(tagList.func_150305_b(i));
                this.getTransmitter().transit.add(stack);
            }
        }
    }

    @Override
    public void save(NBTTagCompound nbtTags) {
        super.save(nbtTags);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        if (this.getTransmitter().getColor() != null) {
            nbtTags.func_74768_a("color", TransporterUtils.colors.indexOf((Object)this.getTransmitter().getColor()));
        }
        NBTTagList stacks = new NBTTagList();
        for (TransporterStack stack : this.getTransmitter().transit) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            stack.write(tagCompound);
            stacks.func_74742_a((NBTBase)tagCompound);
        }
        if (stacks.func_74745_c() != 0) {
            nbtTags.func_74782_a("stacks", (NBTBase)stacks);
        }
    }

    @Override
    protected boolean onConfigure(EntityPlayer player, int part, int side) {
        TransporterUtils.incrementColor(this.getTransmitter());
        this.refreshConnections();
        this.notifyTileChange();
        PathfinderCache.onChanged(Coord4D.get((TileEntity)this.tile()));
        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get((TileEntity)this.tile()), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get((TileEntity)this.tile())));
        player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.configurator.toggleColor") + ": " + (this.getTransmitter().getColor() != null ? this.getTransmitter().getColor().getName() : (Object)((Object)EnumColor.BLACK) + LangUtils.localize("gui.none"))));
        return true;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, int side) {
        super.onRightClick(player, side);
        player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.configurator.viewColor") + ": " + (this.getTransmitter().getColor() != null ? this.getTransmitter().getColor().getName() : "None")));
        return true;
    }

    @Override
    public EnumColor getRenderColor(boolean post) {
        return post ? null : this.getTransmitter().getColor();
    }

    @Override
    public boolean transparencyRender() {
        return true;
    }

    public void onRemoved() {
        super.onRemoved();
        if (!this.world().field_72995_K) {
            for (TransporterStack stack : this.getTransmitter().transit) {
                TransporterUtils.drop(this.getTransmitter(), stack);
            }
        }
    }

    @Override
    public int getCapacity() {
        return 0;
    }

    @Override
    public Object getBuffer() {
        return null;
    }

    @Override
    public void takeShare() {
    }

    @Override
    public void updateShare() {
    }

    @Override
    public MultipartTransporter getTransmitter() {
        return (MultipartTransporter)this.transmitterDelegate;
    }

    public double getCost() {
        return (double)Tier.TransporterTier.ULTIMATE.speed / (double)this.tier.speed;
    }

    @Override
    public boolean upgrade(int tierOrdinal) {
        if (this.tier.ordinal() < Tier.BaseTier.ULTIMATE.ordinal() && tierOrdinal == this.tier.ordinal() + 1) {
            this.tier = Tier.TransporterTier.values()[this.tier.ordinal() + 1];
            this.markDirtyTransmitters();
            this.sendDesc = true;
            return true;
        }
        return false;
    }

    @Override
    public void readDesc(MCDataInput packet) {
        this.tier = Tier.TransporterTier.values()[packet.readInt()];
        super.readDesc(packet);
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        packet.writeInt(this.tier.ordinal());
        super.writeDesc(packet);
    }
}

