/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.render.RenderPartTransmitter;
import mekanism.common.FluidNetwork;
import mekanism.common.Tier;
import mekanism.common.multipart.PartSidedPipe;
import mekanism.common.multipart.PartTransmitter;
import mekanism.common.multipart.TransmitterIcons;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.transmitters.Transmitter;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class PartMechanicalPipe
extends PartTransmitter<IFluidHandler, FluidNetwork>
implements IFluidHandler {
    public static TransmitterIcons pipeIcons = new TransmitterIcons(4, 8);
    public float currentScale;
    public FluidTank buffer = new FluidTank(1000);
    public FluidStack lastWrite;
    public Tier.PipeTier tier;

    public PartMechanicalPipe(Tier.PipeTier pipeTier) {
        this.tier = pipeTier;
        this.buffer.setCapacity(this.getCapacity());
    }

    @Override
    public void update() {
        if (!this.world().field_72995_K) {
            this.updateShare();
            IFluidHandler[] connectedAcceptors = PipeUtils.getConnectedAcceptors((TileEntity)this.tile());
            for (ForgeDirection side : this.getConnections(PartSidedPipe.ConnectionType.PULL)) {
                FluidStack received;
                IFluidHandler container;
                if (connectedAcceptors[side.ordinal()] == null || (container = connectedAcceptors[side.ordinal()]) == null || (received = container.drain(side.getOpposite(), this.getPullAmount(), false)) == null || received.amount == 0) continue;
                container.drain(side.getOpposite(), this.takeFluid(received, true), true);
            }
        }
        super.update();
    }

    @Override
    public void updateShare() {
        FluidStack last;
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork() && ((Transmitter)this.getTransmitter()).getTransmitterNetworkSize() > 0 && ((last = this.getSaveShare()) != null && (this.lastWrite == null || this.lastWrite.amount != last.amount || this.lastWrite.getFluid() != last.getFluid()) || last == null && this.lastWrite != null)) {
            this.lastWrite = last;
            MekanismUtils.saveChunk((TileEntity)this.tile());
        }
    }

    private FluidStack getSaveShare() {
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork() && ((FluidNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer != null) {
            int remain = ((FluidNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.amount % ((FluidNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).transmitters.size();
            int toSave = ((FluidNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.amount / ((FluidNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).transmitters.size();
            if (((IGridTransmitter)((FluidNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).transmitters.iterator().next()).equals(this.getTransmitter())) {
                toSave += remain;
            }
            return new FluidStack(((FluidNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.getFluid(), toSave);
        }
        return null;
    }

    @Override
    public void onChunkUnload() {
        if (!this.world().field_72995_K && ((Transmitter)this.getTransmitter()).hasTransmitterNetwork() && this.lastWrite != null && ((FluidNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer != null) {
            ((FluidNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.amount -= this.lastWrite.amount;
            if (((FluidNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.amount <= 0) {
                ((FluidNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer = null;
            }
        }
        super.onChunkUnload();
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        super.load(nbtTags);
        this.tier = Tier.PipeTier.values()[nbtTags.func_74762_e("tier")];
        this.buffer.setCapacity(this.getCapacity());
        if (nbtTags.func_74764_b("cacheFluid")) {
            this.buffer.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTags.func_74775_l("cacheFluid")));
        } else {
            this.buffer.setFluid(null);
        }
    }

    @Override
    public void save(NBTTagCompound nbtTags) {
        super.save(nbtTags);
        if (this.lastWrite != null && this.lastWrite.amount > 0) {
            nbtTags.func_74782_a("cacheFluid", (NBTBase)this.lastWrite.writeToNBT(new NBTTagCompound()));
        } else {
            nbtTags.func_82580_o("cacheFluid");
        }
        nbtTags.func_74768_a("tier", this.tier.ordinal());
    }

    public String getType() {
        return "mekanism:mechanical_pipe_" + this.tier.name().toLowerCase();
    }

    public static void registerIcons(IIconRegister register) {
        pipeIcons.registerCenterIcons(register, new String[]{"MechanicalPipeBasic", "MechanicalPipeAdvanced", "MechanicalPipeElite", "MechanicalPipeUltimate"});
        pipeIcons.registerSideIcons(register, new String[]{"MechanicalPipeVerticalBasic", "MechanicalPipeVerticalAdvanced", "MechanicalPipeVerticalElite", "MechanicalPipeVerticalUltimate", "MechanicalPipeHorizontalBasic", "MechanicalPipeHorizontalAdvanced", "MechanicalPipeHorizontalElite", "MechanicalPipeHorizontalUltimate"});
    }

    @Override
    public IIcon getCenterIcon(boolean opaque) {
        return pipeIcons.getCenterIcon(this.tier.ordinal());
    }

    @Override
    public IIcon getSideIcon(boolean opaque) {
        return pipeIcons.getSideIcon(this.tier.ordinal());
    }

    @Override
    public IIcon getSideIconRotated(boolean opaque) {
        return pipeIcons.getSideIcon(4 + this.tier.ordinal());
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.FLUID;
    }

    @Override
    public TransmitterType getTransmitterType() {
        return this.tier.type;
    }

    @Override
    public boolean isValidAcceptor(TileEntity acceptor, ForgeDirection side) {
        return PipeUtils.isValidAcceptorOnSide(acceptor, side);
    }

    @Override
    public FluidNetwork createNewNetwork() {
        return new FluidNetwork();
    }

    @Override
    public FluidNetwork createNetworkByMerging(Collection<FluidNetwork> networks) {
        return new FluidNetwork(networks);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float f, int pass) {
        if (pass == 0) {
            RenderPartTransmitter.getInstance().renderContents(this, pos);
        }
    }

    @Override
    public int getCapacity() {
        return this.tier.pipeCapacity;
    }

    public FluidStack getBuffer() {
        return this.buffer == null ? null : this.buffer.getFluid();
    }

    @Override
    public void takeShare() {
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork() && ((FluidNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer != null && this.lastWrite != null) {
            ((FluidNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.amount -= this.lastWrite.amount;
            this.buffer.setFluid(this.lastWrite);
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.getConnectionType(from) == PartSidedPipe.ConnectionType.NORMAL) {
            return this.takeFluid(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.getConnectionType(from) == PartSidedPipe.ConnectionType.NORMAL;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.getConnectionType(from) != PartSidedPipe.ConnectionType.NONE) {
            return new FluidTankInfo[]{this.buffer.getInfo()};
        }
        return new FluidTankInfo[0];
    }

    public int getPullAmount() {
        return this.tier.pipePullAmount;
    }

    public int takeFluid(FluidStack fluid, boolean doEmit) {
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork()) {
            return ((FluidNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).emit(fluid, doEmit);
        }
        return this.buffer.fill(fluid, doEmit);
    }

    @Override
    public boolean upgrade(int tierOrdinal) {
        if (this.tier.ordinal() < Tier.BaseTier.ULTIMATE.ordinal() && tierOrdinal == this.tier.ordinal() + 1) {
            this.tier = Tier.PipeTier.values()[this.tier.ordinal() + 1];
            this.markDirtyTransmitters();
            this.sendDesc = true;
            return true;
        }
        return false;
    }

    @Override
    public void readDesc(MCDataInput packet) {
        this.tier = Tier.PipeTier.values()[packet.readInt()];
        super.readDesc(packet);
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        packet.writeInt(this.tier.ordinal());
        super.writeDesc(packet);
    }
}

