/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import mekanism.api.Coord4D;
import mekanism.api.IAlloyInteraction;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.ITransmitterTile;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import mekanism.common.multipart.MultipartTransmitter;
import mekanism.common.multipart.PartSidedPipe;
import mekanism.common.transmitters.Transmitter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class PartTransmitter<A, N extends DynamicNetwork<A, N>>
extends PartSidedPipe
implements ITransmitterTile<A, N>,
IAlloyInteraction {
    public MultipartTransmitter<A, N> transmitterDelegate = new MultipartTransmitter(this);
    public boolean unloaded = true;

    @Override
    public MultipartTransmitter<A, N> getTransmitter() {
        return this.transmitterDelegate;
    }

    public void onWorldJoin() {
        super.onWorldJoin();
        if (!this.world().field_72995_K) {
            TransmitterNetworkRegistry.registerOrphanTransmitter(this.getTransmitter());
        } else {
            MinecraftForge.EVENT_BUS.post((Event)new DynamicNetwork.NetworkClientRequest((TileEntity)this.tile()));
        }
        this.unloaded = false;
    }

    public abstract N createNewNetwork();

    public abstract N createNetworkByMerging(Collection<N> var1);

    public void onChunkUnload() {
        super.onChunkUnload();
        this.unloaded = true;
        if (!this.world().field_72995_K) {
            ((MultipartTransmitter)this.getTransmitter()).takeShare();
            TransmitterNetworkRegistry.invalidateTransmitter(this.getTransmitter());
        } else {
            ((Transmitter)this.getTransmitter()).setTransmitterNetwork(null);
        }
    }

    public void preRemove() {
        if (!this.world().field_72995_K) {
            TransmitterNetworkRegistry.invalidateTransmitter(this.getTransmitter());
        } else {
            ((Transmitter)this.getTransmitter()).setTransmitterNetwork(null);
        }
        super.preRemove();
    }

    @Override
    public void markDirtyTransmitters() {
        super.markDirtyTransmitters();
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork()) {
            TransmitterNetworkRegistry.invalidateTransmitter(this.getTransmitter());
        }
    }

    @Override
    public void markDirtyAcceptor(ForgeDirection side) {
        super.markDirtyAcceptor(side);
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork()) {
            ((DynamicNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).acceptorChanged(this.getTransmitter(), side);
        }
    }

    public A getCachedAcceptor(ForgeDirection side) {
        PartSidedPipe.ConnectionType type = this.connectionTypes[side.ordinal()];
        if (type == PartSidedPipe.ConnectionType.PULL || type == PartSidedPipe.ConnectionType.NONE) {
            return null;
        }
        return (A)(PartTransmitter.connectionMapContainsSide(this.currentAcceptorConnections, side) ? this.cachedAcceptors[side.ordinal()] : null);
    }

    @Override
    public void onAlloyInteraction(EntityPlayer player, int tierOrdinal) {
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork()) {
            PartTransmitter t;
            Object iter;
            int upgraded = 0;
            Object[] array = ((LinkedHashSet)((DynamicNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).transmitters.clone()).toArray();
            Arrays.sort(array, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof IGridTransmitter && o2 instanceof IGridTransmitter) {
                        Coord4D thisCoord = Coord4D.get((TileEntity)PartTransmitter.this.tile());
                        Coord4D o1Coord = ((IGridTransmitter)o1).coord();
                        Coord4D o2Coord = ((IGridTransmitter)o2).coord();
                        return o1Coord.distanceTo(thisCoord) > o2Coord.distanceTo(thisCoord) ? 1 : (o1Coord.distanceTo(thisCoord) < o2Coord.distanceTo(thisCoord) ? -1 : 0);
                    }
                    return 0;
                }
            });
            Object[] arr$ = array;
            int len$ = arr$.length;
            for (int i$ = 0; !(i$ >= len$ || (iter = arr$[i$]) instanceof MultipartTransmitter && (t = ((MultipartTransmitter)iter).containingPart).upgrade(tierOrdinal) && ++upgraded == 8); ++i$) {
            }
            if (upgraded > 0 && !player.field_71075_bZ.field_75098_d) {
                --player.func_71045_bC().field_77994_a;
                if (player.func_71045_bC().field_77994_a == 0) {
                    player.func_70062_b(0, null);
                }
            }
        }
    }

    public boolean upgrade(int tierOrdinal) {
        return false;
    }

    public abstract int getCapacity();

    public abstract Object getBuffer();

    public abstract void takeShare();

    public abstract void updateShare();
}

