/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.ObfuscatedNames;
import mekanism.common.PacketHandler;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.item.ItemPortableTeleporter;
import mekanism.common.network.PacketPortalFX;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class PacketPortableTeleporter
implements IMessageHandler<PortableTeleporterMessage, IMessage> {
    public IMessage onMessage(PortableTeleporterMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        ItemStack itemstack = player.func_71045_bC();
        World world = player.field_70170_p;
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemPortableTeleporter) {
            ItemPortableTeleporter item = (ItemPortableTeleporter)itemstack.func_77973_b();
            switch (message.packetType) {
                case DATA_REQUEST: {
                    this.sendDataResponse(message.frequency, world, player, item, itemstack);
                    break;
                }
                case DATA_RESPONSE: {
                    Mekanism.proxy.handleTeleporterUpdate(message);
                    break;
                }
                case SET_FREQ: {
                    FrequencyManager manager1 = this.getManager(message.frequency.isPublic() ? null : player.func_70005_c_(), world);
                    Frequency toUse = null;
                    for (Frequency freq : manager1.getFrequencies()) {
                        if (!freq.name.equals(message.frequency.name)) continue;
                        toUse = freq;
                        break;
                    }
                    if (toUse == null) {
                        toUse = new Frequency(message.frequency.name, player.func_70005_c_()).setPublic(message.frequency.isPublic());
                        manager1.addFrequency(toUse);
                    }
                    item.setFrequency(itemstack, toUse.name);
                    item.setPrivateMode(itemstack, !toUse.publicFreq);
                    this.sendDataResponse(toUse, world, player, item, itemstack);
                    break;
                }
                case DEL_FREQ: {
                    FrequencyManager manager = this.getManager(message.frequency.isPublic() ? null : player.func_70005_c_(), world);
                    manager.remove(message.frequency.name, player.func_70005_c_());
                    item.setFrequency(itemstack, null);
                    item.setPrivateMode(itemstack, false);
                    break;
                }
                case TELEPORT: {
                    WorldServer teleWorld;
                    Coord4D coords;
                    TileEntityTeleporter teleporter;
                    FrequencyManager manager2 = this.getManager(message.frequency.isPublic() ? null : player.func_70005_c_(), world);
                    Frequency found = null;
                    for (Frequency freq : manager2.getFrequencies()) {
                        if (!message.frequency.name.equals(freq.name)) continue;
                        found = freq;
                        break;
                    }
                    if (found == null || (teleporter = (TileEntityTeleporter)(coords = found.getClosestCoords(new Coord4D((Entity)player))).getTileEntity((IBlockAccess)(teleWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(coords.dimensionId)))) == null) break;
                    try {
                        teleporter.didTeleport.add(player.getPersistentID());
                        teleporter.teleDelay = 5;
                        item.setEnergy(itemstack, item.getEnergy(itemstack) - ItemPortableTeleporter.calculateEnergyCost((Entity)player, coords));
                        if (player instanceof EntityPlayerMP) {
                            MekanismUtils.setPrivateValue(((EntityPlayerMP)player).field_71135_a, 0, NetHandlerPlayServer.class, ObfuscatedNames.NetHandlerPlayServer_floatingTickCount);
                        }
                        player.func_71053_j();
                        Mekanism.packetHandler.sendToAllAround(new PacketPortalFX.PortalFXMessage(new Coord4D((Entity)player)), coords.getTargetPoint(40.0));
                        TileEntityTeleporter.teleportPlayerTo((EntityPlayerMP)player, coords, teleporter);
                        TileEntityTeleporter.alignPlayer((EntityPlayerMP)player, coords);
                        world.func_72956_a((Entity)player, "mob.endermen.portal", 1.0f, 1.0f);
                        Mekanism.packetHandler.sendToReceivers(new PacketPortalFX.PortalFXMessage(coords), new Range4D(coords));
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    public void sendDataResponse(Frequency given, World world, EntityPlayer player, ItemPortableTeleporter item, ItemStack itemstack) {
        ArrayList<Frequency> publicFreqs = new ArrayList<Frequency>();
        for (Frequency f : this.getManager(null, world).getFrequencies()) {
            publicFreqs.add(f);
        }
        ArrayList<Frequency> privateFreqs = new ArrayList<Frequency>();
        for (Frequency f : this.getManager(player.func_70005_c_(), world).getFrequencies()) {
            privateFreqs.add(f);
        }
        int status = 3;
        if (given != null) {
            FrequencyManager manager = given.isPublic() ? this.getManager(null, world) : this.getManager(player.func_70005_c_(), world);
            boolean found = false;
            for (Frequency iterFreq : manager.getFrequencies()) {
                if (!given.equals(iterFreq)) continue;
                given = iterFreq;
                found = true;
                break;
            }
            if (!found) {
                given = null;
            }
        }
        if (given != null) {
            if (given.activeCoords.size() == 0) {
                status = 3;
            } else {
                Coord4D coords = given.getClosestCoords(new Coord4D((Entity)player));
                double energyNeeded = ItemPortableTeleporter.calculateEnergyCost((Entity)player, coords);
                status = energyNeeded > item.getEnergy(itemstack) ? 4 : 1;
            }
        }
        Mekanism.packetHandler.sendTo(new PortableTeleporterMessage(given, (byte)status, publicFreqs, privateFreqs), (EntityPlayerMP)player);
    }

    public FrequencyManager getManager(String owner, World world) {
        if (owner == null) {
            return Mekanism.publicTeleporters;
        }
        if (!Mekanism.privateTeleporters.containsKey(owner)) {
            FrequencyManager manager = new FrequencyManager(Frequency.class, owner);
            Mekanism.privateTeleporters.put(owner, manager);
            manager.createOrLoad(world);
        }
        return Mekanism.privateTeleporters.get(owner);
    }

    public static enum PortableTeleporterPacketType {
        DATA_REQUEST,
        DATA_RESPONSE,
        SET_FREQ,
        DEL_FREQ,
        TELEPORT;

    }

    public static class PortableTeleporterMessage
    implements IMessage {
        public PortableTeleporterPacketType packetType;
        public Frequency frequency;
        public byte status;
        public List<Frequency> publicCache = new ArrayList<Frequency>();
        public List<Frequency> privateCache = new ArrayList<Frequency>();

        public PortableTeleporterMessage() {
        }

        public PortableTeleporterMessage(PortableTeleporterPacketType type, Frequency freq) {
            this.packetType = type;
            if (type == PortableTeleporterPacketType.DATA_REQUEST) {
                this.frequency = freq;
            } else if (type == PortableTeleporterPacketType.SET_FREQ) {
                this.frequency = freq;
            } else if (type == PortableTeleporterPacketType.DEL_FREQ) {
                this.frequency = freq;
            } else if (type == PortableTeleporterPacketType.TELEPORT) {
                this.frequency = freq;
            }
        }

        public PortableTeleporterMessage(Frequency freq, byte b, List<Frequency> publicFreqs, List<Frequency> privateFreqs) {
            this.packetType = PortableTeleporterPacketType.DATA_RESPONSE;
            this.frequency = freq;
            this.status = b;
            this.publicCache = publicFreqs;
            this.privateCache = privateFreqs;
        }

        public void toBytes(ByteBuf buffer) {
            buffer.writeInt(this.packetType.ordinal());
            if (this.packetType == PortableTeleporterPacketType.DATA_REQUEST) {
                if (this.frequency != null) {
                    buffer.writeBoolean(true);
                    PacketHandler.writeString(buffer, this.frequency.name);
                    buffer.writeBoolean(this.frequency.publicFreq);
                } else {
                    buffer.writeBoolean(false);
                }
            } else if (this.packetType == PortableTeleporterPacketType.DATA_RESPONSE) {
                if (this.frequency != null) {
                    buffer.writeBoolean(true);
                    PacketHandler.writeString(buffer, this.frequency.name);
                    buffer.writeBoolean(this.frequency.publicFreq);
                } else {
                    buffer.writeBoolean(false);
                }
                buffer.writeByte((int)this.status);
                ArrayList<Integer> data = new ArrayList<Integer>();
                data.add(this.publicCache.size());
                for (Frequency freq : this.publicCache) {
                    freq.write(data);
                }
                data.add(this.privateCache.size());
                for (Frequency freq : this.privateCache) {
                    freq.write(data);
                }
                PacketHandler.encode(data.toArray(), buffer);
            } else if (this.packetType == PortableTeleporterPacketType.SET_FREQ) {
                PacketHandler.writeString(buffer, this.frequency.name);
                buffer.writeBoolean(this.frequency.publicFreq);
            } else if (this.packetType == PortableTeleporterPacketType.DEL_FREQ) {
                PacketHandler.writeString(buffer, this.frequency.name);
                buffer.writeBoolean(this.frequency.publicFreq);
            } else if (this.packetType == PortableTeleporterPacketType.TELEPORT) {
                PacketHandler.writeString(buffer, this.frequency.name);
                buffer.writeBoolean(this.frequency.publicFreq);
            }
        }

        public void fromBytes(ByteBuf buffer) {
            this.packetType = PortableTeleporterPacketType.values()[buffer.readInt()];
            if (this.packetType == PortableTeleporterPacketType.DATA_REQUEST) {
                if (buffer.readBoolean()) {
                    this.frequency = new Frequency(PacketHandler.readString(buffer), null).setPublic(buffer.readBoolean());
                }
            } else if (this.packetType == PortableTeleporterPacketType.DATA_RESPONSE) {
                int i;
                if (buffer.readBoolean()) {
                    this.frequency = new Frequency(PacketHandler.readString(buffer), null).setPublic(buffer.readBoolean());
                }
                this.status = buffer.readByte();
                int amount = buffer.readInt();
                for (i = 0; i < amount; ++i) {
                    this.publicCache.add(new Frequency(buffer));
                }
                amount = buffer.readInt();
                for (i = 0; i < amount; ++i) {
                    this.privateCache.add(new Frequency(buffer));
                }
            } else if (this.packetType == PortableTeleporterPacketType.SET_FREQ) {
                this.frequency = new Frequency(PacketHandler.readString(buffer), null).setPublic(buffer.readBoolean());
            } else if (this.packetType == PortableTeleporterPacketType.DEL_FREQ) {
                this.frequency = new Frequency(PacketHandler.readString(buffer), null).setPublic(buffer.readBoolean());
            } else if (this.packetType == PortableTeleporterPacketType.TELEPORT) {
                this.frequency = new Frequency(PacketHandler.readString(buffer), null).setPublic(buffer.readBoolean());
            }
        }
    }
}

