/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.BlockMachine;
import mekanism.common.integration.IComputerIntegration;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.FluidInput;
import mekanism.common.recipe.machines.SeparatorRecipe;
import mekanism.common.recipe.outputs.ChemicalPairOutput;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityElectrolyticSeparator
extends TileEntityElectricBlock
implements IFluidHandler,
IComputerIntegration,
ITubeConnection,
ISustainedData,
IGasHandler,
IUpgradeTile,
Upgrade.IUpgradeInfoHandler,
ITankManager,
IRedstoneControl,
IActiveState,
ISecurityTile {
    public FluidTank fluidTank = new FluidTank(24000);
    public int MAX_GAS = 2400;
    public GasTank leftTank = new GasTank(this.MAX_GAS);
    public GasTank rightTank = new GasTank(this.MAX_GAS);
    public int output = 256;
    public TileEntityGasTank.GasMode dumpLeft = TileEntityGasTank.GasMode.IDLE;
    public TileEntityGasTank.GasMode dumpRight = TileEntityGasTank.GasMode.IDLE;
    public double BASE_ENERGY_USAGE;
    public double energyPerTick;
    public int updateDelay;
    public boolean isActive = false;
    public boolean clientActive = false;
    public double prevEnergy;
    public SeparatorRecipe cachedRecipe;
    public double clientEnergyUsed;
    public TileComponentUpgrade upgradeComponent = new TileComponentUpgrade(this, 4);
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    private static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getWater", "getWaterNeeded", "getHydrogen", "getHydrogenNeeded", "getOxygen", "getOxygenNeeded"};

    public TileEntityElectrolyticSeparator() {
        super("ElectrolyticSeparator", BlockMachine.MachineType.ELECTROLYTIC_SEPARATOR.baseEnergy);
        this.inventory = new ItemStack[5];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K && this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            SeparatorRecipe recipe;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
                }
            }
            ChargeUtils.discharge(3, this);
            if (this.inventory[0] != null && RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.containsRecipe(this.inventory[0])) {
                if (this.inventory[0].func_77973_b() instanceof IFluidContainerItem) {
                    this.fluidTank.fill(FluidContainerUtils.extractFluid(this.fluidTank, this.inventory[0]), true);
                } else {
                    FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inventory[0]);
                    if (fluid != null && (this.fluidTank.getFluid() == null || fluid.isFluidEqual(this.fluidTank.getFluid()) && this.fluidTank.getFluid().amount + fluid.amount <= this.fluidTank.getCapacity())) {
                        this.fluidTank.fill(fluid, true);
                        if (this.inventory[0].func_77973_b().hasContainerItem(this.inventory[0])) {
                            this.inventory[0] = this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]);
                        } else {
                            --this.inventory[0].field_77994_a;
                        }
                        if (this.inventory[0].field_77994_a == 0) {
                            this.inventory[0] = null;
                        }
                    }
                }
            }
            if (this.inventory[1] != null && this.leftTank.getStored() > 0) {
                this.leftTank.draw(GasTransmission.addGas(this.inventory[1], this.leftTank.getGas()), true);
                MekanismUtils.saveChunk(this);
            }
            if (this.inventory[2] != null && this.rightTank.getStored() > 0) {
                this.rightTank.draw(GasTransmission.addGas(this.inventory[2], this.rightTank.getGas()), true);
                MekanismUtils.saveChunk(this);
            }
            if (this.canOperate(recipe = this.getRecipe()) && this.getEnergy() >= this.energyPerTick && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                boolean update = this.BASE_ENERGY_USAGE != recipe.energyUsage;
                this.BASE_ENERGY_USAGE = recipe.energyUsage;
                if (update) {
                    this.recalculateUpgradables(Upgrade.ENERGY);
                }
                int operations = this.operate(recipe);
                double prev = this.getEnergy();
                this.setEnergy(this.getEnergy() - this.energyPerTick * (double)operations);
                this.clientEnergyUsed = prev - this.getEnergy();
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            int dumpAmount = 8 * (int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED));
            if (this.leftTank.getGas() != null) {
                if (this.dumpLeft != TileEntityGasTank.GasMode.DUMPING) {
                    GasStack toSend = new GasStack(this.leftTank.getGas().getGas(), Math.min(this.leftTank.getStored(), this.output));
                    TileEntity tileEntity = Coord4D.get(this).getFromSide(MekanismUtils.getLeft(this.facing)).getTileEntity((IBlockAccess)this.field_145850_b);
                    if (tileEntity instanceof IGasHandler && ((IGasHandler)tileEntity).canReceiveGas(MekanismUtils.getLeft(this.facing).getOpposite(), this.leftTank.getGas().getGas())) {
                        this.leftTank.draw(((IGasHandler)tileEntity).receiveGas(MekanismUtils.getLeft(this.facing).getOpposite(), toSend, true), true);
                    }
                } else if (this.dumpLeft == TileEntityGasTank.GasMode.DUMPING) {
                    this.leftTank.draw(dumpAmount, true);
                }
                if (this.dumpLeft == TileEntityGasTank.GasMode.DUMPING_EXCESS && this.leftTank.getNeeded() < this.output) {
                    this.leftTank.draw(this.output - this.leftTank.getNeeded(), true);
                }
            }
            if (this.rightTank.getGas() != null) {
                if (this.dumpRight != TileEntityGasTank.GasMode.DUMPING) {
                    GasStack toSend = new GasStack(this.rightTank.getGas().getGas(), Math.min(this.rightTank.getStored(), this.output));
                    TileEntity tileEntity = Coord4D.get(this).getFromSide(MekanismUtils.getRight(this.facing)).getTileEntity((IBlockAccess)this.field_145850_b);
                    if (tileEntity instanceof IGasHandler && ((IGasHandler)tileEntity).canReceiveGas(MekanismUtils.getRight(this.facing).getOpposite(), this.rightTank.getGas().getGas())) {
                        this.rightTank.draw(((IGasHandler)tileEntity).receiveGas(MekanismUtils.getRight(this.facing).getOpposite(), toSend, true), true);
                    }
                } else if (this.dumpRight == TileEntityGasTank.GasMode.DUMPING) {
                    this.rightTank.draw(dumpAmount, true);
                }
                if (this.dumpRight == TileEntityGasTank.GasMode.DUMPING_EXCESS && this.rightTank.getNeeded() < this.output) {
                    this.rightTank.draw(this.output - this.rightTank.getNeeded(), true);
                }
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public int getUpgradedUsage(SeparatorRecipe recipe) {
        int possibleProcess = 0;
        if (this.leftTank.getGasType() == ((ChemicalPairOutput)recipe.recipeOutput).leftGas.getGas()) {
            possibleProcess = this.leftTank.getNeeded() / ((ChemicalPairOutput)recipe.recipeOutput).leftGas.amount;
            possibleProcess = Math.min(this.rightTank.getNeeded() / ((ChemicalPairOutput)recipe.recipeOutput).rightGas.amount, possibleProcess);
        } else {
            possibleProcess = this.leftTank.getNeeded() / ((ChemicalPairOutput)recipe.recipeOutput).rightGas.amount;
            possibleProcess = Math.min(this.rightTank.getNeeded() / ((ChemicalPairOutput)recipe.recipeOutput).leftGas.amount, possibleProcess);
        }
        possibleProcess = Math.min((int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED)), possibleProcess);
        possibleProcess = Math.min((int)(this.getEnergy() / this.energyPerTick), possibleProcess);
        return Math.min(this.fluidTank.getFluidAmount() / ((FluidInput)recipe.recipeInput).ingredient.amount, possibleProcess);
    }

    public SeparatorRecipe getRecipe() {
        FluidInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((FluidInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getElectrolyticSeparatorRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    public FluidInput getInput() {
        return new FluidInput(this.fluidTank.getFluid());
    }

    public boolean canOperate(SeparatorRecipe recipe) {
        return recipe != null && recipe.canOperate(this.fluidTank, this.leftTank, this.rightTank);
    }

    public int operate(SeparatorRecipe recipe) {
        int operations = this.getUpgradedUsage(recipe);
        recipe.operate(this.fluidTank, this.leftTank, this.rightTank, operations);
        return operations;
    }

    public boolean canFill(ChemicalPairOutput gases) {
        return this.leftTank.canReceive(gases.leftGas.getGas()) && this.leftTank.getNeeded() >= gases.leftGas.amount && this.rightTank.canReceive(gases.rightGas.getGas()) && this.rightTank.getNeeded() >= gases.rightGas.amount;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 3) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        if (slotID == 0) {
            return FluidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
        }
        if (slotID == 1 || slotID == 2) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) != null && ((IGasItem)itemstack.func_77973_b()).getGas((ItemStack)itemstack).amount == ((IGasItem)itemstack.func_77973_b()).getMaxGas(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.containsRecipe(itemstack);
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IGasItem && (((IGasItem)itemstack.func_77973_b()).getGas(itemstack) == null || ((IGasItem)itemstack.func_77973_b()).getGas(itemstack).getGas() == GasRegistry.getGas("hydrogen"));
        }
        if (slotID == 2) {
            return itemstack.func_77973_b() instanceof IGasItem && (((IGasItem)itemstack.func_77973_b()).getGas(itemstack) == null || ((IGasItem)itemstack.func_77973_b()).getGas(itemstack).getGas() == GasRegistry.getGas("oxygen"));
        }
        if (slotID == 3) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return true;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (ForgeDirection.getOrientation((int)side) == MekanismUtils.getRight(this.facing)) {
            return new int[]{3};
        }
        if (side == this.facing || ForgeDirection.getOrientation((int)side) == ForgeDirection.getOrientation((int)this.facing).getOpposite()) {
            return new int[]{1, 2};
        }
        return InventoryUtils.EMPTY;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            byte type = dataStream.readByte();
            if (type == 0) {
                this.dumpLeft = TileEntityGasTank.GasMode.values()[this.dumpLeft.ordinal() == TileEntityGasTank.GasMode.values().length - 1 ? 0 : this.dumpLeft.ordinal() + 1];
            } else if (type == 1) {
                this.dumpRight = TileEntityGasTank.GasMode.values()[this.dumpRight.ordinal() == TileEntityGasTank.GasMode.values().length - 1 ? 0 : this.dumpRight.ordinal() + 1];
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            if (dataStream.readBoolean()) {
                this.fluidTank.setFluid(new FluidStack(FluidRegistry.getFluid((int)dataStream.readInt()), dataStream.readInt()));
            } else {
                this.fluidTank.setFluid(null);
            }
            if (dataStream.readBoolean()) {
                this.leftTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.leftTank.setGas(null);
            }
            if (dataStream.readBoolean()) {
                this.rightTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.rightTank.setGas(null);
            }
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            this.dumpLeft = TileEntityGasTank.GasMode.values()[dataStream.readInt()];
            this.dumpRight = TileEntityGasTank.GasMode.values()[dataStream.readInt()];
            this.clientActive = dataStream.readBoolean();
            this.clientEnergyUsed = dataStream.readDouble();
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.updateDelay = MekanismConfig.general.UPDATE_DELAY;
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.fluidTank.getFluid() != null) {
            data.add(true);
            data.add(this.fluidTank.getFluid().getFluid().getID());
            data.add(this.fluidTank.getFluidAmount());
        } else {
            data.add(false);
        }
        if (this.leftTank.getGas() != null) {
            data.add(true);
            data.add(this.leftTank.getGas().getGas().getID());
            data.add(this.leftTank.getStored());
        } else {
            data.add(false);
        }
        if (this.rightTank.getGas() != null) {
            data.add(true);
            data.add(this.rightTank.getGas().getGas().getID());
            data.add(this.rightTank.getStored());
        } else {
            data.add(false);
        }
        data.add(this.controlType.ordinal());
        data.add(this.dumpLeft.ordinal());
        data.add(this.dumpRight.ordinal());
        data.add(this.isActive);
        data.add(this.clientEnergyUsed);
        return data;
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (nbtTags.func_74764_b("fluidTank")) {
            this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        }
        this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.leftTank.read(nbtTags.func_74775_l("leftTank"));
        this.rightTank.read(nbtTags.func_74775_l("rightTank"));
        this.dumpLeft = TileEntityGasTank.GasMode.values()[nbtTags.func_74762_e("dumpLeft")];
        this.dumpRight = TileEntityGasTank.GasMode.values()[nbtTags.func_74762_e("dumpRight")];
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        if (this.fluidTank.getFluid() != null) {
            nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74782_a("leftTank", (NBTBase)this.leftTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("rightTank", (NBTBase)this.rightTank.write(new NBTTagCompound()));
        nbtTags.func_74768_a("dumpLeft", this.dumpLeft.ordinal());
        nbtTags.func_74768_a("dumpRight", this.dumpRight.ordinal());
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.BASE_MAX_ENERGY};
            }
            case 3: {
                return new Object[]{this.BASE_MAX_ENERGY - this.electricityStored};
            }
            case 4: {
                return new Object[]{this.fluidTank.getFluid() != null ? this.fluidTank.getFluid().amount : 0};
            }
            case 5: {
                return new Object[]{this.fluidTank.getFluid() != null ? this.fluidTank.getCapacity() - this.fluidTank.getFluid().amount : 0};
            }
            case 6: {
                return new Object[]{this.leftTank.getStored()};
            }
            case 7: {
                return new Object[]{this.leftTank.getNeeded()};
            }
            case 8: {
                return new Object[]{this.rightTank.getStored()};
            }
            case 9: {
                return new Object[]{this.rightTank.getNeeded()};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return side == MekanismUtils.getLeft(this.facing) || side == MekanismUtils.getRight(this.facing);
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.fluidTank.getFluid() != null) {
            itemStack.field_77990_d.func_74782_a("fluidTank", (NBTBase)this.fluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        if (this.leftTank.getGas() != null) {
            itemStack.field_77990_d.func_74782_a("leftTank", (NBTBase)this.leftTank.getGas().write(new NBTTagCompound()));
        }
        if (this.rightTank.getGas() != null) {
            itemStack.field_77990_d.func_74782_a("rightTank", (NBTBase)this.rightTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("fluidTank")));
        this.leftTank.setGas(GasStack.readFromNBT(itemStack.field_77990_d.func_74775_l("leftTank")));
        this.rightTank.setGas(GasStack.readFromNBT(itemStack.field_77990_d.func_74775_l("rightTank")));
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.containsRecipe(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.containsRecipe(resource.getFluid())) {
            return this.fluidTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        return 0;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        if (side == MekanismUtils.getLeft(this.facing)) {
            return this.leftTank.draw(amount, doTransfer);
        }
        if (side == MekanismUtils.getRight(this.facing)) {
            return this.rightTank.draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return this.drawGas(side, amount, true);
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return false;
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        if (side == MekanismUtils.getLeft(this.facing)) {
            return this.leftTank.getGas() != null && this.leftTank.getGas().getGas() == type;
        }
        if (side == MekanismUtils.getRight(this.facing)) {
            return this.rightTank.getGas() != null && this.rightTank.getGas().getGas() == type;
        }
        return false;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case ENERGY: {
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
                this.energyPerTick = this.BASE_ENERGY_USAGE;
            }
        }
    }

    @Override
    public List<String> getInfo(Upgrade upgrade) {
        return upgrade == Upgrade.SPEED ? upgrade.getExpScaledInfo(this) : upgrade.getMultScaledInfo(this);
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.fluidTank, this.leftTank, this.rightTank};
    }
}

