/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.base.IActiveState;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFuelwoodHeater
extends TileEntityContainerBlock
implements IHeatTransfer,
ISecurityTile,
IActiveState {
    public double temperature;
    public double heatToAbsorb = 0.0;
    public int burnTime;
    public int maxBurnTime;
    public boolean isActive;
    public boolean clientActive;
    public int updateDelay;
    public double lastEnvironmentLoss;
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);

    public TileEntityFuelwoodHeater() {
        super("FuelwoodHeater");
        this.inventory = new ItemStack[1];
    }

    @Override
    public void onUpdate() {
        if (this.field_145850_b.field_72995_K && this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
                }
            }
            boolean burning = false;
            if (this.burnTime > 0) {
                --this.burnTime;
                burning = true;
            } else if (this.inventory[0] != null) {
                this.maxBurnTime = this.burnTime = TileEntityFurnace.func_145952_a((ItemStack)this.inventory[0]) / 2;
                if (this.burnTime > 0) {
                    --this.inventory[0].field_77994_a;
                    if (this.inventory[0].field_77994_a == 0) {
                        this.inventory[0] = this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]);
                    }
                    burning = true;
                }
            }
            if (burning) {
                this.heatToAbsorb += MekanismConfig.general.heatPerFuelTick;
            }
            double[] loss = this.simulateHeat();
            this.applyTemperatureChange();
            this.lastEnvironmentLoss = loss[1];
            this.setActive(burning);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.temperature = nbtTags.func_74769_h("temperature");
        this.clientActive = this.isActive = nbtTags.func_74767_n("isActive");
        this.burnTime = nbtTags.func_74762_e("burnTime");
        this.maxBurnTime = nbtTags.func_74762_e("maxBurnTime");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74780_a("temperature", this.temperature);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("burnTime", this.burnTime);
        nbtTags.func_74768_a("maxBurnTime", this.maxBurnTime);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            this.temperature = dataStream.readDouble();
            this.clientActive = dataStream.readBoolean();
            this.burnTime = dataStream.readInt();
            this.maxBurnTime = dataStream.readInt();
            this.lastEnvironmentLoss = dataStream.readDouble();
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.updateDelay = MekanismConfig.general.UPDATE_DELAY;
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.temperature);
        data.add(this.isActive);
        data.add(this.burnTime);
        data.add(this.maxBurnTime);
        data.add(this.lastEnvironmentLoss);
        return data;
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public double getTemp() {
        return this.temperature;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return 5.0;
    }

    @Override
    public double getInsulationCoefficient(ForgeDirection side) {
        return 1000.0;
    }

    @Override
    public void transferHeatTo(double heat) {
        this.heatToAbsorb += heat;
    }

    @Override
    public double[] simulateHeat() {
        return HeatUtils.simulate(this);
    }

    @Override
    public double applyTemperatureChange() {
        this.temperature += this.heatToAbsorb;
        this.heatToAbsorb = 0.0;
        return this.temperature;
    }

    @Override
    public boolean canConnectHeat(ForgeDirection side) {
        return true;
    }

    @Override
    public IHeatTransfer getAdjacent(ForgeDirection side) {
        TileEntity adj = Coord4D.get(this).getFromSide(side).getTileEntity((IBlockAccess)this.field_145850_b);
        if (adj instanceof IHeatTransfer) {
            return (IHeatTransfer)adj;
        }
        return null;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }
}

