/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.network.PacketSecurityUpdate;
import mekanism.common.security.IOwnerItem;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.security.SecurityData;
import mekanism.common.security.SecurityFrequency;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySecurityDesk
extends TileEntityContainerBlock
implements IBoundingBlock {
    public String owner;
    public SecurityFrequency frequency;

    public TileEntitySecurityDesk() {
        super("SecurityDesk");
        this.inventory = new ItemStack[2];
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            FrequencyManager manager;
            if (this.owner != null && this.frequency != null) {
                IOwnerItem item;
                if (this.inventory[0] != null && this.inventory[0].func_77973_b() instanceof IOwnerItem && (item = (IOwnerItem)this.inventory[0].func_77973_b()).hasOwner(this.inventory[0]) && item.getOwner(this.inventory[0]) != null && item.getOwner(this.inventory[0]).equals(this.owner)) {
                    item.setOwner(this.inventory[0], null);
                    if (item instanceof ISecurityItem && ((ISecurityItem)item).hasSecurity(this.inventory[0])) {
                        ((ISecurityItem)item).setSecurity(this.inventory[0], ISecurityTile.SecurityMode.PUBLIC);
                    }
                }
                if (this.inventory[1] != null && this.inventory[1].func_77973_b() instanceof IOwnerItem && (item = (IOwnerItem)this.inventory[1].func_77973_b()).hasOwner(this.inventory[1])) {
                    if (item.getOwner(this.inventory[1]) == null) {
                        item.setOwner(this.inventory[1], this.owner);
                    }
                    if (item.getOwner(this.inventory[1]).equals(this.owner) && item instanceof ISecurityItem && ((ISecurityItem)item).hasSecurity(this.inventory[1])) {
                        ((ISecurityItem)item).setSecurity(this.inventory[1], this.frequency.securityMode);
                    }
                }
            }
            if (this.frequency == null && this.owner != null) {
                this.setFrequency(this.owner);
            }
            if ((manager = this.getManager(this.frequency)) != null) {
                if (this.frequency != null && !this.frequency.valid) {
                    this.frequency = (SecurityFrequency)manager.validateFrequency(this.owner, Coord4D.get(this), this.frequency);
                }
                if (this.frequency != null) {
                    this.frequency = (SecurityFrequency)manager.update(this.owner, Coord4D.get(this), this.frequency);
                }
            } else {
                this.frequency = null;
            }
        }
    }

    public FrequencyManager getManager(Frequency freq) {
        if (this.owner == null || freq == null) {
            return null;
        }
        return Mekanism.securityFrequencies;
    }

    public void setFrequency(String owner) {
        FrequencyManager manager = Mekanism.securityFrequencies;
        manager.deactivate(Coord4D.get(this));
        for (Frequency freq : manager.getFrequencies()) {
            if (!freq.owner.equals(owner)) continue;
            this.frequency = (SecurityFrequency)freq;
            this.frequency.activeCoords.add(Coord4D.get(this));
            return;
        }
        Frequency freq = new SecurityFrequency(owner).setPublic(true);
        freq.activeCoords.add(Coord4D.get(this));
        manager.addFrequency(freq);
        this.frequency = (SecurityFrequency)freq;
        MekanismUtils.saveChunk(this);
        this.func_70296_d();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            int type = dataStream.readInt();
            if (type == 0) {
                if (this.frequency != null) {
                    this.frequency.trusted.add(PacketHandler.readString(dataStream));
                }
            } else if (type == 1) {
                if (this.frequency != null) {
                    this.frequency.trusted.remove(PacketHandler.readString(dataStream));
                }
            } else if (type == 2) {
                if (this.frequency != null) {
                    this.frequency.override = !this.frequency.override;
                    Mekanism.packetHandler.sendToAll(new PacketSecurityUpdate.SecurityUpdateMessage(PacketSecurityUpdate.SecurityPacket.UPDATE, this.owner, new SecurityData(this.frequency)));
                }
            } else if (type == 3 && this.frequency != null) {
                this.frequency.securityMode = ISecurityTile.SecurityMode.values()[dataStream.readInt()];
                Mekanism.packetHandler.sendToAll(new PacketSecurityUpdate.SecurityUpdateMessage(PacketSecurityUpdate.SecurityPacket.UPDATE, this.owner, new SecurityData(this.frequency)));
            }
            MekanismUtils.saveChunk(this);
            return;
        }
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            this.owner = dataStream.readBoolean() ? PacketHandler.readString(dataStream) : null;
            this.frequency = dataStream.readBoolean() ? new SecurityFrequency(dataStream) : null;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (nbtTags.func_74764_b("owner")) {
            this.owner = nbtTags.func_74779_i("owner");
        }
        if (nbtTags.func_74764_b("frequency")) {
            this.frequency = new SecurityFrequency(nbtTags.func_74775_l("frequency"));
            this.frequency.valid = false;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        if (this.owner != null) {
            nbtTags.func_74778_a("owner", this.owner);
        }
        if (this.frequency != null) {
            NBTTagCompound frequencyTag = new NBTTagCompound();
            this.frequency.write(frequencyTag);
            nbtTags.func_74782_a("frequency", (NBTBase)frequencyTag);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.owner != null) {
            data.add(true);
            data.add(this.owner);
        } else {
            data.add(false);
        }
        if (this.frequency != null) {
            data.add(true);
            this.frequency.write(data);
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_145843_s() {
        FrequencyManager manager;
        if (!this.field_145850_b.field_72995_K && this.frequency != null && (manager = this.getManager(this.frequency)) != null) {
            manager.deactivate(Coord4D.get(this));
        }
    }

    @Override
    public void onPlace() {
        MekanismUtils.makeBoundingBlock(this.field_145850_b, Coord4D.get(this).getFromSide(ForgeDirection.UP), Coord4D.get(this));
    }

    @Override
    public void onBreak() {
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public Frequency getFrequency(FrequencyManager manager) {
        if (manager == Mekanism.securityFrequencies) {
            return this.frequency;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

