/*
 * Decompiled with CFR 0.152.
 */
package com.mffs.api.utils;

import com.mffs.api.IBlockFrequency;
import com.mffs.api.security.IBiometricIdentifier;
import com.mffs.api.security.IInterdictionMatrix;
import com.mffs.api.security.Permission;
import com.mffs.api.vector.Vector3D;
import com.mffs.common.items.modules.upgrades.ItemModuleBlockAccess;
import com.mffs.common.items.modules.upgrades.ItemModuleBlockAlter;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class MatrixHelper {
    public static IInterdictionMatrix findMatrix(World world, Vector3D vec, Set<IBlockFrequency> seq) {
        for (IBlockFrequency freq : seq) {
            IInterdictionMatrix matrix;
            TileEntity entity = (TileEntity)freq;
            if (!(seq instanceof IInterdictionMatrix) || world != entity.func_145831_w() || !(matrix = (IInterdictionMatrix)freq).isActive() || !(vec.distance(entity.field_145851_c, entity.field_145848_d, entity.field_145849_e) < (double)matrix.getActionRange())) continue;
            return matrix;
        }
        return null;
    }

    public static boolean checkPermission(IInterdictionMatrix matrix, String name, Permission perm) {
        IBiometricIdentifier bio = matrix.getBiometricIdentifier();
        if (bio != null && matrix.isActive()) {
            return bio.isAccessGranted(name, perm);
        }
        return true;
    }

    public static boolean checkActionPermission(IInterdictionMatrix matrix, PlayerInteractEvent.Action action, EntityPlayer player) {
        boolean perm = true;
        if (matrix.getModuleCount(ItemModuleBlockAccess.class, new int[0]) > 0 && action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            perm = MatrixHelper.checkPermission(matrix, player.func_146103_bH().getName(), Permission.BLOCK_ACCESS);
        }
        if (perm && matrix.getModuleCount(ItemModuleBlockAlter.class, new int[0]) > 0 && (action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK || player.func_71045_bC() != null)) {
            perm = MatrixHelper.checkPermission(matrix, player.func_146103_bH().getName(), Permission.BLOCK_PLACE_ACCESS);
        }
        return perm;
    }
}

