/*
 * Decompiled with CFR 0.152.
 */
package com.mffs.api.vector;

import com.mffs.api.vector.Vector3D;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Vector2d;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class Matrix2d {
    public Vector3D min;
    public Vector3D max;

    public Matrix2d() {
        this(new Vector3D(), new Vector3D());
    }

    public Matrix2d(double minX, double minY, double size) {
        this.min = new Vector3D(minX, minY, 0.0);
        this.max = new Vector3D(minX + size, minY + size, 0.0);
    }

    public Matrix2d(Vector2d min, double radius) {
        this.min = new Vector3D(min.x, min.y, 0.0);
        this.max = new Vector3D(min.x + radius, min.y + radius, 0.0);
    }

    public Matrix2d(Vector3D min, Vector3D max) {
        this.min = min;
        this.max = max;
    }

    public Matrix2d(Vector2d min, Vector2d max) {
        this.min = new Vector3D(min.x, min.y, 0.0);
        this.max = new Vector3D(max.x, max.y, 0.0);
    }

    public Matrix2d(AxisAlignedBB aabb) {
        this.min = new Vector3D(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        this.max = new Vector3D(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public AxisAlignedBB toAABB() {
        return AxisAlignedBB.func_72330_a((double)this.min.x, (double)this.min.y, (double)this.min.z, (double)this.max.x, (double)this.max.y, (double)this.max.z);
    }

    public boolean isIn(Vector3D point) {
        return point.x > this.min.x && point.x < this.max.x && point.y > this.min.y && point.y < this.max.y && point.z > this.min.z && point.z < this.max.z;
    }

    public boolean isIn(Matrix2d region) {
        return region.max.z > this.min.z && region.min.z < this.max.z;
    }

    public boolean isIn(double xP, double zP) {
        return xP >= this.min.x && zP <= this.max.y && xP <= this.max.x && zP >= this.min.y;
    }

    public void expand(Vector3D difference) {
        this.min.subtract(difference);
        this.max.add(difference);
    }

    public List<Vector3D> getVectors() {
        ArrayList<Vector3D> vectors = new ArrayList<Vector3D>();
        for (int x = (int)Math.floor(this.min.x); x < (int)Math.floor(this.max.x); ++x) {
            int y = (int)Math.floor(this.min.y);
            while (x < (int)Math.floor(this.max.y)) {
                int z = (int)Math.floor(this.min.z);
                while (x < (int)Math.floor(this.max.z)) {
                    vectors.add(new Vector3D(x, y, z));
                    ++z;
                }
                ++y;
            }
        }
        return vectors;
    }

    public List<Vector3D> getVectors(Vector3D center, int radius) {
        ArrayList<Vector3D> vectors = new ArrayList<Vector3D>();
        for (int x = (int)Math.floor(this.min.x); x < (int)Math.floor(this.max.x); ++x) {
            int y = (int)Math.floor(this.min.y);
            while (x < (int)Math.floor(this.max.y)) {
                int z = (int)Math.floor(this.min.z);
                while (x < (int)Math.floor(this.max.z)) {
                    Vector3D vec = new Vector3D(x, y, z);
                    if (vec.distance(x, y, z) <= (double)radius) {
                        vectors.add(vec);
                    }
                    ++z;
                }
                ++y;
            }
        }
        return vectors;
    }

    public List<Entity> getEntities(World world, Class<? extends Entity> entityClass) {
        return world.func_72872_a(entityClass, this.toAABB());
    }

    public List<Entity> getEntitiesExlude(World world, Entity entity) {
        return world.func_72839_b(entity, this.toAABB());
    }

    public List<Entity> getEntities(World world) {
        return this.getEntities(world, Entity.class);
    }
}

