/*
 * Decompiled with CFR 0.152.
 */
package com.mffs.api.vector;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Vector3D
implements Cloneable {
    public double x;
    public double y;
    public double z;

    public Vector3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3D() {
        this(0.0, 0.0, 0.0);
    }

    public Vector3D(Vector3D vector) {
        this(vector.x, vector.y, vector.z);
    }

    public Vector3D(double amount) {
        this(amount, amount, amount);
    }

    public Vector3D(Entity par1) {
        this(par1.field_70165_t, par1.field_70163_u, par1.field_70161_v);
    }

    public Vector3D(TileEntity par1) {
        this(par1.field_145851_c, par1.field_145848_d, par1.field_145849_e);
    }

    public Vector3D(Vec3 par1) {
        this(par1.field_72450_a, par1.field_72448_b, par1.field_72449_c);
    }

    public Vector3D(MovingObjectPosition par1) {
        this(par1.field_72311_b, par1.field_72312_c, par1.field_72309_d);
    }

    public Vector3D(ChunkCoordinates par1) {
        this(par1.field_71574_a, par1.field_71572_b, par1.field_71573_c);
    }

    public Vector3D(ForgeDirection direction) {
        this(direction.offsetX, direction.offsetY, direction.offsetZ);
    }

    public Vector3D(NBTTagCompound nbt) {
        this(nbt.func_74769_h("x"), nbt.func_74769_h("y"), nbt.func_74769_h("z"));
    }

    public Vector3D(float rotationYaw, float rotationPitch) {
        this(Math.cos(Math.toRadians(rotationYaw + 90.0f)), Math.sin(Math.toRadians(-rotationPitch)), Math.sin(Math.toRadians(rotationYaw + 90.0f)));
    }

    public static double distance(TileEntity e, double x, double y, double z) {
        x = (double)e.field_145851_c - x;
        y = (double)e.field_145848_d - y;
        z = (double)e.field_145849_e - y;
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static Vector3D fromCenter(Entity e) {
        return new Vector3D(e.field_70165_t, e.field_70163_u - (double)e.field_70129_M + (double)(e.field_70131_O / 2.0f), e.field_70161_v);
    }

    public static Vector3D fromCenter(TileEntity e) {
        return new Vector3D((double)e.field_145851_c + 0.5, (double)e.field_145848_d + 0.5, (double)e.field_145849_e + 0.5);
    }

    public static double distance(Vector3D vec1, Vector3D vec2) {
        return vec1.distance(vec2);
    }

    public static Vector3D translate(Vector3D first, Vector3D second) {
        return first.clone().translate(second);
    }

    public static Vector3D translate(Vector3D translate, double addition) {
        return translate.clone().translate(addition);
    }

    public static Vector3D scale(Vector3D vec, double amount) {
        return vec.scale(amount);
    }

    public static Vector3D scale(Vector3D vec, Vector3D amount) {
        return vec.scale(amount);
    }

    public static Vector3D translateMatrix(double[] matrix, Vector3D translation) {
        double x = translation.x * matrix[0] + translation.y * matrix[1] + translation.z * matrix[2] + matrix[3];
        double y = translation.x * matrix[4] + translation.y * matrix[5] + translation.z * matrix[6] + matrix[7];
        double z = translation.x * matrix[8] + translation.y * matrix[9] + translation.z * matrix[10] + matrix[11];
        translation.x = x;
        translation.y = y;
        translation.z = z;
        return translation;
    }

    public static double[] getRotationMatrix(float angle, Vector3D axis) {
        return axis.getRotationMatrix(angle);
    }

    public static Vector3D getDeltaPositionFromRotation(float rotationYaw, float rotationPitch) {
        return new Vector3D(rotationYaw, rotationPitch);
    }

    public static double getAngle(Vector3D vec1, Vector3D vec2) {
        return vec1.getAngle(vec2);
    }

    public static double anglePreNorm(Vector3D vec1, Vector3D vec2) {
        return Math.acos(vec1.clone().dotProduct(vec2));
    }

    public static Vector3D UP() {
        return new Vector3D(0.0, 1.0, 0.0);
    }

    public static Vector3D DOWN() {
        return new Vector3D(0.0, -1.0, 0.0);
    }

    public static Vector3D NORTH() {
        return new Vector3D(0.0, 0.0, -1.0);
    }

    public static Vector3D SOUTH() {
        return new Vector3D(0.0, 0.0, 1.0);
    }

    public static Vector3D WEST() {
        return new Vector3D(-1.0, 0.0, 0.0);
    }

    public static Vector3D EAST() {
        return new Vector3D(1.0, 0.0, 0.0);
    }

    public static Vector3D ZERO() {
        return new Vector3D(0.0, 0.0, 0.0);
    }

    public static Vector3D CENTER() {
        return new Vector3D(0.5, 0.5, 0.5);
    }

    public int intX() {
        return (int)Math.floor(this.x);
    }

    public int intY() {
        return (int)Math.floor(this.y);
    }

    public int intZ() {
        return (int)Math.floor(this.z);
    }

    public float floatX() {
        return (float)this.x;
    }

    public float floatY() {
        return (float)this.y;
    }

    public float floatZ() {
        return (float)this.z;
    }

    public Vector3D clone() {
        return new Vector3D(this);
    }

    public Block getBlock(IBlockAccess world) {
        return world.func_147439_a(this.intX(), this.intY(), this.intZ());
    }

    public int getBlockMetadata(IBlockAccess world) {
        return world.func_72805_g(this.intX(), this.intY(), this.intZ());
    }

    public TileEntity getTileEntity(IBlockAccess world) {
        return world.func_147438_o(this.intX(), this.intY(), this.intZ());
    }

    public boolean setBlock(World world, Block block, int metadata, int notify) {
        return world.func_147465_d(this.intX(), this.intY(), this.intZ(), block, metadata, notify);
    }

    public boolean setBlock(World world, Block block, int metadata) {
        return this.setBlock(world, block, metadata, 3);
    }

    public boolean setBlock(World world, Block block) {
        return this.setBlock(world, block, 0);
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74780_a("x", this.x);
        nbt.func_74780_a("y", this.y);
        nbt.func_74780_a("z", this.z);
        return nbt;
    }

    public ForgeDirection toForgeDirection() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (this.x != (double)direction.offsetX || this.y != (double)direction.offsetY || this.z != (double)direction.offsetZ) continue;
            return direction;
        }
        return ForgeDirection.UNKNOWN;
    }

    public double getMagnitude() {
        return Math.sqrt(this.getMagnitudeSquared());
    }

    public double getMagnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3D normalize() {
        double d = this.getMagnitude();
        if (d != 0.0) {
            this.scale(1.0 / d);
        }
        return this;
    }

    public double distance(double x, double y, double z) {
        Vector3D difference = this.clone().difference(x, y, z);
        return difference.getMagnitude();
    }

    public double distance(Vector3D compare) {
        return this.distance(compare.x, compare.y, compare.z);
    }

    public double distance(Entity entity) {
        return this.distance(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public Vector3D invert() {
        this.scale(-1.0);
        return this;
    }

    public Vector3D translate(ForgeDirection side, double amount) {
        return this.translate(new Vector3D(side).scale(amount));
    }

    public Vector3D translate(ForgeDirection side) {
        return this.translate(side, 1.0);
    }

    @Deprecated
    public Vector3D modifyPositionFromSide(ForgeDirection side, double amount) {
        return this.translate(side, amount);
    }

    @Deprecated
    public Vector3D modifyPositionFromSide(ForgeDirection side) {
        return this.translate(side);
    }

    public Vector3D translate(Vector3D addition) {
        this.x += addition.x;
        this.y += addition.y;
        this.z += addition.z;
        return this;
    }

    public Vector3D translate(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector3D translate(double addition) {
        this.x += addition;
        this.y += addition;
        this.z += addition;
        return this;
    }

    public Vector3D add(Vector3D amount) {
        return this.translate(amount);
    }

    public Vector3D add(double amount) {
        return this.translate(amount);
    }

    public Vector3D subtract(Vector3D amount) {
        return this.translate(amount.clone().invert());
    }

    public Vector3D subtract(double amount) {
        return this.translate(-amount);
    }

    public Vector3D subtract(double x, double y, double z) {
        return this.difference(x, y, z);
    }

    public Vector3D difference(Vector3D amount) {
        return this.translate(amount.clone().invert());
    }

    public Vector3D difference(double amount) {
        return this.translate(-amount);
    }

    public Vector3D difference(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vector3D scale(double amount) {
        this.x *= amount;
        this.y *= amount;
        this.z *= amount;
        return this;
    }

    public Vector3D scale(double x, double y, double z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Vector3D scale(Vector3D amount) {
        this.x *= amount.x;
        this.y *= amount.y;
        this.z *= amount.z;
        return this;
    }

    public Vector3D max(Vector3D other) {
        return new Vector3D(Math.max(this.x, other.x), Math.max(this.y, other.y), Math.max(this.z, other.z));
    }

    public Vector3D min(Vector3D other) {
        return new Vector3D(Math.min(this.x, other.x), Math.min(this.y, other.y), Math.min(this.z, other.z));
    }

    public Vector3D round() {
        return new Vector3D(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    public Vector3D ceil() {
        return new Vector3D(Math.ceil(this.x), Math.ceil(this.y), Math.ceil(this.z));
    }

    public Vector3D floor() {
        return new Vector3D(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public Vector3D toRound() {
        this.x = Math.round(this.x);
        this.y = Math.round(this.y);
        this.z = Math.round(this.z);
        return this;
    }

    public Vector3D toCeil() {
        this.x = Math.ceil(this.x);
        this.y = Math.ceil(this.y);
        this.z = Math.ceil(this.z);
        return this;
    }

    public Vector3D toFloor() {
        this.x = Math.floor(this.x);
        this.y = Math.floor(this.y);
        this.z = Math.floor(this.z);
        return this;
    }

    public List<Entity> getEntitiesWithin(World worldObj, Class<? extends Entity> par1Class) {
        return worldObj.func_72872_a(par1Class, AxisAlignedBB.func_72330_a((double)this.intX(), (double)this.intY(), (double)this.intZ(), (double)(this.intX() + 1), (double)(this.intY() + 1), (double)(this.intZ() + 1)));
    }

    public Vector3D midPoint(Vector3D pos) {
        return new Vector3D((this.x + pos.x) / 2.0, (this.y + pos.y) / 2.0, (this.z + pos.z) / 2.0);
    }

    public Vector3D toCrossProduct(Vector3D compare) {
        double newX = this.y * compare.z - this.z * compare.y;
        double newY = this.z * compare.x - this.x * compare.z;
        double newZ = this.x * compare.y - this.y * compare.x;
        this.x = newX;
        this.y = newY;
        this.z = newZ;
        return this;
    }

    public Vector3D crossProduct(Vector3D compare) {
        return this.clone().toCrossProduct(compare);
    }

    public Vector3D xCrossProduct() {
        return new Vector3D(0.0, this.z, -this.y);
    }

    public Vector3D zCrossProduct() {
        return new Vector3D(-this.y, this.x, 0.0);
    }

    public double dotProduct(Vector3D vec2) {
        return this.x * vec2.x + this.y * vec2.y + this.z * vec2.z;
    }

    public Vector3D getPerpendicular() {
        if (this.z == 0.0) {
            return this.zCrossProduct();
        }
        return this.xCrossProduct();
    }

    public boolean isZero() {
        return this.equals(Vector3D.ZERO());
    }

    public Vector3D rotate(float angle, Vector3D axis) {
        return Vector3D.translateMatrix(Vector3D.getRotationMatrix(angle, axis), this);
    }

    public double[] getRotationMatrix(float angle) {
        double[] matrix = new double[16];
        Vector3D axis = this.clone().normalize();
        double x = axis.x;
        double y = axis.y;
        double z = axis.z;
        angle = (float)((double)angle * 0.0174532925);
        float cos = (float)Math.cos(angle);
        float ocos = 1.0f - cos;
        float sin = (float)Math.sin(angle);
        matrix[0] = x * x * (double)ocos + (double)cos;
        matrix[1] = y * x * (double)ocos + z * (double)sin;
        matrix[2] = x * z * (double)ocos - y * (double)sin;
        matrix[4] = x * y * (double)ocos - z * (double)sin;
        matrix[5] = y * y * (double)ocos + (double)cos;
        matrix[6] = y * z * (double)ocos + x * (double)sin;
        matrix[8] = x * z * (double)ocos + y * (double)sin;
        matrix[9] = y * z * (double)ocos - x * (double)sin;
        matrix[10] = z * z * (double)ocos + (double)cos;
        matrix[15] = 1.0;
        return matrix;
    }

    public void rotate(double yaw, double pitch, double roll) {
        double yawRadians = Math.toRadians(yaw);
        double pitchRadians = Math.toRadians(pitch);
        double rollRadians = Math.toRadians(roll);
        double x = this.x;
        double y = this.y;
        double z = this.z;
        this.x = x * Math.cos(yawRadians) * Math.cos(pitchRadians) + z * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) - Math.sin(yawRadians) * Math.cos(rollRadians)) + y * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) + Math.sin(yawRadians) * Math.sin(rollRadians));
        this.z = x * Math.sin(yawRadians) * Math.cos(pitchRadians) + z * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) + Math.cos(yawRadians) * Math.cos(rollRadians)) + y * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) - Math.cos(yawRadians) * Math.sin(rollRadians));
        this.y = -x * Math.sin(pitchRadians) + z * Math.cos(pitchRadians) * Math.sin(rollRadians) + y * Math.cos(pitchRadians) * Math.cos(rollRadians);
    }

    public void rotate(double yaw, double pitch) {
        this.rotate(yaw, pitch, 0.0);
    }

    public void rotate(double yaw) {
        double yawRadians = Math.toRadians(yaw);
        double x = this.x;
        double z = this.z;
        if (yaw != 0.0) {
            this.x = x * Math.cos(yawRadians) - z * Math.sin(yawRadians);
            this.z = x * Math.sin(yawRadians) + z * Math.cos(yawRadians);
        }
    }

    public double getAngle(Vector3D vec2) {
        return Vector3D.anglePreNorm(this.clone().normalize(), vec2.clone().normalize());
    }

    public double anglePreNorm(Vector3D vec2) {
        return Math.acos(this.dotProduct(vec2));
    }

    public MovingObjectPosition rayTrace(World world, float rotationYaw, float rotationPitch, boolean collisionFlag, double reachDistance) {
        Vector3D lookVector = Vector3D.getDeltaPositionFromRotation(rotationYaw, rotationPitch);
        Vector3D reachPoint = this.clone().translate(lookVector.clone().scale(reachDistance));
        return this.rayTrace(world, reachPoint, collisionFlag);
    }

    public MovingObjectPosition rayTrace(World world, Vector3D reachPoint, boolean collisionFlag) {
        MovingObjectPosition pickedBlock = this.rayTraceBlocks(world, reachPoint.clone(), collisionFlag);
        MovingObjectPosition pickedEntity = this.rayTraceEntities(world, reachPoint.clone());
        if (pickedBlock == null) {
            return pickedEntity;
        }
        if (pickedEntity == null) {
            return pickedBlock;
        }
        double dBlock = this.distance(new Vector3D(pickedBlock.field_72307_f));
        double dEntity = this.distance(new Vector3D(pickedEntity.field_72307_f));
        if (dEntity < dBlock) {
            return pickedEntity;
        }
        return pickedBlock;
    }

    public MovingObjectPosition rayTrace(World world, boolean collisionFlag, double reachDistance) {
        return this.rayTrace(world, 0.0f, 0.0f, collisionFlag, reachDistance);
    }

    public MovingObjectPosition rayTraceBlocks(World world, float rotationYaw, float rotationPitch, boolean collisionFlag, double reachDistance) {
        Vector3D lookVector = Vector3D.getDeltaPositionFromRotation(rotationYaw, rotationPitch);
        Vector3D reachPoint = this.clone().translate(lookVector.clone().scale(reachDistance));
        return this.rayTraceBlocks(world, reachPoint, collisionFlag);
    }

    public MovingObjectPosition rayTraceBlocks(World world, Vector3D vec, boolean collisionFlag) {
        return world.func_72901_a(this.toVec3(), vec.toVec3(), collisionFlag);
    }

    @Deprecated
    public MovingObjectPosition rayTraceEntities(World world, float rotationYaw, float rotationPitch, boolean collisionFlag, double reachDistance) {
        return this.rayTraceEntities(world, rotationYaw, rotationPitch, reachDistance);
    }

    public MovingObjectPosition rayTraceEntities(World world, float rotationYaw, float rotationPitch, double reachDistance) {
        return this.rayTraceEntities(world, Vector3D.getDeltaPositionFromRotation(rotationYaw, rotationPitch).scale(reachDistance));
    }

    public MovingObjectPosition rayTraceEntities(World world, Vector3D target) {
        MovingObjectPosition pickedEntity = null;
        Vec3 startingPosition = this.toVec3();
        Vec3 look = target.toVec3();
        double reachDistance = this.distance(target);
        Vec3 reachPoint = Vec3.func_72443_a((double)(startingPosition.field_72450_a + look.field_72450_a * reachDistance), (double)(startingPosition.field_72448_b + look.field_72448_b * reachDistance), (double)(startingPosition.field_72449_c + look.field_72449_c * reachDistance));
        double checkBorder = 1.1 * reachDistance;
        AxisAlignedBB boxToScan = AxisAlignedBB.func_72330_a((double)(-checkBorder), (double)(-checkBorder), (double)(-checkBorder), (double)checkBorder, (double)checkBorder, (double)checkBorder).func_72317_d(this.x, this.y, this.z);
        List entitiesHit = world.func_72839_b(null, boxToScan);
        double closestEntity = reachDistance;
        if (entitiesHit == null || entitiesHit.isEmpty()) {
            return null;
        }
        for (Entity entityHit : entitiesHit) {
            float border;
            AxisAlignedBB aabb;
            MovingObjectPosition hitMOP;
            if (entityHit == null || !entityHit.func_70067_L() || entityHit.field_70121_D == null || (hitMOP = (aabb = entityHit.field_70121_D.func_72314_b((double)(border = entityHit.func_70111_Y()), (double)border, (double)border)).func_72327_a(startingPosition, reachPoint)) == null) continue;
            if (aabb.func_72318_a(startingPosition)) {
                if (!(0.0 < closestEntity) && closestEntity != 0.0 || (pickedEntity = new MovingObjectPosition(entityHit)) == null) continue;
                pickedEntity.field_72307_f = hitMOP.field_72307_f;
                closestEntity = 0.0;
                continue;
            }
            double distance = startingPosition.func_72438_d(hitMOP.field_72307_f);
            if (!(distance < closestEntity) && closestEntity != 0.0) continue;
            pickedEntity = new MovingObjectPosition(entityHit);
            pickedEntity.field_72307_f = hitMOP.field_72307_f;
            closestEntity = distance;
        }
        return pickedEntity;
    }

    public MovingObjectPosition rayTraceEntities(World world, Entity target) {
        return this.rayTraceEntities(world, new Vector3D(target));
    }

    public int hashCode() {
        long x = Double.doubleToLongBits(this.x);
        long y = Double.doubleToLongBits(this.y);
        long z = Double.doubleToLongBits(this.z);
        int hash = (int)(x ^ x >>> 32);
        hash = 31 * hash + (int)(y ^ y >>> 32);
        hash = 31 * hash + (int)(z ^ z >>> 32);
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof Vector3D) {
            Vector3D vector3D = (Vector3D)o;
            return this.x == vector3D.x && this.y == vector3D.y && this.z == vector3D.z;
        }
        return false;
    }

    public String toString() {
        return "Vector3D [" + this.x + "," + this.y + "," + this.z + "]";
    }
}

