/*
 * Decompiled with CFR 0.152.
 */
package com.mffs.common.items;

import com.mffs.ModularForcefieldSystem;
import com.mffs.RegisterManager;
import com.mffs.api.IBlockFrequency;
import com.mffs.api.card.ICoordLink;
import com.mffs.api.fortron.FrequencyGrid;
import com.mffs.api.fortron.IFortronFrequency;
import com.mffs.api.security.IInterdictionMatrix;
import com.mffs.api.security.Permission;
import com.mffs.api.utils.MatrixHelper;
import com.mffs.api.utils.UnitDisplay;
import com.mffs.api.vector.Vector3D;
import com.mffs.common.items.card.ItemCardFrequency;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mekanism.api.Coord4D;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class RemoteController
extends ItemCardFrequency
implements ICoordLink {
    private Coord4D link;

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer usr, List list, boolean dummy) {
        super.func_77624_a(stack, usr, list, dummy);
        Coord4D link = this.getLink(stack);
        if (link != null) {
            WorldServer world = DimensionManager.getWorld((int)link.dimensionId);
            Block block = link.getBlock((IBlockAccess)world);
            if (block != null) {
                list.add(LanguageRegistry.instance().getStringLocalization("info.item.linkedWith") + " " + block.func_149732_F());
            }
            list.add(link.xCoord + ", " + link.yCoord + ", " + link.zCoord);
            list.add(LanguageRegistry.instance().getStringLocalization("info.item.dimension") + " " + world.func_72912_H().func_76065_j());
        } else {
            super.func_77624_a(stack, usr, list, dummy);
            list.add(EnumChatFormatting.RED + LanguageRegistry.instance().getStringLocalization("info.item.notLinked"));
        }
    }

    @Override
    public void setLink(ItemStack paramItemStack, Coord4D paramVectorWorld) {
        NBTTagCompound tag = RegisterManager.getTag(paramItemStack);
        this.link = paramVectorWorld;
        tag.func_74782_a("mffs_link", (NBTBase)paramVectorWorld.write(tag.func_74775_l("mffs_link")));
    }

    @Override
    public Coord4D getLink(ItemStack paramItemStack) {
        NBTTagCompound tag = RegisterManager.getTag(paramItemStack);
        if (!tag.func_74764_b("mffs_link")) {
            return null;
        }
        if (this.link == null) {
            this.link = Coord4D.read(tag.func_74775_l("mffs_link"));
            return this.link;
        }
        return this.link;
    }

    @Override
    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            Coord4D coord = new Coord4D(x, y, z, world.field_73011_w.field_76574_g);
            this.setLink(stack, coord);
            Block block = coord.getBlock((IBlockAccess)world);
            if (block != null && !world.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText(String.format(LanguageRegistry.instance().getStringLocalization("message.remoteController.linked").replace("%p", x + ", " + y + ", " + z).replace("%q", block.func_149732_F()), new Object[0])));
            }
        }
        return true;
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer usr) {
        Block block;
        Coord4D position;
        if (!usr.func_70093_af() && (position = this.getLink(stack)) != null && (block = position.getBlock((IBlockAccess)world)) != null) {
            Chunk chunk = world.func_72938_d(position.xCoord, position.zCoord);
            Set<IBlockFrequency> freq = FrequencyGrid.instance().get();
            Vector3D usrLoc = new Vector3D((Entity)usr);
            IInterdictionMatrix matrix = MatrixHelper.findMatrix(world, usrLoc, freq);
            if (chunk != null && chunk.field_76636_d && (matrix == null || MatrixHelper.checkActionPermission(matrix, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, usr) || MatrixHelper.checkPermission(matrix, usr.func_146103_bH().getName(), Permission.REMOTE_CONTROL))) {
                float requiredEnergy = (float)usrLoc.distance(position.xCoord, position.yCoord, position.zCoord) * 10.0f;
                int receivedEnergy = 0;
                int freq_ = this.getFrequency(stack);
                Iterator<IBlockFrequency> it$ = freq.iterator();
                while (it$.hasNext()) {
                    IBlockFrequency b_freq = it$.next();
                    if (!(b_freq instanceof IFortronFrequency) || usrLoc.distance(((TileEntity)b_freq).field_145851_c, ((TileEntity)b_freq).field_145848_d, ((TileEntity)b_freq).field_145849_e) > 50.0) {
                        it$.remove();
                        continue;
                    }
                    if (b_freq.getFrequency() == freq_) continue;
                    it$.remove();
                }
                Vector3D center = usrLoc.clone().add(new Vector3D(0.0, (double)usr.func_70047_e() - 0.2, 0.0));
                for (IBlockFrequency bl : freq) {
                    IFortronFrequency fortronTile = (IFortronFrequency)bl;
                    int consumedEnergy = fortronTile.requestFortron((int)Math.ceil(requiredEnergy / (float)freq.size()), true);
                    if (consumedEnergy > 0) {
                        ModularForcefieldSystem.proxy.registerBeamEffect(world, center, new Vector3D((TileEntity)fortronTile).add(0.5), 0.6f, 0.6f, 1.0f, 20);
                        receivedEnergy += consumedEnergy;
                    }
                    if (!((float)receivedEnergy >= requiredEnergy)) continue;
                    try {
                        block.func_149727_a(world, position.xCoord, position.yCoord, position.zCoord, usr, 0, 0.0f, 0.0f, 0.0f);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return stack;
                }
                if (!world.field_72995_K) {
                    usr.func_145747_a((IChatComponent)new ChatComponentText(LanguageRegistry.instance().getStringLocalization("message.remoteController.fail").replaceAll("%p", UnitDisplay.getDisplay(requiredEnergy, UnitDisplay.Unit.JOULES))));
                }
            }
        }
        return stack;
    }
}

