/*
 * Decompiled with CFR 0.152.
 */
package com.mffs.common.items.modules.projector.type;

import com.mffs.api.IFieldInteraction;
import com.mffs.api.IProjector;
import com.mffs.api.render.ModelCube;
import com.mffs.api.vector.Matrix2d;
import com.mffs.api.vector.Vector3D;
import com.mffs.common.items.ItemMode;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class ItemModeCube
extends ItemMode {
    @Override
    public Set<Vector3D> getExteriorPoints(IFieldInteraction projector) {
        HashSet<Vector3D> fieldBlocks = new HashSet<Vector3D>();
        Vector3D posScale = projector.getPositiveScale();
        Vector3D negScale = projector.getNegativeScale();
        for (float x = (float)(-negScale.intX()); x <= (float)posScale.intX(); x += 0.5f) {
            for (float z = (float)(-negScale.intZ()); z <= (float)posScale.intZ(); z += 0.5f) {
                for (float y = (float)(-negScale.intY()); y <= (float)posScale.intY(); y += 0.5f) {
                    if (y != (float)(-negScale.intY()) && y != (float)posScale.intY() && x != (float)(-negScale.intX()) && x != (float)posScale.intX() && z != (float)(-negScale.intZ()) && z != (float)posScale.intZ()) continue;
                    fieldBlocks.add(new Vector3D(x, y, z));
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public Set<Vector3D> getInteriorPoints(IFieldInteraction projector) {
        HashSet<Vector3D> fieldBlocks = new HashSet<Vector3D>();
        Vector3D posScale = projector.getPositiveScale();
        Vector3D negScale = projector.getNegativeScale();
        for (int x = -((int)Math.floor(negScale.intX())); x <= (int)Math.floor(posScale.intX()); ++x) {
            int z = -((int)Math.floor(negScale.intZ()));
            while (x <= (int)Math.floor(posScale.intZ())) {
                int y = -((int)Math.floor(negScale.intY()));
                while (x <= (int)Math.floor(posScale.intY())) {
                    fieldBlocks.add(new Vector3D(x, y, z));
                    ++y;
                }
                ++z;
            }
        }
        return fieldBlocks;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(IProjector projector, double x, double y, double z, float f, long ticks) {
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        ModelCube.INSTNACE.render();
    }

    @Override
    public boolean isInField(IFieldInteraction projector, Vector3D position) {
        Vector3D projectorPos = new Vector3D((TileEntity)projector);
        projectorPos.add(projector.getTranslation());
        Vector3D relativePosition = position.clone().subtract(projectorPos);
        relativePosition.rotate((double)(-projector.getRotationYaw()), projector.getRotationPitch());
        Matrix2d region = new Matrix2d(projector.getNegativeScale().scale(-1.0), projector.getPositiveScale());
        return region.isIn(relativePosition);
    }
}

