/*
 * Decompiled with CFR 0.152.
 */
package com.mffs.common.items.modules.projector.type;

import com.mffs.api.IFieldInteraction;
import com.mffs.api.IProjector;
import com.mffs.api.render.ModelCube;
import com.mffs.api.vector.Vector3D;
import com.mffs.common.items.ItemMode;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class ItemModeCylinder
extends ItemMode {
    @Override
    public Set<Vector3D> getExteriorPoints(IFieldInteraction projector) {
        HashSet<Vector3D> fieldBlocks = new HashSet<Vector3D>();
        Vector3D posScale = projector.getPositiveScale();
        Vector3D negScale = projector.getNegativeScale();
        int radius = (int)(Math.floor(posScale.x) + Math.floor(negScale.x) + Math.floor(posScale.z) + Math.floor(negScale.z) / 2.0);
        int height = (int)(Math.floor(posScale.y) + Math.floor(negScale.y));
        for (float x = (float)(-radius); x <= (float)radius; x += 1.0f) {
            for (float z = (float)(-radius); z <= (float)radius; z += 1.0f) {
                for (float y = 0.0f; y < (float)height; y += 1.0f) {
                    if ((y == 0.0f || y == (float)(height - 1)) && x * x + z * z + 0.0f <= (float)(radius * radius)) {
                        fieldBlocks.add(new Vector3D(x, y, z));
                    }
                    if (!(x * x + z * z + 0.0f <= (float)(radius * radius)) || !(x * x + z * z + 0.0f >= (float)((radius - 1) * (radius - 1)))) continue;
                    fieldBlocks.add(new Vector3D(x, y, z));
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public Set<Vector3D> getInteriorPoints(IFieldInteraction projector) {
        HashSet<Vector3D> fieldBlocks = new HashSet<Vector3D>();
        Vector3D translation = projector.getTranslation();
        Vector3D posScale = projector.getPositiveScale();
        Vector3D negScale = projector.getNegativeScale();
        int radius = (int)(Math.floor(posScale.x) + Math.floor(negScale.x) + Math.floor(posScale.z) + Math.floor(negScale.z)) / 2;
        int height = (int)(Math.floor(posScale.y) + Math.floor(negScale.y));
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = 0; y < height; ++y) {
                    Vector3D position = new Vector3D(x, y, z);
                    if (!this.isInField(projector, position.add(new Vector3D((TileEntity)projector)).add(translation))) continue;
                    fieldBlocks.add(position);
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public boolean isInField(IFieldInteraction projector, Vector3D position) {
        Vector3D posScale = projector.getPositiveScale();
        Vector3D negScale = projector.getNegativeScale();
        int radius = (int)(Math.floor(posScale.x) + Math.floor(negScale.x) + Math.floor(posScale.z) + Math.floor(negScale.z)) / 2;
        Vector3D projectorPos = new Vector3D((TileEntity)projector);
        projectorPos.add(projector.getTranslation());
        Vector3D relativePosition = position.clone().subtract(projectorPos);
        relativePosition.rotate((double)(-projector.getRotationYaw()), projector.getRotationPitch());
        return relativePosition.x * relativePosition.x + relativePosition.z * relativePosition.z + 0.0 <= (double)(radius * radius);
    }

    @Override
    public void render(IProjector projector, double x, double y, double z, float f, long ticks) {
        float scale = 0.15f;
        float detail = 0.5f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        float radius = 1.5f;
        int i = 0;
        for (float renderX = -radius; renderX <= radius; renderX += detail) {
            for (float renderZ = -radius; renderZ <= radius; renderZ += detail) {
                for (float renderY = -radius; renderY <= radius; renderY += detail) {
                    if (!(renderX * renderX + renderZ * renderZ + 0.0f <= radius * radius && renderX * renderX + renderZ * renderZ + 0.0f >= (radius - 1.0f) * (radius - 1.0f)) && (renderY != 0.0f && renderY != radius - 1.0f || !(renderX * renderX + renderZ * renderZ + 0.0f <= radius * radius))) continue;
                    if (i % 2 == 0) {
                        Vector3D vector = new Vector3D(renderX, renderY, renderZ);
                        GL11.glTranslated((double)vector.x, (double)vector.y, (double)vector.z);
                        ModelCube.INSTNACE.render();
                        GL11.glTranslated((double)(-vector.x), (double)(-vector.y), (double)(-vector.z));
                    }
                    ++i;
                }
            }
        }
    }
}

