/*
 * Decompiled with CFR 0.152.
 */
package com.mffs.common.items.modules.projector.type;

import com.mffs.api.IFieldInteraction;
import com.mffs.api.IProjector;
import com.mffs.api.vector.Matrix2d;
import com.mffs.api.vector.Vector3D;
import com.mffs.common.items.ItemMode;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class ItemModePyramid
extends ItemMode {
    @Override
    public Set<Vector3D> getExteriorPoints(IFieldInteraction projector) {
        HashSet<Vector3D> fieldBlocks = new HashSet<Vector3D>();
        Vector3D posScale = projector.getPositiveScale();
        Vector3D negScale = projector.getNegativeScale();
        int xStretch = (int)Math.floor(posScale.x) + (int)Math.floor(negScale.x);
        int yStretch = (int)Math.floor(posScale.y) + (int)Math.floor(negScale.y);
        int zStretch = (int)Math.floor(posScale.z) + (int)Math.floor(negScale.z);
        Vector3D translation = new Vector3D(0.0, -((int)Math.floor(negScale.y)), 0.0);
        int inverseThickness = (int)Math.max((float)(yStretch + zStretch) / 4.0f, 1.0f);
        for (float y = 0.0f; y <= (float)yStretch; y += 1.0f) {
            for (float x = (float)(-xStretch); x <= (float)xStretch; x += 1.0f) {
                for (float z = (float)(-zStretch); z <= (float)zStretch; z += 1.0f) {
                    double yTest = y / (float)yStretch * (float)inverseThickness;
                    double xzPositivePlane = (1.0f - x / (float)xStretch - z / (float)zStretch) * (float)inverseThickness;
                    double xzNegativePlane = (1.0f + x / (float)xStretch - z / (float)zStretch) * (float)inverseThickness;
                    if (x >= 0.0f && z >= 0.0f && Math.round(xzPositivePlane) == Math.round(yTest)) {
                        fieldBlocks.add(new Vector3D(x, y, z).add(translation));
                        fieldBlocks.add(new Vector3D(x, y, -z).add(translation));
                    }
                    if (x <= 0.0f && z >= 0.0f && Math.round(xzNegativePlane) == Math.round(yTest)) {
                        fieldBlocks.add(new Vector3D(x, y, -z).add(translation));
                        fieldBlocks.add(new Vector3D(x, y, z).add(translation));
                    }
                    if (y != 0.0f || !(Math.abs(x) + Math.abs(z) < (float)((xStretch + yStretch) / 2))) continue;
                    fieldBlocks.add(new Vector3D(x, y, z).add(translation));
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public Set<Vector3D> getInteriorPoints(IFieldInteraction projector) {
        HashSet<Vector3D> fieldBlocks = new HashSet<Vector3D>();
        Vector3D posScale = projector.getPositiveScale();
        Vector3D negScale = projector.getNegativeScale();
        int xStretch = (int)Math.floor(posScale.x) + (int)Math.floor(negScale.x);
        int yStretch = (int)Math.floor(posScale.y) + (int)Math.floor(negScale.y);
        int zStretch = (int)Math.floor(posScale.z) + (int)Math.floor(negScale.z);
        Vector3D translation = new Vector3D(0.0, -0.4, 0.0);
        for (float x = (float)(-xStretch); x <= (float)xStretch; x += 1.0f) {
            for (float z = (float)(-zStretch); z <= (float)zStretch; z += 1.0f) {
                for (float y = 0.0f; y <= (float)yStretch; y += 1.0f) {
                    Vector3D position = new Vector3D(x, y, z).add(translation);
                    if (!this.isInField(projector, position.add(new Vector3D((TileEntity)projector)))) continue;
                    fieldBlocks.add(position);
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public boolean isInField(IFieldInteraction projector, Vector3D position) {
        Vector3D posScale = projector.getPositiveScale().clone();
        Vector3D negScale = projector.getNegativeScale().clone();
        int xStretch = (int)Math.floor(posScale.x) + (int)Math.floor(negScale.x);
        int yStretch = (int)Math.floor(posScale.y) + (int)Math.floor(negScale.y);
        int zStretch = (int)Math.floor(posScale.z) + (int)Math.floor(negScale.z);
        Vector3D projectorPos = new Vector3D((TileEntity)projector);
        projectorPos.add(projector.getTranslation());
        projectorPos.add(new Vector3D(0.0, -((int)Math.floor(negScale.y)) + 1, 0.0));
        Vector3D relativePosition = position.clone().subtract(projectorPos);
        relativePosition.rotate((double)(-projector.getRotationYaw()), projector.getRotationPitch());
        Matrix2d region = new Matrix2d(negScale.scale(-1.0), posScale);
        return region.isIn(relativePosition) && relativePosition.y > 0.0 && 1.0 - Math.abs(relativePosition.x) / (double)xStretch - Math.abs(relativePosition.z) / (double)zStretch > relativePosition.y / (double)yStretch;
    }

    @Override
    public void render(IProjector projector, double x, double y, double z, float f, long ticks) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float height = 0.5f;
        float width = 0.3f;
        int uvMaxX = 2;
        int uvMaxY = 2;
        Vector3D translation = new Vector3D(0.0, -0.4, 0.0);
        tessellator.func_78371_b(6);
        tessellator.func_78370_a(72, 198, 255, 255);
        tessellator.func_78374_a(0.0 + translation.x, 0.0 + translation.y, 0.0 + translation.z, 0.0, 0.0);
        tessellator.func_78374_a((double)(-width) + translation.x, (double)height + translation.y, (double)(-width) + translation.z, (double)(-uvMaxX), (double)(-uvMaxY));
        tessellator.func_78374_a((double)(-width) + translation.x, (double)height + translation.y, (double)width + translation.z, (double)(-uvMaxX), (double)uvMaxY);
        tessellator.func_78374_a((double)width + translation.x, (double)height + translation.y, (double)width + translation.z, (double)uvMaxX, (double)uvMaxY);
        tessellator.func_78374_a((double)width + translation.x, (double)height + translation.y, (double)(-width) + translation.z, (double)uvMaxX, (double)(-uvMaxY));
        tessellator.func_78374_a((double)(-width) + translation.x, (double)height + translation.y, (double)(-width) + translation.z, (double)(-uvMaxX), (double)(-uvMaxY));
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }
}

