/*
 * Decompiled with CFR 0.152.
 */
package com.mffs.common.items.modules.projector.type;

import com.mffs.api.IFieldInteraction;
import com.mffs.api.IProjector;
import com.mffs.api.render.ModelCube;
import com.mffs.api.vector.Vector3D;
import com.mffs.common.items.ItemMode;
import com.mffs.common.items.modules.upgrades.ItemModuleScale;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class ModeSphere
extends ItemMode {
    @Override
    public Set<Vector3D> getExteriorPoints(IFieldInteraction projector) {
        HashSet<Vector3D> fieldBlocks = new HashSet<Vector3D>();
        int radius = projector.getModuleCount(ItemModuleScale.class, new int[0]);
        int steps = (int)Math.ceil(Math.PI / Math.atan(1.0 / (double)radius / 2.0));
        for (int phi_n = 0; phi_n < 2 * steps; ++phi_n) {
            for (int theta_n = 0; theta_n < steps; ++theta_n) {
                double phi = Math.PI * 2 / (double)steps * (double)phi_n;
                double theta = Math.PI / (double)steps * (double)theta_n;
                Vector3D point = new Vector3D(Math.sin(theta) * Math.cos(phi), Math.cos(theta), Math.sin(theta) * Math.sin(phi)).scale(radius);
                fieldBlocks.add(point);
            }
        }
        return fieldBlocks;
    }

    @Override
    public Set<Vector3D> getInteriorPoints(IFieldInteraction projector) {
        HashSet<Vector3D> fieldBlocks = new HashSet<Vector3D>();
        Vector3D translation = projector.getTranslation();
        int radius = projector.getModuleCount(ItemModuleScale.class, new int[0]);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -radius; y <= radius; ++y) {
                    Vector3D position = new Vector3D(x, y, z);
                    if (!this.isInField(projector, position.add(new Vector3D((TileEntity)projector)).add(translation))) continue;
                    fieldBlocks.add(position);
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public boolean isInField(IFieldInteraction projector, Vector3D position) {
        return new Vector3D((TileEntity)projector).add(projector.getTranslation()).distance(position) < (double)projector.getModuleCount(ItemModuleScale.class, new int[0]);
    }

    @Override
    public void render(IProjector paramIProjector, double paramDouble1, double paramDouble2, double paramDouble3, float paramFloat, long paramLong) {
        float scale = 0.15f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        float radius = 1.5f;
        int steps = (int)Math.ceil(Math.PI / Math.atan(1.0 / (double)radius / 2.0));
        for (int phi_n = 0; phi_n < 2 * steps; ++phi_n) {
            for (int theta_n = 0; theta_n < steps; ++theta_n) {
                double phi = Math.PI * 2 / (double)steps * (double)phi_n;
                double theta = Math.PI / (double)steps * (double)theta_n;
                Vector3D vector = new Vector3D(Math.sin(theta) * Math.cos(phi), Math.cos(theta), Math.sin(theta) * Math.sin(phi)).scale(radius);
                GL11.glTranslated((double)vector.x, (double)vector.y, (double)vector.z);
                ModelCube.INSTNACE.render();
                GL11.glTranslated((double)(-vector.x), (double)(-vector.y), (double)(-vector.z));
            }
        }
    }
}

