/*
 * Decompiled with CFR 0.152.
 */
package com.mffs.common.net.packet;

import com.mffs.api.vector.Vector3D;
import com.mffs.common.net.TileEntityMessage;
import com.mffs.common.tile.type.TileForceFieldProjector;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;

public class ForcefieldCalculation
extends TileEntityMessage {
    private Set<Vector3D> blocks;

    public ForcefieldCalculation() {
    }

    public ForcefieldCalculation(TileForceFieldProjector proj) {
        super(proj);
        this.blocks = proj.getCalculatedField();
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.blocks = new HashSet<Vector3D>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            Vector3D vec = new Vector3D(buf.readInt(), buf.readInt(), buf.readInt());
            this.blocks.add(vec);
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.blocks.size());
        for (Vector3D vec : this.blocks) {
            buf.writeInt(vec.intX());
            buf.writeInt(vec.intY());
            buf.writeInt(vec.intZ());
        }
    }

    public Set<Vector3D> getBlocks() {
        return this.blocks;
    }

    public static class ClientHandler
    extends TileEntityMessage.ClientHandler<ForcefieldCalculation> {
    }
}

