/*
 * Decompiled with CFR 0.152.
 */
package com.mffs.common.tile;

import com.mffs.ModularForcefieldSystem;
import com.mffs.SettingConfiguration;
import com.mffs.api.card.ICard;
import com.mffs.api.fortron.FrequencyGrid;
import com.mffs.api.fortron.IFortronFrequency;
import com.mffs.api.utils.FortronHelper;
import com.mffs.api.vector.Matrix2d;
import com.mffs.api.vector.Vector3D;
import com.mffs.common.TransferMode;
import com.mffs.common.fluids.Fortron;
import com.mffs.common.net.packet.FortronSync;
import com.mffs.common.tile.TileFrequency;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class TileFortron
extends TileFrequency
implements IFluidHandler,
IFortronFrequency {
    public static final Matrix2d FORCE_BOUNDS = new Matrix2d(new Vector3D(175.0, 0.0, 0.0), new Vector3D(186.0, 107.0, 0.0));
    public boolean sendFortron = true;
    protected FluidTank tank = new FluidTank(1000);

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.ticks % SettingConfiguration.FORTRON_SYNC_TICKS == 0 && !this.field_145850_b.field_72995_K) {
            ModularForcefieldSystem.channel.sendToAllAround((IMessage)new FortronSync(this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 25.0));
        }
    }

    @Override
    public void func_145843_s() {
        if (this.sendFortron) {
            FortronHelper.transfer((IFortronFrequency)this, FrequencyGrid.instance().getFortronTiles(this.field_145850_b, new Vector3D(this), 100, this.getFrequency()), TransferMode.DRAIN, Integer.MAX_VALUE);
        }
        super.func_145843_s();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.tank.getFluid() != null) {
            nbt.func_74782_a("mffs_fortron", (NBTBase)this.tank.getFluid().writeToNBT(nbt.func_74775_l("mffs_fortron")));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("mffs_fortron")));
    }

    @Override
    public int getFortronEnergy() {
        return this.tank.getFluidAmount();
    }

    @Override
    public void setFortronEnergy(int paramInt) {
        this.tank.setFluid(FluidRegistry.getFluidStack((String)"fortron", (int)paramInt));
    }

    @Override
    public int getFortronCapacity() {
        return this.tank.getCapacity();
    }

    @Override
    public int requestFortron(int paramInt, boolean paramBoolean) {
        FluidStack stack = this.tank.drain(paramInt, paramBoolean);
        return stack == null ? 0 : stack.amount;
    }

    @Override
    public int provideFortron(int paramInt, boolean paramBoolean) {
        return this.tank.fill(FluidRegistry.getFluidStack((String)"fortron", (int)paramInt), paramBoolean);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource.getFluidID() == Fortron.FLUID_ID) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[0];
    }

    public ItemStack getCard() {
        ItemStack itemStack = this.func_70301_a(0);
        if (itemStack != null && itemStack.func_77973_b() instanceof ICard) {
            return itemStack;
        }
        return null;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public IMessage handleMessage(IMessage imessage) {
        if (imessage instanceof FortronSync) {
            FortronSync sync = (FortronSync)imessage;
            if (this.tank.getFluid() != null) {
                this.tank.getFluid().amount = sync.amount;
            } else {
                this.tank.setFluid(FluidRegistry.getFluidStack((String)"fortron", (int)sync.amount));
            }
        }
        return super.handleMessage(imessage);
    }
}

