/*
 * Decompiled with CFR 0.152.
 */
package com.mffs.common.tile;

import com.mffs.api.modules.IModule;
import com.mffs.api.modules.IModuleAcceptor;
import com.mffs.common.items.modules.upgrades.ItemModuleCapacity;
import com.mffs.common.tile.TileFortron;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileModuleAcceptor
extends TileFortron
implements IModuleAcceptor {
    protected int capacityBase = 500;
    protected int capacityBoost = 5;
    protected byte module_index;
    protected byte module_end = (byte)this.func_70302_i_();

    @Override
    public void start() {
        super.start();
        this.tank.setCapacity((this.getModuleCount(ItemModuleCapacity.class, new int[0]) * this.capacityBoost + this.capacityBase) * 1000);
    }

    @Override
    public ItemStack getModule(Class<? extends IModule> module) {
        ItemStack returnStack = null;
        for (ItemStack stack : this.inventory) {
            if (stack == null || !module.isAssignableFrom(stack.func_77973_b().getClass())) continue;
            if (returnStack == null) {
                returnStack = new ItemStack(stack.func_77973_b(), 0);
            }
            returnStack.field_77994_a += stack.field_77994_a;
        }
        return returnStack;
    }

    @Override
    public int getModuleCount(Class<? extends IModule> paramIModule, int ... paramVarArgs) {
        int count = 0;
        if (paramVarArgs != null && paramVarArgs.length > 0) {
            for (int slot : paramVarArgs) {
                ItemStack stack = this.func_70301_a(slot);
                if (stack == null || !paramIModule.isAssignableFrom(stack.func_77973_b().getClass())) continue;
                count += stack.field_77994_a;
            }
        } else {
            for (ItemStack stack : this.getModuleStacks(new int[0])) {
                if (stack == null || !paramIModule.isAssignableFrom(stack.func_77973_b().getClass())) continue;
                count += stack.field_77994_a;
            }
        }
        return count;
    }

    @Override
    public Set<ItemStack> getModuleStacks(int ... paramVarArgs) {
        HashSet<ItemStack> stacks = new HashSet<ItemStack>();
        if (paramVarArgs != null && paramVarArgs.length > 0) {
            for (int slot : paramVarArgs) {
                ItemStack stack = this.func_70301_a(slot);
                if (stack == null || !(stack.func_77973_b() instanceof IModule)) continue;
                stacks.add(stack);
            }
        } else {
            for (int i = this.module_index; i < this.module_end; ++i) {
                ItemStack stack = this.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof IModule)) continue;
                stacks.add(stack);
            }
        }
        return stacks;
    }

    @Override
    public Set<IModule> getModules(int ... paramVarArgs) {
        HashSet<IModule> stacks = new HashSet<IModule>();
        if (paramVarArgs != null && paramVarArgs.length > 0) {
            for (int slot : paramVarArgs) {
                ItemStack stack = this.func_70301_a(slot);
                if (stack == null || !(stack.func_77973_b() instanceof IModule)) continue;
                stacks.add((IModule)stack.func_77973_b());
            }
        } else {
            for (int i = this.module_index; i < this.module_end; ++i) {
                ItemStack stack = this.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof IModule)) continue;
                stacks.add((IModule)stack.func_77973_b());
            }
        }
        return stacks;
    }

    @Override
    public int getFortronCost() {
        int cost = this.calculateFortronCost();
        return cost;
    }

    public int calculateFortronCost() {
        float cost = 0.0f;
        for (ItemStack stack : this.getModuleStacks(new int[0])) {
            if (stack == null) continue;
            cost += (float)stack.field_77994_a * ((IModule)stack.func_77973_b()).getFortronCost(this.getAmplifier());
        }
        return Math.round(cost);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    @Override
    public void onSlotsChanged(int ... slots) {
        super.onSlotsChanged(slots);
        this.tank.setCapacity(this.getModuleCount(ItemModuleCapacity.class, new int[0]) * this.capacityBoost + this.capacityBase * 1000);
    }

    public float getAmplifier() {
        return 1.0f;
    }
}

