/*
 * Decompiled with CFR 0.152.
 */
package com.mffs.common.tile.type;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import com.mffs.SettingConfiguration;
import com.mffs.api.modules.IModule;
import com.mffs.common.items.card.ItemCardFrequency;
import com.mffs.common.items.modules.upgrades.ItemModuleScale;
import com.mffs.common.items.modules.upgrades.ItemModuleSpeed;
import com.mffs.common.tile.TileModuleAcceptor;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public final class TileCoercionDeriver
extends TileModuleAcceptor
implements IEnergyHandler {
    public static final int SLOT_FREQUENCY = 0;
    public static final int SLOT_BATTERY = 1;
    public static final int SLOT_FUEL = 2;
    public static int ENERGY_BUFFER_SIZE = 500000;
    public int processTime = 0;
    public boolean isInversed;
    protected EnergyStorage storage = new EnergyStorage(ENERGY_BUFFER_SIZE);

    public TileCoercionDeriver() {
        this.capacityBase = 30;
        this.module_index = (byte)3;
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.start();
    }

    @Override
    public void onSlotsChanged(int ... slots) {
        super.onSlotsChanged(slots);
        this.storage.setCapacity(Math.round(this.getWattage()));
        this.storage.setMaxTransfer(Math.round(this.getWattage() / 20.0f));
    }

    @Override
    public void start() {
        super.start();
        this.storage.setCapacity(Math.round(this.getWattage()));
        this.storage.setMaxTransfer(Math.round(this.getWattage() / 20.0f));
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.isActive()) {
                if (this.isInversed && SettingConfiguration.ENABLE_ELECTRICITY) {
                    if (this.storage.getEnergyStored() < this.storage.getMaxEnergyStored()) {
                        int produce = (int)Math.floor((double)this.requestFortron(this.getProductionRate() / 20, true) / 0.001);
                        this.storage.receiveEnergy(produce, false);
                    }
                } else if (this.getFortronEnergy() < this.getFortronCapacity() && (!SettingConfiguration.ENABLE_ELECTRICITY && this.func_94041_b(2, this.func_70301_a(2)) || this.storage.extractEnergy(this.storage.getMaxExtract(), true) >= this.storage.getMaxExtract())) {
                    this.provideFortron(this.getProductionRate(), true);
                    this.storage.extractEnergy(this.storage.getMaxExtract(), false);
                    if (this.processTime == 0 && this.func_94041_b(2, this.func_70301_a(2))) {
                        this.func_70298_a(2, 1);
                        this.processTime = 200 * Math.max(this.getModuleCount(ItemModuleScale.class, new int[0]) / 20, 1);
                    }
                    if (this.processTime > 0) {
                        --this.processTime;
                    }
                }
            }
        } else if (this.isActive()) {
            this.animation += 1.0f;
        }
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
    }

    @Override
    public int func_70302_i_() {
        return 6;
    }

    public float getWattage() {
        return SettingConfiguration.BASE_POWER_REQUIRED + SettingConfiguration.BASE_POWER_REQUIRED * (this.getModuleCount(ItemModuleSpeed.class, new int[0]) / 8);
    }

    public int getProductionRate() {
        if (this.isActive()) {
            int production = (int)(this.getWattage() / 20.0f * 0.001f * SettingConfiguration.FORTRON_PRODUCTION_MULTIPLIER);
            if (this.processTime > 0) {
                production *= 4;
            }
            return production;
        }
        return 0;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (itemStack != null) {
            if (slotID >= this.module_index) {
                return itemStack.func_77973_b() instanceof IModule;
            }
            switch (slotID) {
                case 0: {
                    return itemStack.func_77973_b() instanceof ItemCardFrequency;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return itemStack.func_77973_b() == Items.field_151100_aR && itemStack.func_77960_j() == 4 || itemStack.func_77973_b() == Items.field_151128_bU;
                }
            }
        }
        return false;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("process", this.processTime);
        nbt.func_74757_a("inverse", this.isInversed);
        this.storage.writeToNBT(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTime = nbt.func_74762_e("process");
        this.isInversed = nbt.func_74767_n("inverse");
        this.storage.readFromNBT(nbt);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }
}

