/*
 * Decompiled with CFR 0.152.
 */
package com.mffs.common.tile.type;

import com.mffs.ModularForcefieldSystem;
import com.mffs.SettingConfiguration;
import com.mffs.api.IProjector;
import com.mffs.api.modules.IModule;
import com.mffs.api.modules.IProjectorMode;
import com.mffs.api.vector.Vector3D;
import com.mffs.common.blocks.BlockForceField;
import com.mffs.common.items.ItemMode;
import com.mffs.common.items.card.ItemCardFrequency;
import com.mffs.common.items.modules.projector.ItemModuleDisintegration;
import com.mffs.common.items.modules.projector.type.ItemModeCustom;
import com.mffs.common.items.modules.upgrades.ItemModuleSilence;
import com.mffs.common.items.modules.upgrades.ItemModuleSpeed;
import com.mffs.common.net.packet.BeamRequest;
import com.mffs.common.net.packet.ForcefieldCalculation;
import com.mffs.common.tile.TileFieldMatrix;
import com.mffs.common.tile.type.TileForceField;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDeadBush;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockVine;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class TileForceFieldProjector
extends TileFieldMatrix
implements IProjector {
    protected final Set<Vector3D> blocks = new HashSet<Vector3D>();
    public boolean requireTicks;
    public boolean markFieldUpdate = true;
    private boolean isComplete;

    public TileForceFieldProjector() {
        this.capacityBase = 50;
        this.module_index = 1;
    }

    @Override
    public void start() {
        super.start();
        this.calculatedForceField();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.destroyField();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.isActive() && this.getMode() != null && this.requestFortron(this.getFortronCost(), false) >= this.getFortronCost()) {
            this.requestFortron(this.getFortronCost(), true);
            if (this.ticks % 10 == 0 || this.markFieldUpdate || this.requireTicks) {
                if (!this.isFinished) {
                    this.calculatedForceField();
                } else {
                    this.projectField();
                }
            }
            if (this.isActive() && this.field_145850_b.field_72995_K) {
                this.animation += (float)(this.getFortronCost() / 10);
            }
            if (this.ticks % 40 == 0 && this.getModuleCount(ItemModuleSilence.class, new int[0]) <= 0) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "mffs:field", 0.6f, 1.0f - this.field_145850_b.field_73012_v.nextFloat() * 0.1f);
            }
        } else if (!this.field_145850_b.field_72995_K) {
            this.destroyField();
        }
    }

    @Override
    public void calculatedForceField() {
        IProjectorMode stack;
        if (!this.isCalc && !this.func_145831_w().field_72995_K && (stack = this.getMode()) != null) {
            this.blocks.clear();
        }
        super.calculatedForceField();
        this.isComplete = false;
        this.requireTicks = false;
        Set<ItemStack> modules = this.getModuleStacks(new int[0]);
        for (ItemStack mod : modules) {
            if (!((IModule)mod.func_77973_b()).requireTicks(mod)) continue;
            this.requireTicks = true;
            return;
        }
    }

    @Override
    public void onCalculationCompletion() {
    }

    @Override
    public int func_70302_i_() {
        return 32;
    }

    @Override
    public int getProjectionSpeed() {
        return 28 + 28 * this.getModuleCount(ItemModuleSpeed.class, this.getModuleSlots());
    }

    @Override
    public long getTicks() {
        return this.ticks;
    }

    @Override
    public int calculateFortronCost() {
        IProjectorMode mode = this.getMode();
        if (mode != null) {
            return Math.round((float)super.calculateFortronCost() + mode.getFortronCost(this.getAmplifier()));
        }
        return 0;
    }

    @Override
    public float getAmplifier() {
        IProjectorMode mode = this.getMode();
        if (mode instanceof ItemModeCustom) {
            // empty if block
        }
        return Math.max(Math.min(this.getCalculatedField().size() / 1000, 10), 1);
    }

    @Override
    public Set<Vector3D> getForceFields() {
        return this.blocks;
    }

    private boolean canReplace(Vector3D vec) {
        Block block = vec.getBlock((IBlockAccess)this.field_145850_b);
        int dmod = this.getModuleCount(ItemModuleDisintegration.class, new int[0]);
        if (block != null) {
            return (dmod > 0 && (double)block.func_149712_f(this.field_145850_b, vec.intX(), vec.intY(), vec.intZ()) != -1.0 || block.isReplaceable((IBlockAccess)this.field_145850_b, vec.intX(), vec.intY(), vec.intZ()) || block.func_149688_o().func_76224_d() || block instanceof BlockSnow || block instanceof BlockVine || block instanceof BlockTallGrass || block instanceof BlockDeadBush) && !(block instanceof BlockForceField);
        }
        return dmod == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void projectField() {
        if (this.isFinished && !this.isCalc && (!this.isComplete || this.markFieldUpdate || this.requireTicks)) {
            this.markFieldUpdate = false;
            int constructSpeed = Math.min(this.getProjectionSpeed(), SettingConfiguration.MAX_FORCE_FIELDS_PER_TICK);
            Set set = this.calculatedFields;
            synchronized (set) {
                Set fieldToBeProjected = this.calculatedFields;
                for (IModule module : this.getModules(this.getModuleSlots())) {
                    if (!module.onProject((IProjector)this, fieldToBeProjected)) continue;
                    return;
                }
                Vector3D projector = new Vector3D(this);
                fieldToBeProjected = fieldToBeProjected.stream().filter(x -> !x.equals(projector) && this.canReplace((Vector3D)x)).filter(w -> this.func_145831_w().func_72938_d((int)w.intX(), (int)w.intZ()).field_76636_d).limit(constructSpeed).collect(Collectors.toSet());
                for (Vector3D vec : fieldToBeProjected) {
                    int flag = 0;
                    for (ItemStack stack : this.getModuleStacks(this.getModuleSlots())) {
                        if (flag != 0 || stack == null || !(stack.func_77973_b() instanceof IModule)) continue;
                        flag = ((IModule)stack.func_77973_b()).onProject((IProjector)this, vec);
                    }
                    if (flag == true || flag == 2) continue;
                    if (!this.field_145850_b.field_72995_K) {
                        this.field_145850_b.func_147465_d(vec.intX(), vec.intY(), vec.intZ(), (Block)BlockForceField.BLOCK_FORCE_FIELD, 0, 2);
                    }
                    this.blocks.add(vec);
                    TileEntity entity = vec.getTileEntity((IBlockAccess)this.field_145850_b);
                    if (!(entity instanceof TileForceField)) continue;
                    ((TileForceField)entity).setProjector(projector);
                }
                this.isComplete = fieldToBeProjected.size() == 0;
            }
        }
    }

    @Override
    public void onSlotsChanged(int ... slots) {
        super.onSlotsChanged(slots);
        this.destroyField();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyField() {
        if (!this.field_145850_b.field_72995_K && !this.isCalc && this.isFinished) {
            Set set = this.calculatedFields;
            synchronized (set) {
                for (IModule module : this.getModules(this.getModuleSlots())) {
                    if (module.onDestroy(this, this.getCalculatedField())) break;
                }
                for (Vector3D vec : new HashSet(this.calculatedFields)) {
                    Block block = this.field_145850_b.func_147439_a(vec.intX(), vec.intY(), vec.intZ());
                    if (!(block instanceof BlockForceField)) continue;
                    this.field_145850_b.func_147468_f(vec.intX(), vec.intY(), vec.intZ());
                }
            }
        }
        this.blocks.clear();
        this.calculatedFields.clear();
        this.isComplete = false;
        this.isFinished = false;
        this.requireTicks = false;
    }

    public List<Item> getFilterItems() {
        ArrayList<Item> stacks = new ArrayList<Item>();
        for (int slot = 26; slot < 32; ++slot) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack == null) continue;
            stacks.add(stack.func_77973_b());
        }
        return stacks;
    }

    public List<ItemStack> getFilterStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int slot = 26; slot < 32; ++slot) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack == null) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    @Override
    public Set<ItemStack> getCards() {
        HashSet<ItemStack> set = new HashSet<ItemStack>();
        set.add(super.getCard());
        set.add(this.func_70301_a(1));
        return set;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return stack.func_77973_b() instanceof ItemCardFrequency;
            }
            case 1: {
                return stack.func_77973_b() instanceof ItemMode;
            }
        }
        if (slot < 26) {
            return stack.func_77973_b() instanceof IModule;
        }
        return true;
    }

    @Override
    public IMessage handleMessage(IMessage imessage) {
        if (imessage instanceof ForcefieldCalculation) {
            ForcefieldCalculation calc = (ForcefieldCalculation)imessage;
            this.getCalculatedField().clear();
            this.getCalculatedField().addAll(calc.getBlocks());
            this.isCalc = true;
            return null;
        }
        if (imessage instanceof BeamRequest) {
            BeamRequest req = (BeamRequest)imessage;
            ModularForcefieldSystem.proxy.registerBeamEffect(this.field_145850_b, req.destination.translate(0.5), new Vector3D(this).translate(0.5), 1.0f, 0.0f, 0.0f, 40);
            ModularForcefieldSystem.proxy.animateFortron(this.field_145850_b, req.destination, 1.0f, 0.0f, 0.0f, 60);
            return null;
        }
        return super.handleMessage(imessage);
    }
}

