/*
 * Decompiled with CFR 0.152.
 */
package com.mffs.common.tile.type;

import com.mffs.api.card.ICard;
import com.mffs.api.card.ICardInfinite;
import com.mffs.api.card.ICoordLink;
import com.mffs.api.fortron.FrequencyGrid;
import com.mffs.api.fortron.IFortronCapacitor;
import com.mffs.api.fortron.IFortronFrequency;
import com.mffs.api.modules.IModule;
import com.mffs.api.utils.FortronHelper;
import com.mffs.api.vector.Vector3D;
import com.mffs.common.TransferMode;
import com.mffs.common.items.modules.upgrades.ItemModuleScale;
import com.mffs.common.items.modules.upgrades.ItemModuleSpeed;
import com.mffs.common.net.packet.EntityToggle;
import com.mffs.common.tile.TileModuleAcceptor;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class TileFortronCapacitor
extends TileModuleAcceptor
implements IFortronCapacitor {
    private TransferMode mode = TransferMode.EQUALIZE;

    public TileFortronCapacitor() {
        this.capacityBase = 700;
        this.capacityBoost = 10;
        this.module_index = (byte)2;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        int cost = this.getFortronCost();
        if (cost > 0) {
            this.requestFortron(cost, true);
        }
        if (this.isActive() && this.ticks % 10 == 0) {
            HashSet<IFortronFrequency> connected = new HashSet<IFortronFrequency>();
            for (ItemStack stack : this.getCards()) {
                if (stack == null) continue;
                if (stack.func_77973_b() instanceof ICardInfinite) {
                    this.setFortronEnergy(this.getFortronCapacity());
                    continue;
                }
                if (!(stack.func_77973_b() instanceof ICoordLink)) continue;
                Coord4D link = ((ICoordLink)stack.func_77973_b()).getLink(stack);
                TileEntity link_machine = link.getTileEntity((IBlockAccess)this.field_145850_b);
                if (link == null || !(link_machine instanceof IFortronFrequency)) continue;
                connected.add(this);
                connected.add((IFortronFrequency)link_machine);
            }
            if (connected.isEmpty()) {
                this.getLinkedDevices(connected);
            }
            FortronHelper.transfer((IFortronFrequency)this, connected, this.mode, this.getTransmissionRate());
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot <= 1) {
            return stack.func_77973_b() instanceof ICard;
        }
        return stack.func_77973_b() instanceof IModule;
    }

    @Override
    public Set<ItemStack> getCards() {
        HashSet<ItemStack> set = new HashSet<ItemStack>();
        set.add(super.getCard());
        set.add(this.func_70301_a(1));
        return set;
    }

    @Override
    public void getLinkedDevices(Set<IFortronFrequency> list) {
        list.addAll(FrequencyGrid.instance().getFortronTiles(this.field_145850_b, new Vector3D(this), this.getTransmissionRange(), this.getFrequency()));
    }

    @Override
    public int getTransmissionRange() {
        return 15 + this.getModuleCount(ItemModuleScale.class, new int[0]);
    }

    @Override
    public int getTransmissionRate() {
        return 250 + 50 * this.getModuleCount(ItemModuleSpeed.class, new int[0]);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("transferMode", (byte)this.mode.ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.mode = TransferMode.values()[nbt.func_74771_c("transferMode")];
    }

    @Override
    public int func_70302_i_() {
        return 5;
    }

    public TransferMode getTransferMode() {
        return this.mode;
    }

    @Override
    public float getAmplifier() {
        return 0.001f;
    }

    @Override
    public IMessage handleMessage(IMessage imessage) {
        if (imessage instanceof EntityToggle) {
            EntityToggle tog = (EntityToggle)imessage;
            if (tog.toggle_opcode == 3) {
                this.mode = this.mode.toggle();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return null;
            }
        }
        return super.handleMessage(imessage);
    }
}

