/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Chunk3D;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;

public class Coord4D {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public int dimensionId;

    public Coord4D(int x, int y, int z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.dimensionId = 0;
    }

    public Coord4D(Entity entity) {
        this.xCoord = (int)entity.field_70165_t;
        this.yCoord = (int)entity.field_70163_u;
        this.zCoord = (int)entity.field_70161_v;
        this.dimensionId = entity.field_70170_p.field_73011_w.field_76574_g;
    }

    public Coord4D(int x, int y, int z, int dimension) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.dimensionId = dimension;
    }

    public Coord4D(MovingObjectPosition mop) {
        this.xCoord = mop.field_72311_b;
        this.yCoord = mop.field_72312_c;
        this.zCoord = mop.field_72309_d;
    }

    public static Coord4D get(TileEntity tileEntity) {
        return new Coord4D(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, tileEntity.func_145831_w().field_73011_w.field_76574_g);
    }

    public static Coord4D read(NBTTagCompound tag) {
        return new Coord4D(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"), tag.func_74762_e("id"));
    }

    public static Coord4D read(ByteBuf dataStream) {
        return new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
    }

    public int getMetadata(IBlockAccess world) {
        return world.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
    }

    public TileEntity getTileEntity(IBlockAccess world) {
        if (world instanceof World && !this.exists((World)world)) {
            return null;
        }
        return world.func_147438_o(this.xCoord, this.yCoord, this.zCoord);
    }

    public Block getBlock(IBlockAccess world) {
        if (world instanceof World && !this.exists((World)world)) {
            return null;
        }
        return world.func_147439_a(this.xCoord, this.yCoord, this.zCoord);
    }

    public NBTTagCompound write(NBTTagCompound nbtTags) {
        nbtTags.func_74768_a("x", this.xCoord);
        nbtTags.func_74768_a("y", this.yCoord);
        nbtTags.func_74768_a("z", this.zCoord);
        nbtTags.func_74768_a("dimensionId", this.dimensionId);
        return nbtTags;
    }

    public void write(ArrayList data) {
        data.add(this.xCoord);
        data.add(this.yCoord);
        data.add(this.zCoord);
        data.add(this.dimensionId);
    }

    public void write(ByteBuf dataStream) {
        dataStream.writeInt(this.xCoord);
        dataStream.writeInt(this.yCoord);
        dataStream.writeInt(this.zCoord);
        dataStream.writeInt(this.dimensionId);
    }

    public Coord4D translate(int x, int y, int z) {
        this.xCoord += x;
        this.yCoord += y;
        this.zCoord += z;
        return this;
    }

    public Coord4D translate(Coord4D coord) {
        this.translate(coord.xCoord, coord.yCoord, coord.zCoord);
        return this;
    }

    public Coord4D getFromSide(ForgeDirection side) {
        return this.getFromSide(side, 1);
    }

    public Coord4D getFromSide(ForgeDirection side, int amount) {
        return new Coord4D(this.xCoord + side.offsetX * amount, this.yCoord + side.offsetY * amount, this.zCoord + side.offsetZ * amount, this.dimensionId);
    }

    public ItemStack getStack(IBlockAccess world) {
        Block block = this.getBlock(world);
        if (block == null || block == Blocks.field_150350_a) {
            return null;
        }
        return new ItemStack(block, 1, this.getMetadata(world));
    }

    public Coord4D difference(Coord4D other) {
        return new Coord4D(this.xCoord - other.xCoord, this.yCoord - other.yCoord, this.zCoord - other.zCoord, this.dimensionId);
    }

    public ForgeDirection sideDifference(Coord4D other) {
        Coord4D diff = this.difference(other);
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (side.offsetX != diff.xCoord || side.offsetY != diff.yCoord || side.offsetZ != diff.zCoord) continue;
            return side;
        }
        return ForgeDirection.UNKNOWN;
    }

    public int distanceTo(Coord4D obj) {
        int subX = this.xCoord - obj.xCoord;
        int subY = this.yCoord - obj.yCoord;
        int subZ = this.zCoord - obj.zCoord;
        return (int)MathHelper.func_76133_a((double)(subX * subX + subY * subY + subZ * subZ));
    }

    public boolean sideVisible(ForgeDirection side, IBlockAccess world) {
        return world.func_147437_c(this.xCoord + side.offsetX, this.yCoord + side.offsetY, this.zCoord + side.offsetZ);
    }

    public NetworkRegistry.TargetPoint getTargetPoint(double range) {
        return new NetworkRegistry.TargetPoint(this.dimensionId, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, range);
    }

    public Coord4D step(ForgeDirection side) {
        return this.translate(side.offsetX, side.offsetY, side.offsetZ);
    }

    public boolean exists(World world) {
        return world.func_72863_F() == null || world.func_72863_F().func_73149_a(this.xCoord >> 4, this.zCoord >> 4);
    }

    public Chunk getChunk(World world) {
        return world.func_72938_d(this.xCoord, this.zCoord);
    }

    public Chunk3D getChunk3D() {
        return new Chunk3D(this);
    }

    public boolean isAirBlock(IBlockAccess world) {
        return world.func_147437_c(this.xCoord, this.yCoord, this.zCoord);
    }

    public boolean isReplaceable(IBlockAccess world) {
        return this.getBlock(world).isReplaceable(world, this.xCoord, this.yCoord, this.zCoord);
    }

    public AxisAlignedBB getBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1));
    }

    public Coord4D clone() {
        return new Coord4D(this.xCoord, this.yCoord, this.zCoord, this.dimensionId);
    }

    public String toString() {
        return "[Coord4D: " + this.xCoord + ", " + this.yCoord + ", " + this.zCoord + ", dim=" + this.dimensionId + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof Coord4D && ((Coord4D)obj).xCoord == this.xCoord && ((Coord4D)obj).yCoord == this.yCoord && ((Coord4D)obj).zCoord == this.zCoord && ((Coord4D)obj).dimensionId == this.dimensionId;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.xCoord;
        code = 31 * code + this.yCoord;
        code = 31 * code + this.zCoord;
        code = 31 * code + this.dimensionId;
        return code;
    }
}

