/*
 * Decompiled with CFR 0.152.
 */
package minechem;

import cpw.mods.fml.client.config.IConfigElement;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class Settings {
    public static Configuration config;
    public static boolean generateOre;
    public static int UraniumOreClusterSize;
    public static int UraniumOreDensity;
    public static boolean DebugMode;
    public static int UpdateRadius;
    public static boolean AllowAutomation;
    public static int halfLifeMultiplier;
    public static int recursiveDepth;
    public static boolean advancedTurtleAI;
    public static boolean FoodSpiking;
    public static boolean SwordEffects;
    public static boolean fluidEffects;
    public static boolean decaySafeMachines;
    public static boolean powerUseEnabled;
    public static int costDecomposition;
    public static int synthesisMultiplier;
    public static int fusionMultiplier;
    public static int fissionMultiplier;
    public static int energyPacketSize;
    public static int maxSynthesizerStorage;
    public static int maxDecomposerStorage;
    public static int maxFissionStorage;
    public static int maxFusionStorage;
    public static boolean reactionItemMeetFluid;
    public static boolean reactionFluidMeetFluid;
    public static boolean supportNEI;
    public static String[] DecomposerBlacklist;
    public static String[] SynthesisMachineBlacklist;
    public static ArrayList<ItemStack> decomposerBlacklist;
    public static ArrayList<ItemStack> synthesisBlacklist;
    public static boolean displayMoleculeEffects;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            Settings.loadConfig();
        }
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("minechem")) {
            Settings.loadConfig();
        }
    }

    private static void loadConfig() {
        ArrayList<String> configList = new ArrayList<String>();
        config.addCustomCategoryComment("worldgen", StatCollector.func_74838_a((String)"config.worldgen.description"));
        config.addCustomCategoryComment("blacklist", StatCollector.func_74838_a((String)"config.blacklist.description"));
        config.addCustomCategoryComment("power", StatCollector.func_74838_a((String)"config.power.description"));
        config.addCustomCategoryComment("general", StatCollector.func_74838_a((String)"config.general.description"));
        Property prop = config.get("general", "displayMoleculeEffects", displayMoleculeEffects);
        prop.comment = StatCollector.func_74838_a((String)"config.moleculeEffects.description");
        displayMoleculeEffects = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("worldgen", "generateOre", generateOre);
        prop.comment = StatCollector.func_74838_a((String)"config.worldgen.ore.description");
        prop.setLanguageKey("config.worldgen.ore.tooltip");
        generateOre = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("worldgen", "uraniumOreClusterSize", UraniumOreClusterSize);
        prop.setMinValue(1).setMaxValue(10);
        prop.comment = StatCollector.func_74838_a((String)"config.uraniumoreclustersize.description");
        prop.setLanguageKey("config.uraniumoreclustersize");
        UraniumOreClusterSize = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("worldgen", "uraniumoredensity", UraniumOreDensity);
        prop.setMinValue(1).setMaxValue(64);
        prop.comment = StatCollector.func_74838_a((String)"config.uraniumoredensity.description");
        prop.setLanguageKey("config.uraniumoredensity");
        UraniumOreDensity = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("general", "debugMode", DebugMode);
        prop.comment = StatCollector.func_74838_a((String)"config.debugmode.description");
        prop.setLanguageKey("config.debugmode");
        DebugMode = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "advancedTurtleAI", advancedTurtleAI);
        prop.comment = StatCollector.func_74838_a((String)"config.advancedTurtleAI.description");
        prop.setLanguageKey("config.advancedTurtleAI");
        advancedTurtleAI = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "updateRadius", UpdateRadius);
        prop.setMinValue(1).setMaxValue(50);
        prop.comment = StatCollector.func_74838_a((String)"config.updateradius.description");
        prop.setLanguageKey("config.updateradius");
        UpdateRadius = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("general", "allowAutomation", AllowAutomation);
        prop.comment = StatCollector.func_74838_a((String)"config.allowautomation.description");
        prop.setLanguageKey("config.allowautomation");
        AllowAutomation = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "foodSpiking", FoodSpiking);
        prop.comment = StatCollector.func_74838_a((String)"config.foodspiking.description");
        prop.setLanguageKey("config.foodspiking");
        FoodSpiking = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "swordEffects", SwordEffects);
        prop.comment = StatCollector.func_74838_a((String)"config.swordeffects.description");
        prop.setLanguageKey("config.swordeffects");
        SwordEffects = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "halfLifeMultiplier", UpdateRadius);
        prop.setMinValue(1).setMaxValue(200);
        prop.comment = StatCollector.func_74838_a((String)"config.halfLifeMultiplier.description");
        prop.setLanguageKey("config.halfLifeMultiplier");
        halfLifeMultiplier = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("power", "recursiveDepth", recursiveDepth);
        prop.setMinValue(3).setMaxValue(20).requiresMcRestart();
        prop.comment = StatCollector.func_74838_a((String)"config.recursiveDepth.description");
        prop.setLanguageKey("config.recursiveDepth.name");
        recursiveDepth = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("general", "decaySafeMachines", SwordEffects);
        prop.comment = StatCollector.func_74838_a((String)"config.decaySafeMachines.description");
        prop.setLanguageKey("config.decaySafeMachines");
        decaySafeMachines = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "fluidEffects", SwordEffects);
        prop.comment = StatCollector.func_74838_a((String)"config.fluideffects.description");
        prop.setLanguageKey("config.fluideffects");
        fluidEffects = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "reactionItemMeetFluid", reactionItemMeetFluid);
        prop.comment = StatCollector.func_74838_a((String)"config.reactionItemMeetFluid.description");
        prop.setLanguageKey("config.reactionItemMeetFluid");
        reactionItemMeetFluid = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "reactionFluidMeetFluid", reactionFluidMeetFluid);
        prop.comment = StatCollector.func_74838_a((String)"config.reactionFluidMeetFluid.description");
        prop.setLanguageKey("config.reactionFluidMeetFluid");
        reactionFluidMeetFluid = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "supportNEI", reactionFluidMeetFluid);
        prop.comment = StatCollector.func_74838_a((String)"config.supportNEI.description");
        prop.setLanguageKey("config.supportNEI");
        supportNEI = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("blacklist", "decomposition", new String[]{"minecra*:dirt", "minecraft:wool:4", "ore:ore*", "mekanism:*"});
        prop.setLanguageKey("config.blacklist.decomposition.tooltip").setRequiresMcRestart(true);
        prop.comment = StatCollector.func_74838_a((String)"config.blacklist.decomposition.example");
        DecomposerBlacklist = prop.getStringList();
        configList.add(prop.getName());
        prop = config.get("blacklist", "synthesis", new String[]{"minecraft:diamond", "ore:ingotIron", "*:dragon_egg"});
        prop.setLanguageKey("config.blacklist.synthesis.tooltip").setRequiresMcRestart(true);
        prop.comment = StatCollector.func_74838_a((String)"config.blacklist.synthesis.example");
        SynthesisMachineBlacklist = prop.getStringList();
        configList.add(prop.getName());
        prop = config.get("power", "enable", powerUseEnabled);
        prop.comment = StatCollector.func_74838_a((String)"config.power.enable.description");
        prop.setLanguageKey("config.power.enable.name").setRequiresMcRestart(true);
        powerUseEnabled = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("power", "maxDecomposerStorage", maxDecomposerStorage);
        prop.comment = StatCollector.func_74838_a((String)"config.power.decomposer.max.description");
        prop.setLanguageKey("config.power.decomposer.max.name");
        maxDecomposerStorage = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("power", "costDecomposition", costDecomposition);
        prop.setMinValue(1).setMaxValue(maxDecomposerStorage);
        prop.comment = StatCollector.func_74838_a((String)"config.power.decomposer.cost.description");
        prop.setLanguageKey("config.power.decomposer.cost.name");
        costDecomposition = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("power", "maxSynthesizerStorage", maxSynthesizerStorage);
        prop.comment = StatCollector.func_74838_a((String)"config.power.synthesizer.max.description");
        prop.setLanguageKey("config.power.synthesizer.max.name");
        maxSynthesizerStorage = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("power", "energyPacketSize", energyPacketSize);
        prop.comment = StatCollector.func_74838_a((String)"config.power.energyPacketSize.description");
        prop.setLanguageKey("config.power.energyPacketSize.max.name");
        energyPacketSize = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("power", "costSythesisMultiplier", synthesisMultiplier);
        prop.setMinValue(1).setMaxValue(100);
        prop.comment = StatCollector.func_74838_a((String)"config.power.synthesizer.cost.description");
        prop.setLanguageKey("config.power.synthesizer.cost.name");
        synthesisMultiplier = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("power", "costFissionMultiplier", fissionMultiplier);
        prop.setMinValue(1).setMaxValue(100);
        prop.comment = StatCollector.func_74838_a((String)"config.power.fission.cost.description");
        prop.setLanguageKey("config.power.fusion.cost.name");
        fissionMultiplier = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("power", "maxFissionStorage", maxFissionStorage);
        prop.comment = StatCollector.func_74838_a((String)"config.power.fission.max.description");
        prop.setLanguageKey("config.power.fission.max.name");
        maxFissionStorage = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("power", "costFusionMultiplier", fusionMultiplier);
        prop.setMinValue(1).setMaxValue(100);
        prop.comment = StatCollector.func_74838_a((String)"config.power.fusion.cost.description");
        prop.setLanguageKey("config.power.fusion.cost.name");
        fusionMultiplier = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("power", "maxFusionStorage", maxFusionStorage);
        prop.comment = StatCollector.func_74838_a((String)"config.power.fusion.max.description");
        prop.setLanguageKey("config.power.fusion.max.name");
        maxFusionStorage = prop.getInt();
        configList.add(prop.getName());
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(config.getCategory("worldgen")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("blacklist")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("power")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("general")).getChildElements());
        return list;
    }

    static {
        generateOre = true;
        UraniumOreClusterSize = 3;
        UraniumOreDensity = 5;
        DebugMode = false;
        UpdateRadius = 20;
        AllowAutomation = true;
        halfLifeMultiplier = 100;
        recursiveDepth = 10;
        advancedTurtleAI = false;
        FoodSpiking = true;
        SwordEffects = true;
        fluidEffects = true;
        decaySafeMachines = false;
        powerUseEnabled = true;
        costDecomposition = 1000;
        synthesisMultiplier = 10;
        fusionMultiplier = 100;
        fissionMultiplier = 100;
        energyPacketSize = 100;
        maxSynthesizerStorage = 100000;
        maxDecomposerStorage = 10000;
        maxFissionStorage = 100000;
        maxFusionStorage = 100000;
        reactionItemMeetFluid = true;
        reactionFluidMeetFluid = true;
        supportNEI = true;
        DecomposerBlacklist = new String[0];
        SynthesisMachineBlacklist = new String[0];
    }
}

