/*
 * Decompiled with CFR 0.152.
 */
package minechem.api;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import minechem.api.MinechemClassesAccess;

public class ChemicalAPI {
    public static boolean registerMolecule(int id, String name, float colorRed, float colorGreen, float colorBlue, float colorRed2, float colorGreen2, float colorBlue2, String roomStatus, Object ... molecule) {
        if (!MinechemClassesAccess.isMinechemInstalled) {
            return false;
        }
        List<Object> chemicals = ChemicalAPI.toChemicalsWithAmount(molecule);
        Object roomstatus = ChemicalAPI.getRoomStatus(roomStatus);
        try {
            Method addMolecule = MinechemClassesAccess.classMoleculeEnum.getDeclaredMethod("addMolecule", String.class, Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, MinechemClassesAccess.classChemicalRoomStateEnum, MinechemClassesAccess.classArrayPotionChemical);
            addMolecule.invoke(null, name, id, Float.valueOf(colorRed), Float.valueOf(colorGreen), Float.valueOf(colorBlue), Float.valueOf(colorRed2), Float.valueOf(colorGreen2), Float.valueOf(colorBlue2), roomstatus, chemicals.toArray((Object[])Array.newInstance(MinechemClassesAccess.classPotionChemical, chemicals.size())));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean registerMolecule(int id, String name, String roomStatus, Object ... molecule) {
        if (!MinechemClassesAccess.isMinechemInstalled) {
            return false;
        }
        List<Object> chemicals = ChemicalAPI.toChemicalsWithAmount(molecule);
        Object roomstatus = ChemicalAPI.getRoomStatus(roomStatus);
        try {
            Method addMolecule = MinechemClassesAccess.classMoleculeEnum.getDeclaredMethod("addMolecule", String.class, Integer.TYPE, MinechemClassesAccess.classChemicalRoomStateEnum, MinechemClassesAccess.classArrayPotionChemical);
            addMolecule.invoke(null, name, id, roomstatus, chemicals.toArray((Object[])Array.newInstance(MinechemClassesAccess.classPotionChemical, chemicals.size())));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean registerFluidChemicalReaction(String chemicalA, String chemicalB, float explosionLevel, String ... outputChemicals) {
        if (!MinechemClassesAccess.isMinechemInstalled) {
            return false;
        }
        try {
            List<Object> chemicals = ChemicalAPI.toChemicals(outputChemicals);
            Object rule = MinechemClassesAccess.classChemicalFluidReactionRule.getConstructor(MinechemClassesAccess.classMinechemChemicalType, MinechemClassesAccess.classMinechemChemicalType).newInstance(ChemicalAPI.getChemicalType(chemicalA), ChemicalAPI.getChemicalType(chemicalB));
            Object output = MinechemClassesAccess.classChemicalFluidReactionOutput.getConstructor(List.class, Float.TYPE).newInstance(chemicals, Float.valueOf(explosionLevel));
            ((Map)MinechemClassesAccess.classChemicalFluidReactionHandler.getDeclaredField("reactionRules").get(null)).put(rule, output);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static List<Object> toChemicals(String[] chemicalsStr) {
        ArrayList<Object> chemicals = new ArrayList<Object>();
        for (int i = 0; i < chemicalsStr.length; ++i) {
            chemicals.add(ChemicalAPI.getChemicalType(chemicalsStr[i]));
        }
        return chemicals;
    }

    private static List<Object> toChemicalsWithAmount(Object[] chemicalsStr) {
        ArrayList<Object> chemicals = new ArrayList<Object>();
        int pos = 0;
        while (pos < chemicalsStr.length) {
            if (chemicalsStr[pos] instanceof Integer) {
                chemicals.add(ChemicalAPI.createChemical(ChemicalAPI.getChemicalType((String)chemicalsStr[pos + 1]), (Integer)chemicalsStr[pos]));
                pos += 2;
                continue;
            }
            if (chemicalsStr[pos] instanceof String) {
                chemicals.add(ChemicalAPI.createChemical(ChemicalAPI.getChemicalType((String)chemicalsStr[pos]), 1));
                ++pos;
                continue;
            }
            throw new IllegalArgumentException("unknown argument");
        }
        return chemicals;
    }

    private static Object getChemicalType(String name) {
        try {
            Method getByNameElement = MinechemClassesAccess.classElementEnum.getDeclaredMethod("getByName", String.class);
            Object element = getByNameElement.invoke(null, name);
            if (element != null) {
                return element;
            }
            Method getByNameMolecule = MinechemClassesAccess.classMoleculeEnum.getDeclaredMethod("getByName", String.class);
            return getByNameMolecule.invoke(null, name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object createChemical(Object chemical, int amount) {
        try {
            if (chemical.getClass() == MinechemClassesAccess.classElementEnum) {
                return MinechemClassesAccess.classElement.getConstructor(MinechemClassesAccess.classElementEnum, Integer.TYPE).newInstance(chemical, amount);
            }
            if (chemical.getClass() == MinechemClassesAccess.classMoleculeEnum) {
                return MinechemClassesAccess.classMolecule.getConstructor(MinechemClassesAccess.classMoleculeEnum, Integer.TYPE).newInstance(chemical, amount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Object getRoomStatus(String roomStatus) {
        try {
            return MinechemClassesAccess.classChemicalRoomStateEnum.getField(roomStatus).get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

