/*
 * Decompiled with CFR 0.152.
 */
package minechem.fluid;

import java.util.Set;
import minechem.MinechemItemsRegistration;
import minechem.fluid.FluidHelper;
import minechem.item.MinechemChemicalType;
import minechem.item.element.ElementEnum;
import minechem.item.element.ElementItem;
import minechem.item.molecule.MoleculeEnum;
import minechem.item.molecule.MoleculeItem;
import minechem.radiation.RadiationFluidTileEntity;
import minechem.radiation.RadiationInfo;
import minechem.utils.MinechemUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class FluidChemicalDispenser
implements IBehaviorDispenseItem {
    public static void init() {
        FluidChemicalDispenser dispenser = new FluidChemicalDispenser();
        BlockDispenser.field_149943_a.func_82595_a((Object)MinechemItemsRegistration.element, (Object)dispenser);
        BlockDispenser.field_149943_a.func_82595_a((Object)MinechemItemsRegistration.molecule, (Object)dispenser);
    }

    public ItemStack func_82482_a(IBlockSource blockSource, ItemStack itemStack) {
        EnumFacing enumfacing = BlockDispenser.func_149937_b((int)blockSource.func_82620_h());
        World world = blockSource.func_82618_k();
        int x = blockSource.func_82623_d() + enumfacing.func_82601_c();
        int y = blockSource.func_82622_e() + enumfacing.func_96559_d();
        int z = blockSource.func_82621_f() + enumfacing.func_82599_e();
        TileEntity inventoryTile = blockSource.func_150835_j();
        if (itemStack.func_77973_b() instanceof ElementItem && itemStack.func_77960_j() != 0) {
            ItemStack stack;
            Block frontBlock = world.func_147439_a(x, y, z);
            MinechemChemicalType chemical = MinechemUtil.getChemical(frontBlock);
            if (chemical != null && MinechemUtil.canDrain(world, frontBlock, x, y, z) && (stack = MinechemUtil.createItemStack(chemical, 8)) != null) {
                if (itemStack.field_77994_a >= 8) {
                    itemStack.field_77994_a -= 8;
                } else if (inventoryTile instanceof IInventory) {
                    int needs = 8 - itemStack.field_77994_a;
                    IInventory inventory = (IInventory)inventoryTile;
                    Set<ItemStack> otherTubes = MinechemUtil.findItemStacks(inventory, MinechemItemsRegistration.element, 0);
                    int free = 0;
                    otherTubes.remove(itemStack);
                    for (ItemStack emptyStack : otherTubes) {
                        free += emptyStack.field_77994_a;
                    }
                    if (free < needs) {
                        return itemStack;
                    }
                    itemStack.field_77994_a = 0;
                    for (ItemStack emptyStack : otherTubes) {
                        if (emptyStack.field_77994_a >= needs) {
                            emptyStack.field_77994_a -= needs;
                            needs = 0;
                        } else {
                            needs -= emptyStack.field_77994_a;
                            emptyStack.field_77994_a = 0;
                        }
                        if (emptyStack.field_77994_a <= 0) {
                            MinechemUtil.removeStackInInventory(inventory, emptyStack);
                        }
                        if (needs != 0) continue;
                        break;
                    }
                }
                TileEntity tile = world.func_147438_o(x, y, z);
                if (tile instanceof RadiationFluidTileEntity && ((RadiationFluidTileEntity)tile).info != null) {
                    RadiationInfo.setRadiationInfo(((RadiationFluidTileEntity)tile).info, stack);
                }
                world.func_147468_f(x, y, z);
                if (inventoryTile instanceof IInventory) {
                    stack = MinechemUtil.addItemToInventory((IInventory)inventoryTile, stack);
                }
                MinechemUtil.throwItemStack(world, stack, x, y, z);
            }
        } else {
            Block block;
            if (!(inventoryTile instanceof IInventory)) {
                return itemStack;
            }
            IInventory inventory = (IInventory)inventoryTile;
            if (itemStack.func_77973_b() instanceof ElementItem) {
                ElementEnum element = ElementItem.getElement(itemStack);
                block = (Block)FluidHelper.elementsBlocks.get((Object)FluidHelper.elements.get(element));
            } else if (itemStack.func_77973_b() instanceof MoleculeItem) {
                MoleculeEnum molecule = MoleculeEnum.getById(itemStack.func_77960_j());
                block = (Block)FluidHelper.moleculeBlocks.get((Object)FluidHelper.molecules.get(molecule));
            } else {
                return itemStack;
            }
            if (!world.func_147437_c(x, y, z) && !world.func_147439_a(x, y, z).func_149688_o().func_76220_a()) {
                world.func_147480_a(x, y, z, true);
                world.func_147468_f(x, y, z);
            }
            if (world.func_147437_c(x, y, z)) {
                RadiationInfo radioactivity = ElementItem.getRadiationInfo(itemStack, world);
                long worldtime = world.func_82737_E();
                long leftTime = radioactivity.radioactivity.getLife() - (worldtime - radioactivity.decayStarted);
                if (itemStack.field_77994_a >= 8) {
                    itemStack.field_77994_a -= 8;
                } else {
                    int needs = 8 - itemStack.field_77994_a;
                    itemStack.field_77994_a = 0;
                    Set<ItemStack> otherItemsStacks = MinechemUtil.findItemStacks(inventory, itemStack.func_77973_b(), itemStack.func_77960_j());
                    otherItemsStacks.remove(itemStack);
                    int free = 0;
                    for (ItemStack stack : otherItemsStacks) {
                        free += stack.field_77994_a;
                    }
                    if (free < needs) {
                        return itemStack;
                    }
                    for (ItemStack stack : otherItemsStacks) {
                        RadiationInfo anotherRadiation = ElementItem.getRadiationInfo(stack, world);
                        long anotherLeft = anotherRadiation.radioactivity.getLife() - (worldtime - anotherRadiation.decayStarted);
                        if (anotherLeft < leftTime) {
                            radioactivity = anotherRadiation;
                            leftTime = anotherLeft;
                        }
                        if (stack.field_77994_a >= needs) {
                            stack.field_77994_a -= needs;
                            needs = 0;
                        } else {
                            needs -= stack.field_77994_a;
                            stack.field_77994_a = 0;
                        }
                        if (stack.field_77994_a <= 0) {
                            MinechemUtil.removeStackInInventory(inventory, stack);
                        }
                        if (needs != 0) continue;
                        break;
                    }
                }
                ItemStack empties = MinechemUtil.addItemToInventory(inventory, new ItemStack((Item)MinechemItemsRegistration.element, 8, 0));
                MinechemUtil.throwItemStack(world, empties, x, y, z);
                world.func_147465_d(x, y, z, block, 0, 3);
                TileEntity tile = world.func_147438_o(x, y, z);
                if (radioactivity.isRadioactive() && tile instanceof RadiationFluidTileEntity) {
                    ((RadiationFluidTileEntity)tile).info = radioactivity;
                }
            }
            return itemStack;
        }
        return itemStack;
    }
}

